/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* settings.c	settings dialog for xconvers
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Separator.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/ToggleB.h>

#include "xconvers.h"
#include "settings.h"



/*---------------------------------------------------------------------------
 * SettingsCB  open settings-dialog (menu-CB)
 */
void SettingsCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  SettingsDialog(app_w);
}


/*---------------------------------------------------------------------------
 * SettingOkCB  get data from text widgets + kill dialog
 */
void SettingOkCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  SetWidgets *set_w = (SetWidgets*) client_data;

  SetSettings(set_w);
  XtSetSensitive(set_w->button_settings, True);    
  XtDestroyWidget(XtParent(set_w->form));
}



/*---------------------------------------------------------------------------
 * SettingApplyCB  get data from text widget
 */
void SettingApplyCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  SetWidgets *set_w = (SetWidgets*) client_data;

  SetSettings(set_w);
}

/*---------------------------------------------------------------------------
 * SettingCancelCB  cancel Dialog
 */
void SettingCancelCB(button, client_data, call_data)
	Widget	button;
	caddr_t	client_data;
	caddr_t	call_data;
{
  SetWidgets *set_w = (SetWidgets*) client_data;
  XtSetSensitive(set_w->button_settings, True);    
  XtDestroyWidget(XtParent(set_w->form));
}

/*---------------------------------------------------------------------------
 *  GetSettings   get data from structure; put into form
 */
void GetSettings(set_w)
	SetWidgets	*set_w;
{
  XmTextSetString(set_w->server, set_w->set->server);
  XmTextSetString(set_w->port, set_w->set->port);
  XmTextSetString(set_w->channel, set_w->set->channel);
  XmTextSetString(set_w->name, set_w->set->name);
  XmTextSetString(set_w->pnote, set_w->set->pnote);
}

/*---------------------------------------------------------------------------
 *  SetSettings   get data from form; put into structure
 */
void SetSettings(set_w)
	SetWidgets	*set_w;
{
  char	*string;

  string = XmTextGetString(set_w->server);
  strcpy(set_w->set->server, string);
  XtFree(string);

  string = XmTextGetString(set_w->port);
  strcpy(set_w->set->port, string);
  XtFree(string);

  string = XmTextGetString(set_w->channel);
  strcpy(set_w->set->channel, string);
  XtFree(string);

  string = XmTextGetString(set_w->name);
  strcpy(set_w->set->name, string);
  XtFree(string);

  string = XmTextGetString(set_w->pnote);
  strcpy(set_w->set->pnote, string);
  XtFree(string);
}


/*---------------------------------------------------------------------------
 *  CreateeInputLine   create form-widget with label and text-widget.
 */
Widget CreateInputLine(parent, line_name, label_name, text_name, top, new_top, set_w)
	Widget		parent;
	char		*line_name, *label_name, *text_name;
 	Widget		top, *new_top;
        SetWidgets	*set_w;
{
  Widget	line, label, text;
  Arg		arg[4];
  Cardinal	n;

  n = 0;
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNtopWidget, top); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  line = XmCreateForm(parent, line_name, arg, n);
  XtManageChild(line);
 
  /* "new_top" for  attachment of next line */

  *new_top = line;

  n = 0;
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  label = XmCreateLabel(line, label_name, arg, n);
  XtManageChild(label);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNleftWidget, label); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  text = XmCreateText(line,text_name, arg, n);
  XtManageChild(text);

  return(text);
}

/*---------------------------------------------------------------------------
 *  CreateCmds  create line with horizontal located buttons
 */
Widget CreateCmds(parent, set_w)
	Widget		parent;
	SetWidgets	*set_w;
{
  Widget	line, button;
  Arg		arg[7];
  Cardinal	n; 
   
  n = 0;
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNbottomOffset, 5); n++;
  XtSetArg(arg[n], XmNleftOffset, 10); n++;
  line = XtCreateManagedWidget("buttons", xmFormWidgetClass, parent, arg, n); 
  
  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  button = XtCreateManagedWidget("ok", xmPushButtonWidgetClass, line, arg, n);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)SettingOkCB, set_w);

  /* -- default button -- */
  n = 0;
  XtSetArg(arg[n], XmNshowAsDefault, True); n++;
  XtSetValues(button, arg, n);
  n = 0;
  XtSetArg(arg[n], XmNdefaultButton, button); n++;
  XtSetValues(parent, arg, n);

  n = 0;
  XtSetArg(arg[n], XmNleftWidget, button); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_FORM); n++; 
  XtSetArg(arg[n], XmNleftOffset, 10); n++;
  XtSetArg(arg[n], XmNtopOffset, 5); n++;
  button = XtCreateManagedWidget("apply", xmPushButtonWidgetClass, line, arg, n);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)SettingApplyCB, set_w);

  XtSetArg(arg[0], XmNleftWidget, button);
  button = XtCreateManagedWidget("cancel", xmPushButtonWidgetClass, line, arg, n);
  XtAddCallback(button, XmNactivateCallback, (XtCallbackProc)SettingCancelCB, set_w);

  return(line);
}

/*---------------------------------------------------------------------------
 * SettingsDialog  
 */
void SettingsDialog(app_w)
	AppWidgets	*app_w;
{
  Widget	shell, form, title, new_top, sep, buttons;
  Arg		arg[10];
  Cardinal	n; 
  SetWidgets	*set_w;		/* pointer to dialog */

  set_w = (SetWidgets*)XtMalloc(sizeof(SetWidgets));	
  set_w->set = app_w->set;	/* pointer to data */
  XtSetSensitive(app_w->button_settings, False);
  set_w->button_settings = app_w->button_settings;

  n = 0;
  form = XmCreateFormDialog(app_w->form, "settings", arg, n); 
  set_w->form = form;
  XtAddCallback(form, XmNdestroyCallback, (XtCallbackProc)SettingCancelCB, set_w);

  shell = XtParent(form);
  n = 0;
  XtSetArg(arg[n], XmNdeleteResponse, XmDESTROY); n++;
  XtSetValues(shell, arg, n);

  n = 0;
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++; 
  title = XmCreateLabel(form, "title", arg, n);
  XtManageChild(title);

  /* inputlines */
  set_w->server = 
	CreateInputLine(form, "serverLine", "serverLabel", "serverInput", title, &new_top, set_w);

  set_w->port = 
	CreateInputLine(form, "portLine", "portLabel", "portInput", new_top, &new_top, set_w);

  set_w->channel = 
	CreateInputLine(form, "channelLine", "channelLabel", "channelInput", new_top, &new_top, set_w);

  set_w->name = 
	CreateInputLine(form, "nameLine", "nameLabel", "nameInput", new_top, &new_top, set_w);

  set_w->pnote = 
	CreateInputLine(form, "pnoteLine", "pnoteLabel", "pnoteInput", new_top, &new_top, set_w);

  GetSettings(set_w);	/* Zeilen fuellen */
 
  /* commandbuttons in bottomline */
  buttons = CreateCmds(form, set_w);

  n = 0;
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNbottomWidget, buttons); n++;
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
  XtSetArg(arg[n], XmNtopWidget, new_top); n++;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNtopOffset, 5); n++;
  XtSetArg(arg[n], XmNbottomOffset, 5); n++;
  sep = XmCreateSeparator(form, "sep", arg, n);
  XtManageChild(sep);
  XtManageChild(form);
}

