/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997 Ted Williams WA0EIR (ted@bluestone.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Versions: 1.2 -  Nov 1998 
 */

#include "twlog.h"

/*
 * build_widgets Function
 * Passed the main shell and the log_res resources array.
 * log_res is used for creating buttons on the option menus.
 */
void build_widgets (Widget logSH, LogRes log_res)
{
   int i, btn_cnt;
   Arg args[20];
   XmString xs[10];

   Widget form1, menuBar, rc1, fileMenu, helpMenu;
   Widget datePB, startPB,  callsignLabel;
   Widget bandLabel;
   Widget modeLabel;
   Widget pwrLabel;
   Widget rst1Label, rst2Label, endPB, notesLabel;
   Widget dateTF, startTF, callsignTF;
   Widget bandMenu, modeMenu, powerMenu;
   Widget rst1TF, rst2TF, endTF, notesTF;
   String transTable = "<Key>Return:  CRkey()";
   
   /* These are used to pass stuff around */
   static Cdata dateCdata, startCdata, endCdata;
   static Widget col_2_wids[10];
   
   /*
    * TOP FORM
    */
   form1 = XtVaCreateWidget ("form1", xmFormWidgetClass, logSH,
              NULL);
   /*
    * Make the main menu bar.
    */
   xs[0] = XmStringCreateLocalized ("File");
   xs[1] = XmStringCreateLocalized ("Help");
   menuBar = XmVaCreateSimpleMenuBar (form1, "menuBar",
                XmVaCASCADEBUTTON, xs[0], 'F', 
                XmVaCASCADEBUTTON, xs[1], 'H',
                NULL);
   XmStringFree (xs[0]);
   XmStringFree (xs[1]);
                   
   XtVaSetValues (menuBar,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNmenuAccelerator, "<KeyUp>F10",
      XmNmenuHelpWidget, XtNameToWidget(menuBar, "button_1"),
      NULL);

   /*
    * File Pulldown Menu
    * Creates the pulldown menu for the File button.  All callbacks
    * go to the fileCB() function.  Hangs the address of col_2_wids
    * on the userData of the menu rowColumn.  This will be used by
    * a callbacks.
    */
   xs[0] = XmStringCreateLocalized ("Append");
   xs[1] = XmStringCreateLocalized ("Edit Log");
   xs[2] = XmStringCreateLocalized ("Print Log");
   xs[3] = XmStringCreateLocalized ("New Log");
   xs[4] = XmStringCreateLocalized ("QRT");
   xs[5] = XmStringCreateLocalized ("Ctrl-A");
   xs[6] = XmStringCreateLocalized ("Ctrl-E");
   xs[7] = XmStringCreateLocalized ("Ctrl-P");
   xs[8] = XmStringCreateLocalized ("Ctrl-N");
   xs[9] = XmStringCreateLocalized ("Ctrl-Q");
   fileMenu = XmVaCreateSimplePulldownMenu (menuBar, "fileMenu", 0, fileCB,
                 XmVaPUSHBUTTON, xs[0], 'A', "Ctrl<Key>A", xs[5],
                 XmVaPUSHBUTTON, xs[1], 'E', "Ctrl<Key>E", xs[6],
                 XmVaPUSHBUTTON, xs[2], 'P', "Ctrl<Key>P", xs[7],
                 XmVaPUSHBUTTON, xs[3], 'N', "Ctrl<Key>N", xs[8],
                 XmVaSEPARATOR,
                 XmVaPUSHBUTTON, xs[4], 'Q', "Ctrl<Key>Q", xs[9],
                 NULL);
   XmStringFree (xs[0]);
   XmStringFree (xs[1]);
   XmStringFree (xs[2]);
   XmStringFree (xs[3]);
   XmStringFree (xs[4]);
   XmStringFree (xs[5]);
   XmStringFree (xs[6]);
   XmStringFree (xs[7]);
   XmStringFree (xs[8]);
   XmStringFree (xs[9]);

   XtVaSetValues (fileMenu,
          XmNuserData, &col_2_wids,
          NULL);

   /*
    * Help Pulldown Menu
    * Creates the pulldown menu for the File button. All callbacks go to
    * the helpCB() function.
    */
   xs[0] = XmStringCreateLocalized ("About");
   xs[1] = XmStringCreateLocalized ("Help");
   helpMenu = XmVaCreateSimplePulldownMenu (menuBar, "helpMenu", 1, helpCB,
                 XmVaPUSHBUTTON, xs[0], 'A', NULL, NULL,
                 XmVaPUSHBUTTON, xs[1], 'H', NULL, NULL,
                 NULL);
   XmStringFree (xs[0]);
   XmStringFree (xs[1]);

  /*
   * Data Entry Form
   * This is the data entry form for the log.  Column 1 (lefthand side
   * of the rowColumn) is pushbuttons and labels.  XS_CONVERT is a res
   * converter macro defined in twlog.h
   */
   rc1 = XtVaCreateWidget ("rc1",
            xmRowColumnWidgetClass, form1,
            XmNnumColumns, 2,
            XmNadjustLast, TRUE,
            XmNentryAlignment, XmALIGNMENT_CENTER,
            XmNpacking, XmPACK_COLUMN,
            XmNorientation, XmVERTICAL,
            XmNleftAttachment, XmATTACH_FORM,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNrightAttachment, XmATTACH_FORM,
            XmNtopAttachment, XmATTACH_WIDGET,
            XmNtopWidget, menuBar,
            XmNisAligned, TRUE,
            NULL);

   /*
    * Column 1
    */
   datePB = XtVaCreateManagedWidget ("datePB",
               xmPushButtonWidgetClass, rc1,
               XmNnavigationType, XmTAB_GROUP,
               XS_CONVERT (XmNlabelString, "Date:"),
               NULL);
      
   startPB = XtVaCreateManagedWidget ("startPB",
                xmPushButtonWidgetClass, rc1,
                XmNnavigationType, XmTAB_GROUP,
                XS_CONVERT (XmNlabelString, "Start Time:"),
                NULL);

   callsignLabel = XtVaCreateManagedWidget ("callLabel",
                      xmLabelWidgetClass, rc1,
                      XS_CONVERT (XmNlabelString, "Call:"),
                      NULL);

   bandLabel = XtVaCreateManagedWidget ("bandLabel",
                  xmLabelWidgetClass, rc1,
                  XS_CONVERT (XmNlabelString, "Band:"),
                  NULL);

   modeLabel = XtVaCreateManagedWidget ("modeLabel",
                  xmLabelWidgetClass, rc1,
                  XS_CONVERT (XmNlabelString, "Mode:"),
                  NULL);

   pwrLabel = XtVaCreateManagedWidget ("pwrLabel",
                  xmLabelWidgetClass, rc1,
                  XS_CONVERT (XmNlabelString, "Power:"),
                  NULL);

   rst1Label = XtVaCreateManagedWidget ("rst1Label",
                  xmLabelWidgetClass, rc1,
                  XS_CONVERT (XmNlabelString, "His RST:"),
                  NULL);

   rst2Label = XtVaCreateManagedWidget ("rst2Label",
                  xmLabelWidgetClass, rc1,
                  XS_CONVERT (XmNlabelString, "My RST:"),
                  NULL);

   notesLabel = XtVaCreateManagedWidget ("notesLabel",
                   xmLabelWidgetClass, rc1,
                   XS_CONVERT (XmNlabelString, "Notes:"),
                   NULL);

   endPB = XtVaCreateManagedWidget ("endPB",
              xmPushButtonWidgetClass, rc1,
              XmNnavigationType, XmTAB_GROUP, 
              XS_CONVERT (XmNlabelString, "End Time:"),
              NULL);
   /*
    * End Column 1
    */
   
   /*
    * Column 2
    * The righthand side of the data entry form is textFields
    * and Option menus.
    */
   dateTF = XtVaCreateManagedWidget ("dateTF",
               xmTextFieldWidgetClass, rc1,
               XmNcolumns, NUMCOLS,
               NULL);   

   startTF = XtVaCreateManagedWidget ("startTF",
                xmTextFieldWidgetClass, rc1,
                XmNcolumns, NUMCOLS,
                NULL);   

   callsignTF = XtVaCreateManagedWidget ("callTF",
                   xmTextFieldWidgetClass, rc1,
                   XmNcolumns, NUMCOLS,
                   NULL);   

   /* 
    * Band Option Menu 
    * First count the number of bands listed in the bands property
    * of the resource file.  Then build the Args array to set the
    * properties when XmCreateSimpleOptionMenu creates the menu.
    */
   btn_cnt = 0;
   while (!XmStringEmpty (log_res.bands[btn_cnt]))
      {
      btn_cnt++;
      }

   i = 0;
   XtSetArg (args[i], XmNbuttons, log_res.bands); i++;
   XtSetArg (args[i], XmNbuttonCount, btn_cnt); i++;
   XtSetArg (args[i], XmNbuttonSet, log_res.default_band); i++;
   XtSetArg (args[i], XmNnavigationType, XmTAB_GROUP); i++;
   XtSetArg (args[i], XmNentryAlignment, XmALIGNMENT_CENTER); i++;
     
   bandMenu = XmCreateSimpleOptionMenu (rc1, "bandMenu", args, i);

   XtUnmanageChild (XmOptionLabelGadget (bandMenu));  /*No menu label pls*/
   XtManageChild (bandMenu);

   /*
    * End Band Option Menu 
    */

   /*
    * Mode Option Menu
    * Create the Mode menu the same way as the Band menu above.
    */
   btn_cnt = 0;
   while (!XmStringEmpty (log_res.modes[btn_cnt]))
      {
      btn_cnt++;
      }

   i = 0;
   XtSetArg (args[i], XmNbuttons, log_res.modes); i++;
   XtSetArg (args[i], XmNbuttonCount, btn_cnt); i++;
   XtSetArg (args[i], XmNbuttonSet, log_res.default_mode); i++;
   XtSetArg (args[i], XmNnavigationType, XmTAB_GROUP); i++;
   XtSetArg (args[i], XmNentryAlignment, XmALIGNMENT_CENTER); i++;

   modeMenu = XmCreateSimpleOptionMenu (rc1, "modeMenu", args, i);

   XtManageChild (modeMenu);
   XtUnmanageChild (XmOptionLabelGadget (modeMenu));  /*No menu label pls*/
   /*
    * End Mode Option Menu
    */

   /*
    * Power Option Menu
    * Create the Power menu the same way as the Band menu above.
    */
   btn_cnt = 0;
   while (!XmStringEmpty (log_res.power[btn_cnt]))
      {
      btn_cnt++;
      }

   i = 0;
   XtSetArg (args[i], XmNbuttons, log_res.power); i++;
   XtSetArg (args[i], XmNbuttonCount, btn_cnt); i++;
   XtSetArg (args[i], XmNbuttonSet, log_res.default_power); i++;
   XtSetArg (args[i], XmNnavigationType, XmTAB_GROUP); i++;
   XtSetArg (args[i], XmNentryAlignment, XmALIGNMENT_CENTER); i++;

   powerMenu = XmCreateSimpleOptionMenu (rc1, "powerMenu", args, i);

   XtManageChild (powerMenu);
   XtUnmanageChild (XmOptionLabelGadget (powerMenu));
   /*
    * End Power Option Menu
    */

   rst1TF = XtVaCreateManagedWidget ("rst1TF",
               xmTextFieldWidgetClass, rc1,
               XmNcolumns, NUMCOLS,
               NULL);   

   rst2TF = XtVaCreateManagedWidget ("rst2TF",
               xmTextFieldWidgetClass, rc1,
               XmNcolumns, NUMCOLS,
               NULL);   

   notesTF = XtVaCreateManagedWidget ("notesTF",
                xmTextFieldWidgetClass, rc1,
                XmNcolumns, NUMCOLS,
		XmNrows, 5,
		XmNeditMode, XmMULTI_LINE_EDIT,
                NULL);   

   endTF = XtVaCreateManagedWidget ("endTF",
              xmTextFieldWidgetClass, rc1,
              XmNcolumns, NUMCOLS,
              NULL);   
   /*
    * End Column 2
    */
/*
 * End Data Entry Form
 */

/*
 * Initialize argument structs
 * These are passed to some callbacks
 * Note: The notesTF is the last element in the array, but
 * appears as the next to the last widget in the rowColumn.
 */
   dateCdata.TF1 = dateTF;
   dateCdata.TF2 = NULL;
   dateCdata.next = startPB;

   startCdata.TF1 = dateTF;
   startCdata.TF2 = startTF;
   startCdata.next = callsignTF;

   endCdata.TF1 = endTF;
   endCdata.TF2 = NULL;
   endCdata.next = datePB;

   col_2_wids[0] = dateTF;
   col_2_wids[1] = startTF;
   col_2_wids[2] = callsignTF;
   col_2_wids[3] = bandMenu;
   col_2_wids[4] = modeMenu;
   col_2_wids[5] = powerMenu;
   col_2_wids[6] = rst1TF;
   col_2_wids[7] = rst2TF;
   col_2_wids[8] = endTF;
   col_2_wids[9] = notesTF;
    
   /*
    * Add callbacks
    * The first three callbacks registered are for the column 1
    * pushbuttons. The date and end PB's need to know their
    * coresponding textFields, which is passed as client data.  The
    * start PB client data is a pointer to an array holding the IDs of
    * the date and time TFs, so this callback can set both date and
    * start time.
    */
   XtAddCallback (datePB,  XmNactivateCallback, dateCB, (XtPointer) &dateCdata);
   XtAddCallback (startPB, XmNactivateCallback, startCB, (XtPointer) &startCdata);
   XtAddCallback (endPB,   XmNactivateCallback, endCB, (XtPointer) &endCdata);

   /*
    * Both callbacks go to the same function where they are identified.
    * The modify/verify callback changes all letters to upper case.  The
    * activate callback forces a traversal to the next tab group.
    */
   XtAddCallback (callsignTF,  XmNmodifyVerifyCallback, callsignCB, NULL);
   XtAddCallback (callsignTF,  XmNactivateCallback, callsignCB, NULL);
   XtAddCallback (rst1TF,  XmNactivateCallback, callsignCB, NULL);
   XtAddCallback (rst2TF,  XmNactivateCallback, callsignCB, NULL);
   XtAddCallback (notesTF, XmNactivateCallback, callsignCB, NULL);

   /* All the textFields call the focusCB() function.  As a widget gains
    * focus, its cursor is turned on.  As it looses focus, its cursor is
    * turned off. The cursor makes it hard to read the text sometimes,
    * and I got tired of looking at them. So there!
    */
   XtAddCallback (dateTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (dateTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);
      
   XtAddCallback (startTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (startTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);   
      
   XtAddCallback (callsignTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (callsignTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);
   
   XtAddCallback (rst1TF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (rst1TF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);
   
   XtAddCallback (rst2TF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (rst2TF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);
   
   XtAddCallback (notesTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (notesTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);
   
   XtAddCallback (endTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (endTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   /*
    * Register Translations
    */
   XtOverrideTranslations (bandMenu, XtParseTranslationTable(transTable));
   XtOverrideTranslations (modeMenu, XtParseTranslationTable(transTable));
   XtOverrideTranslations (powerMenu,XtParseTranslationTable(transTable));
   
   XtManageChild (menuBar);
   XtManageChild (rc1);
   XtManageChild (form1);
}
