// sdffile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "sdffile.h"
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

//#define MAX_CT8_CALL_SIZE        16

/* Used to convert from CT file based band numbers to qso_data type band numbers. */
static char *bands[] = {NULL, "16","80","40","30","20","17","15","12","10"," 6",NULL," 2", NULL};
#define SDF_MAX_BAND          BAND_144MHZ
                                        
//static unsigned char vhfbands[] = {0, BAND_50MHZ, BAND_144MHZ, BAND_222MHZ, BAND_432MHZ,
//                                      BAND_902MHZ, BAND_1GHZ, BAND_2GHZ, BAND_3GHZ,
//                                      BAND_5GHZ, BAND_10GHZ, BAND_24GHZ, BAND_LIGHT, 0};
//static unsigned char dxpedbands[] = {0,BAND_160M,BAND_80M,BAND_40M,BAND_30M,BAND_20M,BAND_18M,
//                                       BAND_15M,BAND_12M,BAND_10M,BAND_SATELLITE,0};
//static unsigned char contests[] = {CQ_WW_CONTEST,CQ_160M_CONTEST,CQ_WPX_CONTEST,
//                                      ARRL_DX_CONTEST,ARRL_DX_CONTEST_DX,ARRL_10M_CONTEST,
//                                      ARRL_160M_CONTEST,ARRL_SS_CONTEST,ARRL_VHF_QSO_PARTY,
//                                      FD_CONTEST,WAE_CONTEST,DXPEDITION_MODE,CAL_QP_CONTEST,
//                                      IARU_CONTEST,ALL_ASIAN_CONTEST,0};
//static unsigned char CTBands[] = {0, 1, 2, 3, 0, 4, 0, 5, 0, 6, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9,
//                                     10, 11, 0, 0, 0, 12, 13, 11, 0};
//static unsigned char CTContests[] = {0, 7, 3, 0, 2, 13, 5, 6, 1, 9, 12, 4, 10, 8, 11, 14, 0};
//static char *radioNames[] = {"NONE", "TS440", "TS850", "TS940", "TS950", "IC725", "IC735", "IC751",
//                              "IC761", "IC765", "IC781", "FT890", "FT990", "FT1000", NULL};
static char modes[] = {' ', '1', '3', '2', '3', '3', '2', '2', ' '};
                              
RSdfFile::RSdfFile(char *name)
{
    RSdfFile::open(name);
}

boolean RSdfFile::open(char *name, int mode)
{
#ifdef LINUX
    if (!RFile::open(name, mode))
        return FALSE;
#else
    // State ios::binary again just in case user does not.
    if (!RFile::open(name, mode | ios::binary))
        return FALSE;
#endif
        
    areaFile = new RAreaFile("stsec.dat");

    if (!(mode & ios::out))
    {
/*        RFile::read((void *)&ct8header, sizeof(Ct8Header));
        strncpy(header.callsign, ct8header.call, CT8_CALL_SIZE);
        strncpy(header.name, ct8header.name, CT8_NAME_SIZE);
        strncpy(header.address, ct8header.address, CT8_ADDRESS_SIZE);
        strncpy(header.city, ct8header.town, CT8_TOWN_SIZE);
        strncpy(header.state, ct8header.state, CT8_STATE_SIZE);
        strncpy(header.zip, ct8header.zip, CT8_ZIP_SIZE);

        header.stationNumber = (unsigned char)(ct8header.station + 1);
        strcpy(header.lastOperator, ct8header.last_op);
        strcpy(header.radio, radioNames[ct8header.radio]);
        header.tnc = ct8header.tnc;
        header.cwPort = ct8header.cw_port;
        header.dvkPort = ct8header.dvk_port;

        header.zone = (unsigned char)atoi(ct8header.zone);
        strncpy(header.grid, ct8header.my_grid, CT8_GRID_SIZE);
        strncpy(header.club, ct8header.club, CT8_CLUB_SIZE);

        if ((header.contest = contests[ct8header.contest]) == 0)
        {*/
            /* This contest is not supported. */
/*            RFile::close();
            return FALSE;
        }
        strncpy(header.contestName, ct8header.contest_title, 32);
        header.category = ct8header.category;
        
        strncpy(header.CQ_CW_Message, ct8header.cq_msg, 64);
        strncpy(header.Exchange_CW_Message, ct8header.ex_msg, 64);
        strncpy(header.QRZ_CW_Message, ct8header.qrz_msg, 64);
        strncpy(header.F6_CW_Message, ct8header.F6_text, 64);
        strncpy(header.F7_CW_Message, ct8header.F7_text, 64);
        strncpy(header.Dupe_CW_Message, ct8header.dupe_msg, 32);

        // Remember the COM: port information.
        for (int comm_count = 0; comm_count < 4; comm_count++)
        {
            header.comm[comm_count].device = ct8header.comm[comm_count].device;
            header.comm[comm_count].baud = ct8header.comm[comm_count].baud;
        }
        
        header.dvp.ingain = ct8header.dvp.ingain;
        header.dvp.outgain = ct8header.dvp.outgain;
        header.dvp.onair = ct8header.dvp.onair;
        header.dvp.mon = ct8header.dvp.mon;
        header.dvp.ram_disk = ct8header.dvp.ram_disk;
        header.dvp.ptt = ct8header.dvp.ptt;
        header.dvp.backcopy = ct8header.dvp.backcopy;
        header.dvp.spare = ct8header.dvp.spare;
        header.dvp.clipping_pt = ct8header.dvp.clipping_pt;
        header.dvp.rpt_delay = ct8header.dvp.rpt_delay;
        header.dvp.auto_space = ct8header.dvp.auto_space;
        
        header.flags.no_work_dupe = ct8header.flags.no_work_dupe;
        header.flags.m_stn = ct8header.flags.m_stn;
        header.flags.post = ct8header.flags.post;
        header.flags.beep = ct8header.flags.beep;
        header.flags.band_rate = ct8header.flags.band_rate;
        header.flags.sound = ct8header.flags.sound;
        header.flags.correct = ct8header.flags.correct;
        header.flags.cw_abbrev = ct8header.flags.cw_abbrev;
        header.flags.autosave = ct8header.flags.autosave;
        header.flags.nocompress = ct8header.flags.nocompress;
        header.flags.see_warc = ct8header.flags.see_warc;
        header.flags.print = ct8header.flags.print;
        header.flags.rpt = ct8header.flags.rpt;
        header.flags.kw_right = ct8header.flags.kw_right;
        
        // Don't bother with these fields unless they are specifically needed.
        if (header.contest == ARRL_SS_CONTEST)
        {
            header.ss.precedence = ct8header.ss.prec[0];
            header.ss.check = (unsigned char)atoi(ct8header.ss.chk);
            strncpy(header.ss.section, ct8header.sec, CT8_SECTION_SIZE);
        }
        else if (header.contest == FD_CONTEST)
        {
            header.fd.category = ct8header.fd.category;
            header.fd.transmitters = ct8header.fd.tx_count;

            header.fd.ep_bonus = ct8header.fd.ep_bonus;
            header.fd.pr_bonus = ct8header.fd.pr_bonus;
            header.fd.loc_bonus = ct8header.fd.loc_bonus;
            header.fd.info_bonus = ct8header.fd.info_bonus;
            header.fd.msg_bonus = ct8header.fd.msg_bonus;
            header.fd.sat_bonus = ct8header.fd.sat_bonus;
            header.fd.nat_bonus = ct8header.fd.nat_bonus;
            header.fd.w1aw_bonus = ct8header.fd.w1aw_bonus;
            header.fd.pkt_bonus = ct8header.fd.pkt_bonus;
            header.fd.tfc_bonus = ct8header.fd.tfc_bonus;
        }*/
    }
    
    location = 0;

    return TRUE;
}

boolean RSdfFile::nextQso(qso_data *qso)
{
    qso = qso;          // Get rid of compiler warnings.
    return FALSE;
}

boolean RSdfFile::writeQso(qso_data *qso)
{
    sdf_log_data sdf_qso;
    struct tm *dosTime;
    char buffer[10];
    char tempState[10];
    char notes[30];
    time_t tempTime;
    
    memset(&sdf_qso, ' ', sizeof(sdf_log_data));
    memset(notes, '\0', 30);

    strncpy(sdf_qso.call, qso->getCallsign(), strlen(qso->getCallsign()));
    tempTime = qso->getTime();
    dosTime = gmtime(&tempTime);
    strftime(sdf_qso.date, 10, "%y%m%d%H%M", dosTime);
    
    sdf_qso.mode = modes[qso->getMode()];
    if (qso->getBand() <= SDF_MAX_BAND)
        strncpy(sdf_qso.band, bands[qso->getBand()], 2);
    else
        return FALSE;
    sdf_qso.printQSL = sdf_qso.confirmed = 'N';

    if (qso->getMode() == CW_MODE)
        sdf_qso.countsCW = 'Y';
    else
        sdf_qso.countsCW = 'N';

    sdf_qso.countsDXCC = 'Y';
    sdf_qso.submitARRL = sdf_qso.submitCQ = sdf_qso.QSOYL = sdf_qso.SatQSO = 'N';

    // TR2DXB45.EXE defaults to these values.  Perhaps DXBase requires it?????
    sdf_qso.QSLSentVia = 'B';
    sdf_qso.MgrNum = '1';

    // DXBase requires that a signal report be included.  So make one up!
    if (qso->getMode() == CW_MODE)
        strncpy(sdf_qso.sentRST, "599", 3);
    else
        strncpy(sdf_qso.sentRST, "59 ", 3);
        
    switch (header.contest) {
        case ARRL_SS_CONTEST:
        case FD_CONTEST:
        case NA_QSO_PARTY_CONTEST:
        case GRIDLOC_CONTEST:
        case TEN_TEN_CONTEST:
        case NA_SPRINT_CONTEST:
        case CAL_QP_CONTEST:
        case INTERNET_SPRINT_CONTEST:
            // These contests do not include RST in their exchange.  So just say 59(9).
            if (qso->getMode() == CW_MODE)
                strncpy(sdf_qso.receivedRST, "599", 3);
            else
                strncpy(sdf_qso.receivedRST, "59 ", 3);
            break;
        default:
            // Contest exchange should have included signal report.
            if (qso->getReceivedRST() != 0)
            {
                sprintf(buffer, "%d", qso->getReceivedRST());
                if (qso->getMode() == CW_MODE)
                    strncpy(sdf_qso.receivedRST, buffer, 3);
                else
                    strncpy(sdf_qso.receivedRST, buffer, 2);
            }
            else
                if (qso->getMode() == CW_MODE)
                    strncpy(sdf_qso.receivedRST, "599", 3);
                else
                    strncpy(sdf_qso.receivedRST, "59 ", 3);
    }

    // If the user supplied a command line option to add a comment to the QSO
    // add it here.  TBD: This code needs to be implemented!!!
    sprintf(notes, "%s ", fileOptions.szNote);

    switch (header.contest) {
        case ARRL_SS_CONTEST:
            sprintf(buffer, "%d%c %d %s", qso->getSerialNumber(), qso->getSSPrecedence(),
                                        qso->getSSCheck(), qso->getSection());
            strcat(notes, buffer);

            // Fill in the state field based on the section report.
            if (areaFile->GetInfo(qso->getSection(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case CQ_WW_CONTEST:
            sprintf(buffer, "%02d", qso->getCqZone());
            strncpy(sdf_qso.zone, buffer, 2);
            break;
        case CQ_WPX_CONTEST:
            sprintf(buffer, "%d", qso->getSerialNumber());
            strcat(notes, buffer);
            break;
        case FD_CONTEST:
            sprintf(buffer, "%d%c %s", qso->getFdTransmitters(), qso->getFdCategory(),
                                      qso->getSection());
            strcat(notes, buffer);
            
            // Fill in the state field based on the section report.
            if (areaFile->GetInfo(qso->getInfo(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case NA_QSO_PARTY_CONTEST:
            if (strlen(qso->getInfo()) == 2)                 // VE exchange should be VEx, else a state.
                strncpy(sdf_qso.state, qso->getInfo(), 2);
            else
            {
                sprintf(buffer, "%s", qso->getInfo());
                strcat(notes, buffer);
            }
            // Fill in the state field based on the contest exchange.
            if (areaFile->GetInfo(qso->getInfo(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case CAL_QP_CONTEST:
            sprintf(buffer, "%d %s", qso->getSerialNumber(), qso->getInfo());
            strcat(notes, buffer);
            break;
        case ARRL_DX_CONTEST_DX:
            strcat(notes, qso->getInfo());
            
            // Fill in the state field based on the contest exchange.
            if (areaFile->GetInfo(qso->getInfo(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case ARRL_VHF_QSO_PARTY:
        case STEW_PERRY_CONTEST:
            strncpy(sdf_qso.grid, qso->getInfo(), 4);
            break;
        case GRIDLOC_CONTEST:
        case TOEC_CONTEST:
            strncpy(sdf_qso.grid, qso->getInfo(), 4);
            strcat(notes, qso->getName());
            break;
        case YO_DX_CONTEST:
            sprintf(buffer, "%02d", qso->getCqZone());
            strncpy(sdf_qso.zone, buffer, 2);
            strcat(notes, qso->getInfo());
            break;
        case TEN_TEN_CONTEST:
            sprintf(buffer, "%s %s", qso->getName(), qso->getInfo());
            strcat(notes, buffer);
            if (qso->getTenTenNumber() != 0)
            {
                sprintf(buffer, "%d", qso->getTenTenNumber());
                strncpy(sdf_qso.TenTenNum, buffer, strlen(buffer));
            }
            break;
        case NA_SPRINT_CONTEST:
            sprintf(buffer, "%d %s %s", qso->getSerialNumber(), qso->getName(),
                                        qso->getInfo());
            strcat(notes, buffer);
            
            // Fill in the state field based on the contest exchange.
            if (areaFile->GetInfo(qso->getInfo(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case QRP_ARCI_CONTEST:
            sprintf(buffer, "%d %s", qso->getARCInumber(), qso->getInfo());
            strcat(notes, buffer);
            
            // Fill in the state field based on the QTH report.
            if (areaFile->GetInfo(qso->getInfo(), tempState))
                strncpy(sdf_qso.state, tempState, 2);
            break;
        case IOTA_CONTEST:
            sprintf(buffer, "%d %s", qso->getSerialNumber(), qso->getInfo());
            strcat(notes, buffer);
            
            strncpy(sdf_qso.IOTA, qso->getInfo(), strlen(qso->getInfo()));
            break;
        case INTERNET_SPRINT_CONTEST:
            sprintf(buffer, "%d %s %s", qso->getSerialNumber(), qso->getName(), qso->getInfo());
            strcat(notes, buffer);
            break;
        case HELVETIA_CONTEST:
            sprintf(buffer, "%d %s", qso->getSerialNumber(), qso->getQth());
            strcat(notes, buffer);
            break;
        case WAG_CONTEST:
        case ARI_CONTEST:
            if (qso->getSerialNumber() != 0)
            {
                sprintf(buffer, "%d ", qso->getSerialNumber());
                strcat(notes, buffer);
            }
            strcat(notes, qso->getQth());
            break;
        default:
            strcat(notes, qso->getInfo());
            break;
    }

    strncpy(sdf_qso.notes, notes, strlen(notes));

    location++;

    RFile::write(&sdf_qso, sizeof(sdf_log_data));
    RFile::write("\r\n", 2);
    
    return TRUE;
}

boolean RSdfFile::writeHeader(header_data header)
{
    RQsoFile::storeHeader(header);
/*    Ct8Header ct_header;

    memset(&ct_header, '\0', sizeof(Ct8Header));

    strncpy(ct_header.version_str, "CT 8.19", 16);
    
    strncpy(ct_header.call, header.callsign, CT8_CALL_SIZE);
    strncpy(ct_header.name, header.name, CT8_NAME_SIZE);
    strncpy(ct_header.address, header.address, CT8_ADDRESS_SIZE);
    strncpy(ct_header.town, header.city, CT8_TOWN_SIZE);
    strncpy(ct_header.state, header.state, CT8_STATE_SIZE);
    strncpy(ct_header.zip, header.zip, CT8_ZIP_SIZE);

    ct_header.station = (unsigned char)(header.stationNumber - 1);
    strcpy(ct_header.last_op, header.lastOperator);
    for (unsigned char nameCount = 0; radioNames[nameCount] != NULL; nameCount++)
        if (strcmp(header.radio, radioNames[nameCount]) == 0)
            ct_header.radio = nameCount;
    ct_header.tnc = header.tnc;
    ct_header.cw_port = header.cwPort;
    ct_header.dvk_port = header.dvkPort;

    if (header.contest > ALL_ASIAN_CONTEST)
    {*/
        /* This contest is not supported. */
/*        RFile::close();
        return FALSE;
    }
    else
        ct_header.contest = CTContests[header.contest];
        
    strncpy(ct_header.contest_title, header.contestName, 32);
    ct_header.category = header.category;

    strncpy(ct_header.zone, itoa(header.zone, ct_header.zone, 10), CT8_ZONE_SIZE);
    strncpy(ct_header.my_grid, header.grid, CT8_GRID_SIZE);
    strncpy(ct_header.club, header.club, CT8_CLUB_SIZE);

    strncpy(ct_header.cq_msg, header.CQ_CW_Message, 64);
    strncpy(ct_header.qrz_msg, header.QRZ_CW_Message, 64);
    strncpy(ct_header.ex_msg, header.Exchange_CW_Message, 64);
    strncpy(ct_header.F6_text, header.F6_CW_Message, 64);
    strncpy(ct_header.F7_text, header.F7_CW_Message, 64);
    strncpy(ct_header.dupe_msg, header.Dupe_CW_Message, 32);

    // Remember the COM: port information.
    for (int comm_count = 0; comm_count < 4; comm_count++)
    {
        ct_header.comm[comm_count].device = header.comm[comm_count].device;
        ct_header.comm[comm_count].baud = header.comm[comm_count].baud;
    }
        
    ct_header.dvp.ingain = header.dvp.ingain;
    ct_header.dvp.outgain = header.dvp.outgain;
    ct_header.dvp.onair = header.dvp.onair;
    ct_header.dvp.mon = header.dvp.mon;
    ct_header.dvp.ram_disk = header.dvp.ram_disk;
    ct_header.dvp.ptt = header.dvp.ptt;
    ct_header.dvp.backcopy = header.dvp.backcopy;
    ct_header.dvp.spare = header.dvp.spare;
    ct_header.dvp.clipping_pt = header.dvp.clipping_pt;
    ct_header.dvp.rpt_delay = header.dvp.rpt_delay;
    ct_header.dvp.auto_space = header.dvp.auto_space;

    ct_header.flags.no_work_dupe = header.flags.no_work_dupe;
    ct_header.flags.m_stn = header.flags.m_stn;
    ct_header.flags.post = header.flags.post;
    ct_header.flags.beep = header.flags.beep;
    ct_header.flags.band_rate = header.flags.band_rate;
    ct_header.flags.sound = header.flags.sound;
    ct_header.flags.correct = header.flags.correct;
    ct_header.flags.cw_abbrev = header.flags.cw_abbrev;
    ct_header.flags.autosave = header.flags.autosave;
    ct_header.flags.nocompress = header.flags.nocompress;
    ct_header.flags.see_warc = header.flags.see_warc;
    ct_header.flags.print = header.flags.print;
    ct_header.flags.rpt = header.flags.rpt;
    ct_header.flags.kw_right = header.flags.kw_right;
        
    // Don't bother with these fields unless they are specifically needed.
    if (header.contest == ARRL_SS_CONTEST)
    {
        ct_header.ss.prec[0] = header.ss.precedence;
        itoa(header.ss.check, ct_header.ss.chk, CT8_CHECK_SIZE);
        strncpy(ct_header.sec, header.ss.section, CT8_SECTION_SIZE);
    }
    else if (header.contest == FD_CONTEST)
    {
        ct_header.fd.category = header.fd.category;
        ct_header.fd.tx_count = header.fd.transmitters;
        
        ct_header.fd.ep_bonus = header.fd.ep_bonus;
        ct_header.fd.pr_bonus = header.fd.pr_bonus;
        ct_header.fd.loc_bonus = header.fd.loc_bonus;
        ct_header.fd.info_bonus = header.fd.info_bonus;
        ct_header.fd.msg_bonus = header.fd.msg_bonus;
        ct_header.fd.sat_bonus = header.fd.sat_bonus;
        ct_header.fd.nat_bonus = header.fd.nat_bonus;
        ct_header.fd.w1aw_bonus = header.fd.w1aw_bonus;
        ct_header.fd.pkt_bonus = header.fd.pkt_bonus;
        ct_header.fd.tfc_bonus = header.fd.tfc_bonus;
    }
        
    RFile::write((void *)&ct_header, sizeof(Ct8Header));    */
    return TRUE;
}
