.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutLayerGet 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutLayerGet - retrieves GLUT state pertaining to the layers of the
current window. 
.SH SYNTAX
.nf
.LP
int glutLayerGet(GLenum info);
.fi
.SH ARGUMENTS
.IP \fIinfo\fP 1i
Name of device information to retrieve. 
.TP 8
.B GLUT_OVERLAY_POSSIBLE 
Whether an overlay could be established for the current window
given the current initial display mode. If false,
glutEstablishOverlay will fail with a fatal error if called. 
.TP 8
.B GLUT_LAYER_IN_USE 
Either GLUT_NORMAL or GLUT_OVERLAY depending on whether
the normal plane or overlay is the layer in use. 
.TP 8
.B GLUT_HAS_OVERLAY 
If the current window has an overlay established. 
.TP 8
.B GLUT_TRANSPARENT_INDEX 
The transparent color index of the overlay of the current window;
negative one is returned if no overlay is in use. 
.TP 8
.B GLUT_NORMAL_DAMAGED 
True if the normal plane of the current window has damaged (by
window system activity) since the last display callback was
triggered. Calling glutPostRedisplay will not set this true. 
.TP 8
.B GLUT_OVERLAY_DAMAGED 
True if the overlay plane of the current window has damaged (by
window system activity) since the last display callback was
triggered. Calling glutPostRedisplay or
glutPostOverlayRedisplay will not set this true. Negative
one is returned if no overlay is in use. 
.SH DESCRIPTION
glutLayerGet retrieves GLUT layer information for the current
window represented by integers. The info parameter determines what
type of layer information to return.
.SH SEE ALSO
glutEstablishOverlay, glutUseOverlay, glutCreateWindow, glutSetColor
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
