/* libcqcam - shared Color Quickcam routines
 * Copyright (C) 1996-1998 by Patrick Reynolds
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

// This function tries to give the process direct I/O port access.

int io_access(void) {
  int n;
  int gr[NGROUPS];

// We check first if we belong to group 0.

  n = NGROUPS;
  if (getgroups(&n, gr) != -1)
    while (n--)
      if (gr[n] == 0)
        return 0;  // OK, we are in group 0; we have access

// The process doesn't have direct I/O permission.  We'll try to obtain root
// privileges

  if (setuid(0) < 0)
    return -1;        // can't get root; no access

// OK, we are root now; we have access
  return 0;
}
