/* 2 XPM, convert image to an xpm with transparency */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>

int main(int argc, char *argv[])
{

  int length, i;
  char cmdline[128], *name;

  if( argc < 2 || !strcmp(argv[1],"-h") || !strcmp(argv[1],"-help")
      || !strcmp( argv[1], "--help") ) {
    fprintf(stderr, "2xpm, convert image files to X Pixmaps.\n"
	    "usage: 2xpm [image]\n");
    exit(0);
  }
  
  for( i=1 ; i<argc ; i++ ) {
    
    length = strlen( argv[i] ) - 4; /* -4 strips .xxx extension */

    if( access( argv[i], R_OK) < 0 ) {
      fprintf(stderr, "Cannot access \"%s\"!!\n", argv[i]);
      continue;
    }
    
    name = (char *)malloc( length );
    strncpy( name, argv[i], length );
    *( name + length ) = '\0';

    /* Convert to xpm */
    sprintf(cmdline, "convert %s %s.xpm", argv[i], name);
    system(cmdline);

    /* -> 64 colors */
    sprintf(cmdline, "convert -colors 64 %s.xpm %s.xpm", name, name);
    system(cmdline);

    /* Make transparent */
    sprintf(cmdline, "convert -transparent Magenta %s.xpm %s.xpm", name, name);
    system(cmdline);

    free( name );

  }

  return 0;
  
}
