/*
                        Universe Header Window


 */

#ifndef UHW_H
#define UHW_H

#include "../include/osw-x.h"
#include "../include/widget.h"

#include "../include/objects.h"


/*
 *      Default title strings:
 */
#define UHW_DEF_TITLE		"Universe Header"
#define UHW_DEF_ICON_TITLE      "Header"


#define UHW_WIDTH		400
#define UHW_HEIGHT		330

#define UHW_PROMPT_HEIGHT	30

#define UHW_BUTTON_WIDTH	70
#define UHW_BUTTON_HEIGHT	28


/*
 *	Universe hedaer window structure:
 */
typedef struct {

	char map_state;
	char is_in_focus;
	int x, y;
	unsigned int width, height;

	bool_t has_changes;

	pixmap_t toplevel_buf;
	win_t toplevel;

	prompt_window_struct	title_prompt,
				convert_ru_to_au_prompt,
				lost_found_owner_prompt,
				isr_prompt,
				ocsn_prompt,
				ss_prompt;

	push_button_struct	ok_btn,
				apply_btn,
				cancel_btn;

	/* Pointer to source universe editor window. */
	void *src;

} uhw_struct;
uhw_struct **uhw;
int total_uhws;


/* uhw.c */
extern int UHWIsAllocated(int n);
extern int UHWAllocate();
extern void UHWDelete(int n);
extern void UHWDeleteAll();

extern int UHWDoFetch(int n, void *src_ptr);
extern int UHWDoApply(int n);
extern int UHWOKCB(void *ptr);
extern int UHWApplyCB(void *ptr);
extern int UHWCancelCB(void *ptr);

extern int UHWInit(int n, void *src_ptr);
extern int UHWDraw(int n, int amount);
extern int UHWManage(int n, event_t *event);
extern int UHWManageAll(event_t *event);
extern void UHWMap(int n);
extern void UHWUnmap(int n);
extern void UHWDestroy(int n);

#endif	/* UHW_H */
