/*
                                Economy

	Functions:


	int EcoDoBuy(
	        long condescriptor,
	        long customer_obj,
	        long proprietor_obj,
	        xsw_ecoproduct_struct product
	)
	int EcoDoSell(
	        long condescriptor,
	        long customer_obj,
	        long proprietor_obj,
	        xsw_ecoproduct_struct product
	)

	---

 */

#include "swserv.h"


#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))


/*
 *	Procedure to do a buy, customer buys from the proprietor.
 */
int EcoDoBuy(
	long condescriptor,	/* Of customer_obj. */
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
)
{
	int i;
	int ocs_num;
	int ep_num = -1;
	int schedual_act_item_code = -1;
	int need_passive_transfer = 0;
	double schedual_act_inc_limit;

	xswo_credits_t d_credits;
	double d_amount;

	xsw_object_struct *customer_ptr, *proprietor_ptr;
	xsw_ecoproduct_struct *real_product_ptr;	/* Real product on proprietor. */
	char text[ECO_PRODUCT_NAME_MAX + XSW_OBJ_NAME_MAX + 512];


	/* Priorietor object must be valid. */
	if(DBIsObjectGarbage(proprietor_obj))
	    return(0);
	else
	    proprietor_ptr = xsw_object[proprietor_obj];

        /* Customer object must be valid. */
        if(DBIsObjectGarbage(customer_obj))
            return(0);
        else
            customer_ptr = xsw_object[customer_obj];

	/* Is customer and proprietor the same? */
	if(customer_ptr == proprietor_ptr)
	{
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Customer and proprietor are the same."
            );
            return(-1);
	}

	/* Proprietor must have an economy and score structure. */
	if(proprietor_ptr->eco == NULL)
	    return(0);
	if(DBCreateObjectScores(proprietor_obj))
	    return(0);

        if(DBCreateObjectScores(customer_obj))
            return(0); 


	/* Check if customer and proprietor are in range. */
	if(!Mu3DInRange(customer_obj, proprietor_obj, ECO_MAX_TRANSACTION_RANGE))
	{
	    NetSendSysMessage(
		condescriptor,      
		CS_SYSMESG_CODE_ERROR,
		"Proprietor object is too far away."
	    );
	    return(-1);
	}

	/*   Customer object is assumed already checked to be owned by
         *   the connetion.
         */

	/* Check if proprietor is OPENed for business. */
	if(!(proprietor_ptr->eco->flags & ECO_FLAG_OPEN))
	{
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Proprietor object is not opened for business."
            );
            return(-1);
	}
	/* Check if proprietor is willing to allow BUYing. */
	if(!(proprietor_ptr->eco->flags & ECO_FLAG_BUY_OK))
        {
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Proprietor object does not permit purchasing."
            );
            return(-1);
        }


	/* Sanitize product name. */
	if(product.name[0] == '\0')
	    return(0);

	/* Request product amount must be positive. */
	if(product.amount <= 0)
	    return(0);


	/* Get eco product number. */
	ep_num = EcoGetProductNumByName(proprietor_obj, product.name);
	if(ep_num < 0)
	    return(-1);
	else
	    real_product_ptr = proprietor_ptr->eco->product[ep_num];



	/* ********************************************************** */
	/* Handle by product name. */

	/* Antimatter. */
	if(!strcasecmp(product.name, ECO_PROD_NAME_ANTIMATTER))
	{
	    /* Set schedual action item code. */
	    schedual_act_item_code = SCHE_ITEM_ANTIMATTER;

	    /* Get and sanitize delta amount (if limited). */
	    if(real_product_ptr->amount_max >= 0)
	    {
		if((real_product_ptr->amount - product.amount) < 0)
		    d_amount = real_product_ptr->amount;
		else
		    d_amount = product.amount;
	    }
	    else
	    {
		d_amount = product.amount;
	    }

	    /* Sanitize amount for customer, how much can customer have. */
	    if((d_amount + customer_ptr->antimatter) >
		customer_ptr->antimatter_max
	    )
		d_amount = customer_ptr->antimatter_max -
		    customer_ptr->antimatter;

            /* Charge customer and get sanitize credits. */
            d_credits = EcoTransCredits(
                customer_obj,
                d_amount * real_product_ptr->buy_price *
                     proprietor_ptr->eco->tax_general * -1
            ) * -1;
            /* Give credits to proprietor. */
            EcoTransCredits(proprietor_obj, d_credits);

            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->buy_price != 0)
	    )
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->buy_price);

            /* Calculate increment limit. */  
            schedual_act_inc_limit = d_amount;

	    /* Need passive transfer of product to customer. */
	    need_passive_transfer = 1;
	}
        /* ********************************************************** */
        /* Hull repair. */
        else if(!strcasecmp(product.name, ECO_PROD_NAME_REPAIRHULL))
        {
            /* Set schedual action item code. */
            schedual_act_item_code = SCHE_ITEM_HULL;

            /* Get and sanitize delta amount (if limited). */
            if(real_product_ptr->amount_max >= 0)
            {
                if((real_product_ptr->amount - product.amount) < 0)
                    d_amount = real_product_ptr->amount;
                else
                    d_amount = product.amount;
            }
            else
            {
                d_amount = product.amount;
            }
            
            /* Sanitize amount for customer, how much can customer have. */
            if((d_amount + customer_ptr->hp) >
                customer_ptr->hp_max
            )
                d_amount = customer_ptr->hp_max -
                    customer_ptr->hp;

            /* Charge customer and get sanitize credits. */
            d_credits = EcoTransCredits(
                customer_obj,
                d_amount * real_product_ptr->buy_price *
                     proprietor_ptr->eco->tax_general * -1
            ) * -1;
            /* Give credits to proprietor. */
            EcoTransCredits(proprietor_obj, d_credits);

            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->buy_price != 0)
            )
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->buy_price);

            /* Calculate increment limit. */
            schedual_act_inc_limit = d_amount;


            /* Need passive transfer of product to customer. */
            need_passive_transfer = 1;
	}
        /* ********************************************************** */
        /* Raw material. */
        else if(!strcasecmp(product.name, ECO_PROD_NAME_RMU))
        {
            /* Set schedual action item code. */
            schedual_act_item_code = SCHE_ITEM_RMU;

            /* Get and sanitize delta amount (if limited). */
            if(real_product_ptr->amount_max >= 0)
            {
                if((real_product_ptr->amount - product.amount) < 0)
                    d_amount = real_product_ptr->amount;
                else
                    d_amount = product.amount;
            }
            else
            {
                d_amount = product.amount;
            }

            /* Sanitize amount for customer, how much can customer have. */
            if((d_amount + customer_ptr->score->rmu) >
                customer_ptr->score->rmu_max
            )
                d_amount = customer_ptr->score->rmu_max -
                    customer_ptr->score->rmu;
        
            /* Charge customer and get sanitize credits. */
            d_credits = EcoTransCredits(
                customer_obj,
                d_amount * real_product_ptr->buy_price *
                     proprietor_ptr->eco->tax_general * -1
            ) * -1;
            /* Give credits to proprietor. */
            EcoTransCredits(proprietor_obj, d_credits);
                
            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->buy_price != 0)
            )
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->buy_price);

            /* Calculate increment limit. */
            schedual_act_inc_limit = d_amount;


            /* Need passive transfer of product to customer. */
            need_passive_transfer = 1;
        }
        /* ********************************************************** */
        /* OPM, this usually implies weapon. */
        else if(strcasepfx(product.name, ECO_PROD_NAME_OPMPFX))
	{
	    /* Weapons require whole numbered amounts. */
	    d_amount = floor(d_amount);

	    /* Match weapon on customer. */
	    i = EcoGetWeaponNumByName(customer_ptr, product.name);
	    if(i < 0)
		return(0);

	    /* Set action item code to 0 so it's just valid. */
            schedual_act_item_code = 0;


            /* Get and sanitize delta amount (if limited). */
            if(real_product_ptr->amount_max >= 0)
            {
                if((real_product_ptr->amount - product.amount) < 0)
                    d_amount = real_product_ptr->amount;
                else
                    d_amount = product.amount;
            }
            else
            {
                d_amount = product.amount;
            }
          
            /* Sanitize amount for customer, how much can customer have. */
            if((d_amount + customer_ptr->weapons[i]->amount) >
                customer_ptr->weapons[i]->max
            )
                d_amount = customer_ptr->weapons[i]->max -
                    customer_ptr->weapons[i]->amount;

            /* Charge customer and get sanitize credits. */
            d_credits = EcoTransCredits(
                customer_obj,
                d_amount * real_product_ptr->buy_price *
                     proprietor_ptr->eco->tax_general * -1
            ) * -1;
            /* Give credits to proprietor. */
            EcoTransCredits(proprietor_obj, d_credits);

            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->buy_price != 0)
            )
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->buy_price);

            /* Calculate increment limit. */
            schedual_act_inc_limit = d_amount;


	    /* Transfer weapon amount all at once to customer. */
	    customer_ptr->weapons[i]->amount += d_amount;


            /* Don't need passive transfer of product to customer. */
/*
            need_passive_transfer = 1;
*/
	}
        /* ********************************************************** */
	else
	{
            sprintf(
		text,
		"No such product `%s' available on %s.",
                product.name,
                proprietor_ptr->name
            );
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                text
            );

	    schedual_act_item_code = -1;
	}


        /* ********************************************************** */

	/*   Return if schedual_act_item_code is -1.  This implies that no
	 *   valid product was found and handled above.
	 */
	if(schedual_act_item_code == -1)
	    return(-1);


/* Decrement amount from proprietor instantly (for now). */
if(real_product_ptr->amount_max >= 0)
    real_product_ptr->amount -= d_amount;

	/* Update product values to connection. */
	NetSendEcoSetProductValues(
	    condescriptor,	/* Connection. */
	    proprietor_obj,	/* Proprietor object. */
	    ep_num		/* Eco product number. */
	);
        NetSendScore(condescriptor, proprietor_obj);                
        NetSendScore(condescriptor, customer_obj);


	/* Begin transfer. */
	if(need_passive_transfer)
	{
	    EcoStartTransfer(
	        customer_obj,
	        proprietor_obj,
	        customer_obj,
                SCHE_ACT_RESTOCK,
	        schedual_act_item_code,
	        ((schedual_act_inc_limit < 5) ?	/* Increment size. */
		    schedual_act_inc_limit : 5),
                schedual_act_inc_limit,
	        1			/* Interval in seconds. */
	    );
	}


	return(0);
}


/*
 *	Procedure to do a sell, customer sells to the proprietor.
 */
int EcoDoSell(
        long condescriptor,	/* Of customer_obj. */
        long customer_obj,
        long proprietor_obj,
        xsw_ecoproduct_struct product
)
{
        int ep_num = -1;
        int schedual_act_item_code = -1;
/*	int need_passive_transfer = 0; */
        double schedual_act_inc_limit;

        xswo_credits_t d_credits;
        double d_amount;

        xsw_object_struct *customer_ptr, *proprietor_ptr;
        xsw_ecoproduct_struct *real_product_ptr;        /* Real product on proprietor. */

	char text[ECO_PRODUCT_NAME_MAX + XSW_OBJ_NAME_MAX + 512];


        /* Priorietor object must be valid. */
        if(DBIsObjectGarbage(proprietor_obj))
            return(0);
        else
            proprietor_ptr = xsw_object[proprietor_obj];

        /* Customer object must be valid. */
        if(DBIsObjectGarbage(customer_obj))
            return(0);
        else
            customer_ptr = xsw_object[customer_obj];

        /* Is customer and proprietor the same? */
        if(customer_ptr == proprietor_ptr)
        {
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Customer and proprietor are the same."
            );
            return(-1);
        }


        /* Proprietor have an economy and score structure. */
        if(proprietor_ptr->eco == NULL)
            return(0);
        if(DBCreateObjectScores(proprietor_obj))
            return(0);

        if(DBCreateObjectScores(customer_obj))
            return(0);


        /* Check if customer and proprietor are in range. */
        if(!Mu3DInRange(customer_obj, proprietor_obj, ECO_MAX_TRANSACTION_RANGE))
        {
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Proprietor object is too far away."
            );
            return(-1);
        }

        /*   Customer object is assumed already checked to be owned by
         *   the connetion.
         */
              
        /* Check if proprietor is OPENed for business. */
        if(!(proprietor_ptr->eco->flags & ECO_FLAG_OPEN))
        {       
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Proprietor object is not opened for business."
            );
            return(-1);
        }
        /* Check if proprietor is willing to allow SELLing. */
        if(!(proprietor_ptr->eco->flags & ECO_FLAG_SELL_OK))
        {
            NetSendSysMessage(
                condescriptor,
                CS_SYSMESG_CODE_ERROR,
                "Proprietor object does not permit selling."
            );
            return(-1);
        }       
                
                
        /* Sanitize product name. */
        if(product.name[0] == '\0')  
            return(0);


        /* Request product amount must be positive. */
        if(product.amount <= 0)
            return(0);
 
         
        /* Get eco product number. */
        ep_num = EcoGetProductNumByName(proprietor_obj, product.name);
        if(ep_num < 0)
            return(-1);
        else
            real_product_ptr = proprietor_ptr->eco->product[ep_num];
            
                
                
        /* ********************************************************** */
        /* Handle by product name. */

        /* Antimatter. */
        if(!strcasecmp(product.name, ECO_PROD_NAME_ANTIMATTER))
        {
            /* Set schedual action item code. */
            schedual_act_item_code = SCHE_ITEM_ANTIMATTER;

            /* Get and sanitize available delta product amount. */
	    if((customer_ptr->antimatter - product.amount) < 0)
		d_amount = customer_ptr->antimatter;
	    else
		d_amount = product.amount;

            /* Sanitize amount for proprietor, how much can proprietor have. */
	    if(real_product_ptr->amount_max >= 0)
	    {
                if((d_amount + real_product_ptr->amount) >
                    real_product_ptr->amount_max
                )
                    d_amount = real_product_ptr->amount_max -
                        real_product_ptr->amount;
	    }

            /* Charge proprietor and get sanitize credits. */
            d_credits = EcoTransCredits(
                proprietor_obj,
                d_amount * real_product_ptr->sell_price /
                     MAX(proprietor_ptr->eco->tax_general, 1) * -1
            ) * -1;
	    /* Give credits to customer. */
            EcoTransCredits(customer_obj, d_credits);

            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->sell_price != 0)
	    )
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->sell_price);

            /* Calculate increment limit. */
            schedual_act_inc_limit = d_amount;


            /* Transfer amount all at once from the customer. */
            customer_ptr->antimatter -= d_amount;


            /* Don't need passive transfer of product to customer. */
/*
            need_passive_transfer = 1;
*/
        }
        /* ********************************************************** */
        /* Raw material (RMU). */
        else if(!strcasecmp(product.name, ECO_PROD_NAME_RMU))
        {
            /* Set schedual action item code. */
            schedual_act_item_code = SCHE_ITEM_RMU;

            /* Get and sanitize available delta product amount. */
            if((customer_ptr->score->rmu - product.amount) < 0)
                d_amount = customer_ptr->score->rmu;
            else
                d_amount = product.amount;

            /* Sanitize amount for proprietor, how much can proprietor have. */
            if(real_product_ptr->amount_max >= 0)
            {
                if((d_amount + real_product_ptr->amount) >
                    real_product_ptr->amount_max
                )
                    d_amount = real_product_ptr->amount_max -
                        real_product_ptr->amount;
            }
  
            /* Charge proprietor and get sanitize credits. */
            d_credits = EcoTransCredits(
                proprietor_obj,
                d_amount * real_product_ptr->sell_price /
                     MAX(proprietor_ptr->eco->tax_general, 1) * -1
            ) * -1;
            /* Give credits to customer. */
            EcoTransCredits(customer_obj, d_credits);

            /* Calculate sanitized amount based on credits available. */
            if((proprietor_ptr->eco->tax_general != 0) &&
               (real_product_ptr->sell_price != 0)
            )   
                d_amount = d_credits / (proprietor_ptr->eco->tax_general
                    * real_product_ptr->sell_price);

            /* Calculate increment limit. */
            schedual_act_inc_limit = d_amount;


            /* Transfer amount all at once from the customer. */
            customer_ptr->score->rmu -= d_amount;


            /* Don't need passive transfer of product to customer. */
/*
            need_passive_transfer = 1;
*/
        }
        /* ********************************************************** */
        else    
        {
	    sprintf(
		text,
		"No such product `%s' available on %s.",
		product.name,
		proprietor_ptr->name
	    );
	    NetSendSysMessage(
                condescriptor,
		CS_SYSMESG_CODE_ERROR,
                text
	    );

            schedual_act_item_code = -1;
        }
            
            
        /* ********************************************************** */
        
        /*   Return if schedual_act_item_code is -1.  This implies that no
         *   valid product was found and handled above.
         */
        if(schedual_act_item_code == -1)
            return(-1);


/* Increment amount to proprietor instantly (for now). */
real_product_ptr->amount += d_amount;

        /* Update product values to connection. */
        NetSendEcoSetProductValues(
            condescriptor,      /* Connection. */
            proprietor_obj,     /* Proprietor object. */
            ep_num              /* Eco product number. */
        );
        NetSendScore(condescriptor, proprietor_obj);
        NetSendScore(condescriptor, customer_obj);


        /* Begin transfer. */
/* Selling is all instant.  We don't need this.
        if(need_passive_transfer)
        {
            EcoStartTransfer(
                customer_obj,
		customer_obj,
                proprietor_obj,
                SCHE_ACT_RESTOCK,
                schedual_act_item_code,
                ((schedual_act_inc_limit < 5) ?	Incremenet size.
                    schedual_act_inc_limit : 5),
                schedual_act_inc_limit,
                1                        Interval in seconds.
            );
        }
*/


	return(0);
}
