#include "swserv.h"


int CmdUnrecycle(int condescriptor, char *arg)
{
        char name1[256];
        char name2[256];
        
        int x, y;
        long object_num;
        long owner;
        char sndbuf[CS_DATA_MAX_LEN];
        char name[XSW_OBJ_NAME_MAX];  
        char stringa[1024];


        /* If no argument, print usage. */
        if((arg == NULL) ? 1 : (arg[0] == '\0'))
        {
            y = 0;
            for(x = 0; x < total_recycled_objects; x++)
            {
                if(recycled_xsw_object[x] == NULL)
                    continue;

                if(recycled_xsw_object[x]->type <= XSW_OBJ_TYPE_GARBAGE)
                    continue;

                y++;
            }
            sprintf(sndbuf,
                "Recycled objects buffer %i(%i).",
                y,
                total_recycled_objects
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            sprintf(sndbuf,
                "Usage: `unrecycle <search_string>'"
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* ******************************************************* */

        /* Copy arg to name. */
        strncpy(name, arg, XSW_OBJ_NAME_MAX);
        name[XSW_OBJ_NAME_MAX - 1] = '\0';
        StringStripSpaces(name);

        owner = connection[condescriptor]->object_num; 
        if(DBIsObjectGarbage(owner))
            return(-1);


        /* Attempt to recover object. */
        object_num = DBRecoverRecycledObject(name, owner);


        /* Did we recover anything? */
        if(DBIsObjectGarbage(object_num))
        {
            sprintf(sndbuf,
                "%s: Not found in recycle backup buffer.",
                name
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            
            return(-1);
        }


        /* Print name of object recovered. */
        sprintf(sndbuf,
            "%s: Succesfully recovered as %s",
            name,
            DBGetFormalNameStr(object_num)
        );
        NetSendLiveMessage(condescriptor, sndbuf);

        /* Log recovery. */
        strncpy(name1, DBGetFormalNameStr(owner), 256);
        name1[255] = '\0';
        strncpy(name2, DBGetFormalNameStr(object_num), 256);
        name2[255] = '\0';

        sprintf(stringa,
            name1, name2
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Send name update to all connections. */
        NetSendObjectName(-1, object_num);


        return(0);
}
