#include "swserv.h"



int NetHandleReqObjectSect(int condescriptor, char *arg)
{
	long object_num;


        /*
         *      SWEXTCMD_REQSECT format:
         *
         *      object_num
         */
        sscanf(arg, "%ld",
                &object_num
        );


        if(!DBIsObjectGarbage(object_num))
        {
            NetSendObjectSect(condescriptor, object_num);
        }


        return(0);
}


int NetHandleObjectSect(int condescriptor, char *arg)
{
        int i;
        long object_num, tract_obj_num, con_object_num;  
        long sect_dx, sect_dy, sect_dz;
        long sect_x, sect_y, sect_z;
        xsw_object_struct *obj_ptr, *tract_obj_ptr;


        /* Get object_num. */
        con_object_num = connection[condescriptor]->object_num;

            
        /*
         *	SWEXTCMD_SETOBJSECT format:
         *
         *      object_num
         *      sect_x sect_y sect_z
         */
        sscanf(arg, "%ld %ld %ld %ld",
                &object_num,
        
                &sect_x,
                &sect_y,
                &sect_z
        );

        if(DBIsObjectGarbage(object_num))
            return(-1);
	else
            obj_ptr = xsw_object[object_num];


        /* Connection must own object. */
	if(con_object_num != object_num)
	    return(-3);


	/* Get sector change deltas. */
        if((obj_ptr->sect_x != sect_x) ||
           (obj_ptr->sect_y != sect_y) ||
           (obj_ptr->sect_z != sect_z)
        )
	{
            sect_dx = sect_x - obj_ptr->sect_x;
            sect_dy = sect_y - obj_ptr->sect_y;
            sect_dz = sect_z - obj_ptr->sect_z;

            /* Adjust object's coordinate position within the sector. */
            if(sect_dx < 0)
                obj_ptr->x += sector_legend.x_len;
            else if(sect_dx > 0)
                obj_ptr->x -= sector_legend.x_len;

            if(sect_dy < 0)
                obj_ptr->y += sector_legend.y_len;
            else if(sect_dy > 0)
                obj_ptr->y -= sector_legend.y_len;
/*
            if(sect_dz < 0)
                obj_ptr->z += sector_legend.z_len;
            else if(sect_dz > 0)
                obj_ptr->z -= sector_legend.z_len;
*/
	    /* Sanitize coordinates. */
	    if(obj_ptr->x < sector_legend.x_min)
		obj_ptr->x = sector_legend.x_min + 1;
            if(obj_ptr->x > sector_legend.x_max)
                obj_ptr->x = sector_legend.x_max - 1;

            if(obj_ptr->y < sector_legend.y_min)
                obj_ptr->y = sector_legend.y_min + 1;
            if(obj_ptr->y > sector_legend.y_max)
                obj_ptr->y = sector_legend.y_max - 1;

/*
            if(obj_ptr->z < sector_legend.z_min)
                obj_ptr->z = sector_legend.z_min + 1;
            if(obj_ptr->z > sector_legend.z_max)
                obj_ptr->z = sector_legend.z_max - 1;
 */

            /* Set new sector on object. */
            obj_ptr->sect_x = sect_x;
            obj_ptr->sect_y = sect_y;
            obj_ptr->sect_z = sect_z;


	    /* Need to update objects being tractored. */
            for(i = 0; i < obj_ptr->total_tractored_objects; i++)
            {
                tract_obj_num = obj_ptr->tractored_object[i];
                if(DBIsObjectGarbage(tract_obj_num))
                    continue;
                else
                    tract_obj_ptr = xsw_object[tract_obj_num];

		/* Set tractored object's sector to match object's. */
                tract_obj_ptr->sect_x = sect_x;
                tract_obj_ptr->sect_y = sect_y;
                tract_obj_ptr->sect_z = sect_z;

		/*   Move tractored object's coordinate position
		 *   within the sector.
		 */
                if(sect_dx < 0)
                    tract_obj_ptr->x = obj_ptr->x;
                else if(sect_dx > 0)
                    tract_obj_ptr->x = obj_ptr->x;

                if(sect_dy < 0)
                    tract_obj_ptr->y = obj_ptr->y;
                else if(sect_dy > 0)
                    tract_obj_ptr->y = obj_ptr->y;

/*
                if(sect_dx < 0)
                    tract_obj_ptr->x += sector_legend.x_len;
                else if(sect_dx > 0)
                    tract_obj_ptr->x -= sector_legend.x_len;

                if(sect_dy < 0)
                    tract_obj_ptr->y += sector_legend.y_len;
                else if(sect_dy > 0)
                    tract_obj_ptr->y -= sector_legend.y_len;

                if(sect_dz < 0)
                    tract_obj_ptr->z += sector_legend.z_len;
                else if(sect_dz > 0)
                    tract_obj_ptr->z -= sector_legend.z_len;
*/
            }
	}


        return(0);
}       



int NetSendObjectSect(int condescriptor, long object_num)
{
        char sndbuf[CS_DATA_MAX_LEN];
        xsw_object_struct *obj_ptr;


        if(DBIsObjectGarbage(object_num))
            return(-1);
        else
            obj_ptr = xsw_object[object_num];


        /*
         *      SWEXTCMD_SETOBJSECT format:
         *      
         *      object_num
         *      sect_x sect_y sect_z
         */
        sprintf(sndbuf,
"%i %i\
 %ld %ld %ld %ld\n",
                CS_CODE_EXT,
                SWEXTCMD_SETOBJSECT,

                object_num,
                obj_ptr->sect_x,
                obj_ptr->sect_y,
                obj_ptr->sect_z
        );
        NetDoSend(condescriptor, sndbuf);


        return(0);
}


int NetSendFObjectSect(int condescriptor, long object_num)
{
        char sndbuf[CS_DATA_MAX_LEN];
        xsw_object_struct *obj_ptr;


        if(DBIsObjectGarbage(object_num))
            return(-1);
        else
            obj_ptr = xsw_object[object_num];
           
          
        /*
         *      SWEXTCMD_SETFOBJSECT format:
         *      
         *      object_num
         *      sect_x sect_y sect_z
         */
        sprintf(sndbuf,
"%i %i\
 %ld %ld %ld %ld\n",
                CS_CODE_EXT,
                SWEXTCMD_SETFOBJSECT,

                object_num,
                obj_ptr->sect_x,
                obj_ptr->sect_y,
                obj_ptr->sect_z
        );
        NetDoSend(condescriptor, sndbuf);


        return(0);
}
