/*
                           Quick Menu Management

	Functions:

	void QMenuAllocDefaultEntries()

	int QMenuHandleCB(void *client_data, int op_code)

	int QMenuInit()
	int QMenuDraw()
	int QMenuManage(event_t *xevent)
	void QMenuMap()
	void QMenuUnmap()
	void QMenuFreeAllEntries()
	void QMenuDestroy()

	---


 */

#include "keymap.h"
#include "univlist.h"
#include "optwin.h"
#include "keymapwin.h"
#ifdef JS_SUPPORT
# include "jsmapwin.h"
#endif	/* JS_SUPPORT */

#include "xsw.h"



/*
 *	Procedure to load default quick menu entries.
 */
void QMenuAllocDefaultEntries()
{
	int count;
	char stringa[256];
	const int total_entries = 6;	/* Total default entries. */


	/* Free entries if they are already loaded. */
	if(total_qmenu_entries > 0)
	{
	    fprintf(stderr,
 "QMenuAllocDefaultEntries(): Warning: Entries already allocated.\n"
	    );
	    QMenuFreeAllEntries();
	}


	/* Allocate pointers. */
	qmenu_entry = (qmenu_entry_struct **)realloc(qmenu_entry,
	    total_entries * sizeof(qmenu_entry_struct *)
	);
	if(qmenu_entry == NULL)
	{
	    fprintf(stderr,
		"QMenuAllocDefaultEntries(): Error: Unable to realloc() %i pointers.\n",
		total_entries
	    );
	    total_qmenu_entries = 0;
	    return;
	}
        /* Adjust global variable total_qmenu_entries. */
        total_qmenu_entries = total_entries;


	/* ******************************************************** */

	count = 0;

	/* Entry 0. */
	/* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
	    sizeof(qmenu_entry_struct)
        );

        qmenu_entry[count]->type = MENU_ITEM_TYPE_COMMENT;

	sprintf(stringa, "%s Commands", PROG_NAME);
        qmenu_entry[count]->name = (char *)calloc(1,
	    (strlen(stringa) + 1) * sizeof(char)
	);
	strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));

	qmenu_entry[count]->ximage = NULL;
	qmenu_entry[count]->op_code = XSW_ACTION_NONE;


        /* Entry 1. */
	count++;
        /* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
            sizeof(qmenu_entry_struct)
        );
        
        qmenu_entry[count]->type = MENU_ITEM_TYPE_HR;

	sprintf(stringa, "None");
        qmenu_entry[count]->name = (char *)calloc(1,
            (strlen(stringa) + 1) * sizeof(char)
        );
        strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));

        qmenu_entry[count]->ximage = NULL;
        qmenu_entry[count]->op_code = XSW_ACTION_NONE;

        /* Entry 2. */
        count++;
        /* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
            sizeof(qmenu_entry_struct)
        );
        
        qmenu_entry[count]->type = MENU_ITEM_TYPE_ENTRY;

        sprintf(stringa, "Connect..."); 
        qmenu_entry[count]->name = (char *)calloc(1,
            (strlen(stringa) + 1) * sizeof(char)
        );
        strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));
        
        qmenu_entry[count]->ximage = NULL;
        qmenu_entry[count]->op_code = XSW_ACTION_CONNECT;


        /* Entry 3. */
        count++;
        /* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
            sizeof(qmenu_entry_struct)
        );
        
        qmenu_entry[count]->type = MENU_ITEM_TYPE_ENTRY;
        
        sprintf(stringa, "Refresh");
        qmenu_entry[count]->name = (char *)calloc(1,
            (strlen(stringa) + 1) * sizeof(char)
        );
        strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));

        qmenu_entry[count]->ximage = NULL;
        qmenu_entry[count]->op_code = XSW_ACTION_REFRESH;


        /* Entry 4. */
        count++;
        /* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
            sizeof(qmenu_entry_struct)
        );

        qmenu_entry[count]->type = MENU_ITEM_TYPE_ENTRY;

        sprintf(stringa, "Auto Interval Tune");
        qmenu_entry[count]->name = (char *)calloc(1,
            (strlen(stringa) + 1) * sizeof(char)
        );
        strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));
        
        qmenu_entry[count]->ximage = NULL;
        qmenu_entry[count]->op_code = XSW_ACTION_AINT;


        /* Entry 5. */
        count++;
        /* Allocate memory for new entry. */
        qmenu_entry[count] = (qmenu_entry_struct *)calloc(1,
            sizeof(qmenu_entry_struct)
        );
        
        qmenu_entry[count]->type = MENU_ITEM_TYPE_ENTRY;

        sprintf(stringa, "Disconnect");
        qmenu_entry[count]->name = (char *)calloc(1,
            (strlen(stringa) + 1) * sizeof(char)
        );
        strncpy(qmenu_entry[count]->name, stringa, strlen(stringa));
        
        qmenu_entry[count]->ximage = NULL;
        qmenu_entry[count]->op_code = XSW_ACTION_DISCONNECT;





	return;
}



/*
 *	Initialize quick menu.
 */
int QMenuInit()
{
	int x;
	int status;


        /* Error checks. */
        if(!IDC()) 
            return(-1);
	if(bridge_win.toplevel == 0)
	{
            fprintf(stderr,
                "QMenuInit(): Error: bridge_win.toplevel not initialized.\n"
            );
            return(-1);
	}


	/* ************************************************************* */

	/* Initialize menu. */
	status = MenuInit(
	    &qmenu.menu,
	    osw_gui[0].root_win,
	    QMenuHandleCB,
	    &qmenu
	);
	if(status)
            return(-1);


	/* Add quick menu items. */
	if(qmenu_entry == NULL)
	{
	    fprintf(stderr,
		"QMenuInit(): Warning: Quick menu not defined, using default.\n"
	    );

	    QMenuAllocDefaultEntries();
	}


        for(x = 0; x < total_qmenu_entries; x++)
	{
	    if(qmenu_entry[x] == NULL)
		continue;

	    MenuAddItem(
		&qmenu.menu,
		qmenu_entry[x]->name,
		qmenu_entry[x]->type,
		NULL,		/* No icon. */
		qmenu_entry[x]->op_code,
		-1		/* Append. */
	    );
	}


	return(0);
}



/*
 *	Executes the appropriate item based on given ID code op_code.
 */
int QMenuHandleCB(void *client_data, int op_code)
{
	long object_num;
	int status = 0;


	switch(op_code)
	{
	  /* ********************************************************** */
	  /* Run server. */
	  case XSW_ACTION_RUN_SERVER:
	    XSWMapFB(NULL, PRI_FB_LOADOP_RUN_SERVER);
	    break;

	  /* Server script. */
	  case XSW_ACTION_SERVER_SCRIPT:
	    XSWMapFB(NULL, PRI_FB_LOADOP_SERVER_SCRIPT);
            break;

	  /* Load OCSN file. */
	  case XSW_ACTION_LOAD_OCSN:
	    XSWMapFB(NULL, PRI_FB_LOADOP_OCSN);
	    break;

          /* Load Image Set Referance file. */
          case XSW_ACTION_LOAD_ISREF:
	    XSWMapFB(NULL, PRI_FB_LOADOP_ISREF);
            break;

          /* Load Sound Scheme file */
          case XSW_ACTION_LOAD_SS:
            XSWMapFB(NULL, PRI_FB_LOADOP_SS);
            break;

	  /* ********************************************************** */
	  /* Network actions. */
          case XSW_ACTION_CONNECT:
            UnivListMap();
            break;

	  case XSW_ACTION_CONNECT_LAST:
	    /* Reconnect using the last address and port. */
	    status = NetOpenConnection(net_parms.address, net_parms.port);
	    status = (status < 0) ? -1 : 0;
	    break;

          case XSW_ACTION_DISCONNECT:
	    XSWDoDisconnect();
            break;

          case XSW_ACTION_REFRESH:
	    XSWDoRefresh();
            break;
 
          case XSW_ACTION_AINT:
	    if(auto_interval_tune.state)
		status = CmdAutoInterval("off");
	    else
                status = CmdAutoInterval("on");
            break;

	  /* ******************************************************** */
 	  /* Game play controls. */
          case XSW_ACTION_SHIELDS:
	    if(!DBIsObjectGarbage(lplayer_object))
	    {
		switch(xsw_object[lplayer_object]->shield_state)
		{
		  case SHIELD_STATE_DOWN:
                    status = NetSendSetShields(
		        lplayer_object,
			SHIELD_STATE_UP,
		        xsw_object[lplayer_object]->shield_frequency
		    );
		    break;

		  default:
                    status = NetSendSetShields(
                        lplayer_object,
			SHIELD_STATE_DOWN,
                        xsw_object[lplayer_object]->shield_frequency
		    );
		    break;
		}
	    }
            break;
 
          case XSW_ACTION_CLOAK:
            if(!DBIsObjectGarbage(lplayer_object))
            {
                status = NetSendSetCloak(
		    lplayer_object,
		    (xsw_object[lplayer_object]->cloak_state ==
                        CLOAK_STATE_UP) ? 0 : 1
		);
	    }
            break;
 
          case XSW_ACTION_DMGCTL:
            if(!DBIsObjectGarbage(lplayer_object))
            {
	        status = NetSendSetDmgCtl(
                    lplayer_object,
                    (xsw_object[lplayer_object]->damage_control ==
                        DMGCTL_STATE_ON) ? 0 : 1
		);
	    }
            break;
 
          case XSW_ACTION_WLOCKNEXT:
	    status = NetSendWeaponsLock(lplayer_object, -2);
            break;
 
          case XSW_ACTION_WUNLOCK:
	    status = NetSendWeaponsUnlock(lplayer_object);
            break;

	  /* ********************************************************* */
	  /* Client system. */ 
          case XSW_ACTION_SYNCTIME:
	    status = CmdSynctime("");
            break;
 
          case XSW_ACTION_DISPLABELS:
            option.show_viewscreen_labels++;
            if(option.show_viewscreen_labels > 3)
                option.show_viewscreen_labels = 0;

            /* Redraw viewscreen. */
            VSDrawViewScreen(
                net_parms.player_obj_num,
		bridge_win.viewscreen,
                bridge_win.viewscreen_image,
		bridge_win.viewscreen_zoom
            );
            break;
 
          case XSW_ACTION_MEMORY:
            status = CmdMemory("");
            break;

	  case XSW_ACTION_OPTIONS:
	    OptWinDoMapValues();
	    break;

          case XSW_ACTION_EDIT_KEYMAP:
	    KeymapWinDoMapValues();
	    break;

	  case XSW_ACTION_COMFERM_EXIT:
            prompt_mode = PROMPT_CODE_EXIT;
            PromptChangeName(&bridge_win.prompt, "Exit?:");
            PromptMap(&bridge_win.prompt);
            bridge_win.prompt.is_in_focus = 1;
            status = 0;
	    break;

	  case XSW_ACTION_EXIT:
            status = 0;
            runlevel = 1;
	    break;

	  case XSW_ACTION_ECONOMY:
	    if(!eco_win.map_state)
	    {
		EcoWinDoDeleteInventory();
		EcoWinMap();
	    }
	    if(net_parms.player_obj_ptr != NULL)
	    {
		object_num = net_parms.player_obj_ptr->locked_on;
		if(object_num < 0)
		{
		    /* Not locked on anything, just request score. */
                    NetSendEcoReqValues(
                        net_parms.player_obj_num,
                        object_num
                    );
		}
		else
		{
		    /* Locked on an object, request name and eco info. */
		    NetSendReqName(object_num);

		    NetSendEcoReqValues(
		        net_parms.player_obj_num,
			object_num
		    );
		}
	    }
	    break;

	  case XSW_ACTION_EDIT_JSMAP:
#ifdef JS_SUPPORT
	    JSMWMapValues();
#endif	/* JS_SUPPORT */
	    break;


	  /* *********************************************************** */
	  /* Remote server commands. */ 
          case XSW_ACTION_WHO:
            status = NetSendExec("who");
            break;
 
          case XSW_ACTION_NETSTAT:
	    status = NetSendExec("netstat me");
            break;
 
	  case XSW_ACTION_RMEMORY:
	    status = NetSendExec("memory");
            break;


	  /* *********************************************************** */
	  default:
/*
	    fprintf(stderr,
		"Unsupported Quick Menu function ID code %i.\n",
		op_code
	    );
*/
	    break;
	}


	return(status);
}



/*
 *	Redraw quick menu.
 */
int QMenuDraw()
{
	if(!IDC())
	    return(-1);

	MenuMap(&qmenu.menu);

	return(0);
}



int QMenuManage(event_t *xevent)
{
	static int xevents_handled;


	/* Error checks. */
	if(xevent == NULL)
	    return(0);


	/* *********************************************************** */
	xevents_handled = 0;


        /* Manage menu. */
	if(xevents_handled == 0)
	{
	    xevents_handled += MenuManage(&qmenu.menu, xevent);
	}


	return(xevents_handled);
}


void QMenuMap()
{
	int x, y;


	/* Get pointer position. */
	OSWGetPointerCoords(
	    osw_gui[0].root_win,
	    NULL, NULL,
	    &x, &y
	);


	/* Move the menu's toplevel window. */
	qmenu.menu.x = x;
	qmenu.menu.y = y;


	/* Map the quick menu. */
	QMenuDraw();


	return;
}


void QMenuUnmap()
{
	if(!IDC())
	    return;

	MenuUnmap(&qmenu.menu);


	return;
}



void QMenuFreeAllEntries()
{
	int i;


#ifdef DEBUG_MEM_FREE
printf("Qmenu entry: Deleting %i...\n", total_qmenu_entries);
#endif

	for(i = 0; i < total_qmenu_entries; i++)
	{
	    if(qmenu_entry[i] == NULL)
		continue;

#ifdef DEBUG_MEM_FREE
if(qmenu_entry[i]->name != NULL)
    printf("Qmenu entry %i: Free'ed filename.\n", i);
#endif
	    free(qmenu_entry[i]->name);
	    qmenu_entry[i]->name = NULL;


	    if(IDC())
	    {
#ifdef DEBUG_MEM_FREE
if(qmenu_entry[i]->ximage != NULL)
    printf("Qmenu entry %i: Free'ed ximage.\n", i);
#endif
		OSWDestroyImage(&qmenu_entry[i]->ximage);
	    }

#ifdef DEBUG_MEM_FREE
if(qmenu_entry[i] != NULL)
    printf("Qmenu entry %i: Free'ed.\n", i);
#endif
	    free(qmenu_entry[i]);
	    qmenu_entry[i] = NULL;
	}

#ifdef DEBUG_MEM_FREE
if(qmenu_entry != NULL)
    printf("Qmenu entry pointers: Free'ed.\n");
#endif
        free(qmenu_entry); 
        qmenu_entry = NULL;

	total_qmenu_entries = 0;


	return;
}


void QMenuDestroy()
{

        /* Free all allocated Quick Menu entries. */
        QMenuFreeAllEntries();

	if(IDC())
	{
	    /* Destroy the menu widget. */
	    MenuDestroy(&qmenu.menu);
	}


	return;
}
