/*
 * xdemineur 1.1 - X11 minefield game
 *
 * Author: Marc Baudoin (baudoin@ensta.fr)
 *
 *            |\
 *          |\| \
 *          |//  )
 *        |\ /  /        /\/\_
 *        |//  /        /. . /
 *      |\ /  /     ___/    |_
 *      |//  /     (____/    /_/\_
 *       |__|      (_____/ __     >
 *     /| ___  ________ _< \ \__  >
 *     \|| __\| _|_   _/ \\ \___\/
 *       | __\____ | |/ _ \\    >
 *     /||___\_____|___/ \_\\  _>
 *     \|____           ____ \|
 *       \   \_________/   /
 *        \   _    _      /
 *         \_//   //_____/
 *           (_   \ (_  _\
 *             |/\|   \/
 *
 * Ecole Nationale Superieure de Techniques Avancees (ENSTA)
 * 32, boulevard Victor - 75015 Paris - France
 *
 * Copyright (C) 1993 Marc Baudoin
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.  The author makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 */



#define NB_LIG     16   /* nombre de lignes   du tableau de jeu (par defaut) */
#define NB_COL     30   /* nombre de colonnes du tableau de jeu (par defaut) */
#define NB_MINES   ( int ) ( ( double ) ( nb_lig * nb_col ) / 4.8 )

typedef int BOOLEAN ;
#define TRUE    1
#define FALSE   0

struct jeu
{
   BOOLEAN   mine ;     /* TRUE s'il y a une mine, FALSE sinon  */
   int       nombre ;   /* nombre de mines autour de cette case */
   enum
   {
      COUVERTE     /* on n'a pas regarde     */ ,
      DECOUVERTE   /* on a decouvert la case */ ,
      MARQUEE      /* il y a une mine        */ ,
      INTERRO      /* on se demande          */
   }
   etat ;          /* etat de la case */
} ;
