//
// XBlast Robot File
//
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//
// default value for angles (if not already defined)
//
#ifndef (leftLowerArmAngle)
  #declare leftLowerArmAngle  = <  -15,   0, -30>
#end
#ifndef (leftArmAngle)
  #declare leftArmAngle       = <   15,  10, -45>
#end
#ifndef (rightLowerArmAngle)
  #declare rightLowerArmAngle = <  -15,   0,  30>
#end
#ifndef (rightArmAngle)
  #declare rightArmAngle      = <   15, -10,  45>
#end

#ifndef (rightLowerLegAngle)
  #declare rightLowerLegAngle = < - 25,  0,  0>
#end
#ifndef (rightLegAngle)
  #declare rightLegAngle      = < + 15, 15,  0>
#end
#ifndef (leftLowerLegAngle)
  #declare leftLowerLegAngle  = < - 25,  0,  0>
#end
#ifndef (leftLegAngle)
  #declare leftLegAngle       = < + 15,-15,  0>
#end

#ifndef (rightFootAngle)
  #declare rightFootAngle     = <    0,  0,  0>
#end
#ifndef (leftFootAngle)
  #declare leftFootAngle      = <    0,  0,  0>
#end

#ifndef (headAngle)
  #declare headAngle          = <    0,  0,  0>
#end
#ifndef (bodyAngle)           
  #declare bodyAngle          = <    0,  0,  0>
#end

//
// froce field and other FX
//
#ifndef (activateForceField)
  #declare activateForceField = 0
#end
#ifndef (forceFieldPhase)
  #declare forceFieldPhase = 0.0
#end

//
// sick player
//
#ifndef (playerIsSick)
  #declare playerIsSick=0
#end

//
// additional colors
//
#ifndef (beltColor)
#declare beltColor = color rgb <0.1,0.1,0.1>
#end

#include "XBlastTexture.inc"

//
// some useful shapes
//
#declare helmetSphere =
superellipsoid {
  <1, 0.9>
  rotate x*90
}

//
// include force field
//
#if (activateForceField = 1)
  #include "XBlast Force Field.inc"
#end

//
// the head
//
#declare PlayerHead =
union {
  // helmet
  difference {
    // hull
    difference {
      object {
        helmetSphere
        scale <1.0,0.85,1.0>
      }
      object {
        helmetSphere
        scale <0.95,0.80,0.95>
      }
    }
    // cutout for window
    intersection {
      cylinder { <0.0,-1.25,0.0>, <0.0,-1.25,-2.0>, 1.75 }
      cylinder { <0.0, 1.25,0.1>, <0.0, 1.25,-2.1>, 1.75 }
      plane { x, 0.75 }
      plane { -x, 0.75 }
    }
  }
  // glass window
  difference {
    object {
      helmetSphere
      scale <0.983,0.833,0.983>
    }
    object {
      helmetSphere
      scale <0.967,0.817,0.967>
    }
    texture {myGlass}
  }
  // face
  sphere {
    <0,0,0>, 1
    scale <0.9,0.75,0.9>
    texture {faceTexture}
  }
  // eyes
  #if (playerDamaged)
    intersection {
      sphere {
        <0,0,0>, 1
        scale <0.925,0.775,0.925>
      }
      union {
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <-0.3,0,0>
        }
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <0.3,0,0>
        }
      }
      pigment {color Gray15}
      finish {Glossy }
    }
  #else
  // right eye
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.925,0.775,0.925>
    }
    cylinder {
      <0,0,0>, <0,0,-1.5>, 1
      scale <0.2,0.3,1>
      translate <-0.3,0,0>
    }
    #if (playerIsSick)
      texture {
        spiral1 2
        texture_map {
       	  [0.0 pigment {color Gray15} finish {Glossy} ]
          [0.5 pigment {color Gray15} finish {Glossy} ]
          [0.5 pigment {color rgbt <0,0,0,1>} ]
          [1.0 pigment {color rgbt <0,0,0,1>} ]
        }
        rotate x*90
        scale <0.1,0.15,0.5>
        translate <-0.3,0,0>
      }
    #else
      pigment {color Gray15}
      finish {Glossy }
    #end
  }
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.925,0.775,0.925>
    }
    cylinder {
      <0,0,0>, <0,0,-1.5>, 1
      scale <0.2,0.3,1>
      translate <0.3,0,0>
    }
    #if (playerIsSick)
      texture {
        spiral1 2
        texture_map {
          [0.0 pigment {color Gray15} finish {Glossy} ]
    	  [0.5 pigment {color Gray15} finish {Glossy} ]
	  [0.5 pigment {color rgbt <0,0,0,1>} ]
	  [1.0 pigment {color rgbt <0,0,0,1>} ]
        }
        rotate x*90
        scale <0.1,0.15,0.5>
        translate <0.3,0,0>
      }
    #else
      pigment {color Gray15}
      finish {Glossy }
    #end
  }
  #end
  // antenna
#if (0)
  union {
    cylinder {
      <0,0,0>, <0,1.1,0>, 0.1
      texture {armsLegsTexture}
    }
    sphere {
      <0,1.1,0>, 0.3
      texture {handsFeetTexture}
    }
    rotate x*45
  }
#else
 sphere {
   <0,0,0>, 1
   scale <0.425,0.85,0.85>
   translate <0,0.1125,0.425>
   texture {handsFeetTexture}
 }  
#end
  texture {helmetTexture}
  translate <0, 0.2125,-0.275>
  rotate headAngle
  translate <0,-0.2125, 0.275>
}

//
// the body
//
#declare PlayerBody =
union {
  // main body
  union {
    sphere {
      <0,0,0>, 1	
      scale <0.7,0.8,0.55>
    }
    sphere {
      <0,0,0>, 1	
      scale <0.375, 0.4, 0.475>
      rotate x*-15
      translate <-0.275,0.2,-0.25>
    }
    sphere {
      <0,0,0>, 1	
      scale <0.375, 0.4, 0.475>
      rotate x*-15
      translate < 0.275,0.2,-0.25>
    }
  }
  // backpack
  union {
    superellipsoid {
      <0.5, 0.5>
      scale <0.5,0.45,0.3>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.35,0.1,0.1>
      translate <0.0,0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.35,0.1,0.1>
      translate <0.0,0.0,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.35,0.1,0.1>
      translate <0.0,-0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.30,0.1>
      translate <0.45,0.0,0.05>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.30,0.1>
      translate <-0.45,0.0,0.05>
    }
    translate <0,0.0,0.5>
    texture {backpackTexture}
  }
  // bomb emblem
//   intersection {
//     union {
//       sphere {
//         <0,0,0>, 1	
//         scale <0.725,0.825,0.575>
//       }
//       sphere {
//         <0,0,0>, 1	
//         scale <0.424, 0.425, 0.525>
//         translate <-0.3,0.3,-0.3>
//       }
//       sphere {
//         <0,0,0>, 1	
//         scale <0.425, 0.425, 0.525>
//         translate < 0.3,0.3,-0.3>
//       }
//     }
//     union {
//       cylinder {
//         <0,0,0>, <0,0,-1>, 0.175
//       }
//       box {
//         <0.00,-0.025,0>
//         <0.35, 0.025,-1>
//         rotate z*45
//       }
//       translate <0.3,0.2,0>
//     }
//     pigment {
//       wood
//       color_map {
//         [0.000 color White]
//         [0.100 color White]
//         [0.101 color Gray10]
//         [1.000 color Gray10]
//       }
//       translate <0.3-0.04,0.2+0.04,0.0>
//     }
//     finish {Shiny}
//   }
  // belt
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.725,0.825,0.575>
    }
    union {
      cylinder { <0.0, -0.45, -1>, <0.0, -0.45, 0>, 0.25 }
      intersection {
        plane { -y, 0.55}
        plane {  y,-0.35}
      }
    }
    pigment {color beltColor}
    finish {Dull}
  }
  // belt lock
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.85,0.95,0.65>
    }
    union {
      cylinder {
        <0,0,0>, <0,0,-1>, 0.175
      }
      box {
        <0.00,-0.025,0>
        <0.35, 0.025,-1>
        rotate z*45
      }
      translate <0.0,-0.45,0>
    }
    texture {backpackTexture}
  }
  texture {bodyTexture}
}


#declare PlayerRightHand =
union {
  // main part
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*60
    rotate z*30
    translate <-0.10,-0.05,-0.15>
  }
  // fingers
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <-0.20,-0.025,0.05>
    rotate z*30
  }
  texture {handsFeetTexture}
  rotate z*-15
}

#declare PlayerRightLowerArm =
union {
 object {
    PlayerRightHand
    translate <-0.525,0,0>
  }
  sphere {
    <-0.4,0,0>, 0.200
  }
  cone {
    <-0.024609375, 0, 0>, 0.236343889659
    <-0.421093750, 0, 0>, 0.1990090482792
  }
}

#declare PlayerRightUpperArm =
union {
  object {
    PlayerRightLowerArm
    rotate rightLowerArmAngle
    translate x*-0.4
  }
  union {
    sphere {
      <0,0,0>, 0.275
    }
    cone {
      <-0.028125000, 0, 0>, 0.2736787310389
      <-0.424609375, 0, 0>, 0.236343889659
    }
    sphere {
      <-0.4,0,0>, 0.2375
    }
  }
}

#declare PlayerRightArm =
union {
  object {
    PlayerRightUpperArm
    rotate rightArmAngle
  }
  intersection {
    plane  { -x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.275, 0.275>
  }
  texture {armsLegsTexture}
}

//
// Left arm of player, includings hands
//

#declare PlayerLeftHand =
union {
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*-60
    rotate z*-30
    translate <0.10,-0.05,-0.15>
  }
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <0.20,-0.025,0.05>
    rotate z*-30
  }
  texture {handsFeetTexture}
  rotate z*15
}

#declare PlayerLeftLowerArm =
union {
 object {
    PlayerLeftHand
    translate <0.525,0,0>
  }
  sphere {
    <0.4,0,0>, 0.200
  }
  cone {
    <0.024609375, 0, 0>, 0.236343889659
    <0.421093750, 0, 0>, 0.1990090482792
  }
}

#declare PlayerLeftUpperArm =
union {
  object {
    PlayerLeftLowerArm
    rotate leftLowerArmAngle
    translate x*0.4
  }
  union {
    sphere {
      <0,0,0>, 0.275
    }
    cone {
      <0.028125000, 0, 0>, 0.2736787310389
      <0.424609375, 0, 0>, 0.236343889659
    }
    sphere {
      <0.4,0,0>, 0.2375
    }
  }
}

#declare PlayerLeftArm =
union {
  object {
    PlayerLeftUpperArm
    rotate leftArmAngle
  }
  intersection {
    plane  { x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.275, 0.275>
  }
  texture {armsLegsTexture}
}

//
// legs
//

#declare PlayerFoot =
union {
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { -y, 0 }
    scale <0.3,0.3,0.45>
  }
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { y, 0 }
    scale <0.3,0.1,0.45>
  }
  texture {handsFeetTexture}
}

#declare PlayerLowerRightLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate rightFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, 0.25
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.25
  }
}

#declare PlayerUpperRightLeg =
union {
  object {
    PlayerLowerRightLeg
    rotate rightLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, 0.25
  }
  sphere {
    <0,-0.4,0>, 0.25
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.25
  }
}

#declare PlayerRightLeg =
object {
    PlayerUpperRightLeg
    rotate rightLegAngle
    texture {armsLegsTexture}
}



#declare PlayerLowerLeftLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate leftFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, 0.25
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.25
  }
}

#declare PlayerUpperLeftLeg =
union {
  object {
    PlayerLowerLeftLeg
    rotate leftLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, 0.25
  }
  sphere {
    <0,-0.4,0>, 0.25
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.25
  }
}

#declare PlayerLeftLeg =
object {
  PlayerUpperLeftLeg
  rotate leftLegAngle
  texture {armsLegsTexture}
}

//
// end file "XBlastGirl.inc"
//
