#include "xev.h"

PRIVATE char *fn[] = {
      "jiki.img",
      "jikiL.img",
      "jikiR.img",
      "shojun1.img",
      "shojun2.img",
      "shojun3.img",
      "tama.img",
      "chitama.img"
};

PRIVATE Pixmap pixmap_jiki[6] , pixmap_tama,pixmap_chijou;
PRIVATE Pixmap pixmap_jiki_mask[6],pixmap_tama_mask,pixmap_chijou_mask;
PRIVATE GC gc[6],gc_tama,gc_chijou;
PRIVATE short sho_x,sho_y;
PRIVATE int vx_tbl[16] = {
      0,
      0,
      0,
      0,
      -2*69536*STPF,
      -2*55000*STPF,
      -2*55000*STPF,
      0,
      2*65536*STPF,
      2*55000*STPF,
      2*55000*STPF,
      0,0,0,0,0
};
PRIVATE int vy_tbl[16] = {
      0,
      -2*69536*STPF,
      2*69536*STPF,
      0,
      0,
      -2*55000*STPF,
      2*55000*STPF,
      0,
      0,
      -2*55000*STPF,
      2*55000*STPF,
      0,0,0,0,0
};
PRIVATE int add_char_tbl[16] = {
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      2,
      2,
      2,
      0,0,0,0,0
};

void JikiSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      int x,y;
      XGCValues gcv;
      
      for(c_no = 0 ; c_no < 6 ; c_no++) {
	    sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
	    LoadChar(tpath,img , sizeof(img));
	    gcv.graphics_exposures = False;
	    pixmap_jiki[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
	    bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
	    DrawChar32(img , mask , gc[c_no],pixmap_jiki[c_no]);
	    pixmap_jiki_mask[c_no] 
	      = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
	    XSetClipMask(d,gc[c_no],pixmap_jiki_mask[c_no]);
      }
      
      sprintf(tpath , "%s/%s",IMAGE_DIR,fn[6]);
      LoadChar(tpath,img , sizeof(img));

      pixmap_tama = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
      bzero(mask , sizeof(mask));
      
      gc_tama = XCreateGC(d,w,GCGraphicsExposures,&gcv);

      for(y = 0 ; y < CSIZE ; y++)
	for(x = 0 ; x < CSIZE ; x++) {
	      if(img[y*CSIZE+x] != 100) {
		    mask[y*4+x/8] |= (1<< (x%8));
		    XSetForeground(d,gc_tama,
				   pixel[img[y*CSIZE+x]]);
		    XDrawPoint(d,pixmap_tama,gc_tama,x,y);
	      }
	}
      pixmap_tama_mask
	= XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
      XSetClipMask(d,gc_tama,pixmap_tama_mask);

      sprintf(tpath , "%s/%s",IMAGE_DIR,fn[7]);
      LoadChar(tpath,img , sizeof(img));

      pixmap_chijou = XCreatePixmap(d,w,8,7,depth);
      gc_chijou = XCreateGC(d,w,GCGraphicsExposures,&gcv);
      bzero(mask , sizeof(mask));
      
      for(y = 0 ; y < 7 ; y++)
        for(x = 0 ; x < 8 ; x++) {
              if(img[y*CSIZE+x] != 100) {
                    mask[y+x/8] |= (1<< (x%8));
                    XSetForeground(d,gc_chijou,
                                   pixel[img[y*CSIZE+x]]);
                    XDrawPoint(d,pixmap_chijou,gc_chijou,x,y);
              }
        }
      pixmap_chijou_mask
        = XCreateBitmapFromData(d,w,mask,8,7);
      XSetClipMask(d,gc_chijou,pixmap_chijou_mask);

}

void Auto(inkey)
     int *inkey;
{
      static int l = 0, k = 0;
      int d[9] = {0,1,2,4,8,5,9,6,10};
      
      if(!l) {
	    l = rand() % 16+15;
	    k = d[rand()%9] | (1<<Kx) | (1<<Kz);
      }
      *inkey = k;
      l--;
}

void Shot(s_cntr)
     int s_cntr;
{
      int i;
      
      for(i = 0 ; i < SHOT_NUM ; i++){
            if(s_cntr == 0 && shot[i].flag == 0) {
                  shot[i].flag = 1;
                  shot[i].x.dummy = jx.dummy;
                  shot[i].y.dummy = jy.dummy+32*65536;
                  break;
            }
      }
}

void ShotChi()
{
      if(shot_chi.flag == 0) {
	    shot_chi.flag = 1;
	    shot_chi.x.dummy = jx.dummy+12*65536;
	    shot_chi.y.dummy = jy.dummy;
	    shot_chi.z = 24/STPF;
	    sho_x = jx.sht[UNION];
	    sho_y = jy.sht[UNION]-208;
      }
}

void ShotChiF()
{
      if(shot_chi.flag) {
	    if(shot_chi.z == 0) {
		  shot_chi.flag = 0;
		  return;
	    } else {
		  shot_chi.z--;
		  shot_chi.y.dummy -= 8*65536*STPF;
		  SetSprite(shot_chi.x.sht[UNION],
			    shot_chi.y.sht[UNION],
			    pixmap_chijou,gc_chijou,
			    8,7);
		  SetSprite(sho_x,(sho_y+=STPF),pixmap_jiki[5],
			    gc[5],CSIZE,CSIZE);
	    }
      }
}

void ShotF(s_cntr)
     int *s_cntr;
{
      int i;
      int cntr = 0;
      for(i = 0 ; i < SHOT_NUM ; i++) {
	    
            if(shot[i].flag)
              if(shot[i].y.sht[UNION] < -32) {
                    shot[i].flag = 0;
              } else {
                    cntr++;
		    shot[i].y.dummy -= 32*65536;
		    SetSprite(shot[i].x.sht[UNION],shot[i].y.sht[UNION],
			      pixmap_tama,gc_tama,CSIZE,CSIZE);
	      }
      }
}

void InitJiki()
{
      int i;

      jx.dummy = XSIZE*32768;
      jy.dummy = (YSIZE - CSIZE*2)*65536;
      shot_chi.flag = 0;
      for(i = 0 ; i < SHOT_NUM ; i++)
	shot[i].flag = 0;
      
      SetSprite(jx.sht[UNION],jy.sht[UNION],pixmap_jiki[0],
		gc[0],CSIZE,CSIZE);
}

void Pause()
{
      int inkey;

      u_sleep(wait_tbl[wait_val]*4);

      while(1) {
	    inkey = CheckEvent();
	    
	    if(inkey & (1<<Ks)) {
		  break;
	    }
	    Rast();
      }
}

int Jiki(t_flag)
     int t_flag;
{
      static int s_cntr = 0;
      int vx,vy,add_char = 0;
      int inkey;

      SetSprite(jx.sht[UNION],jy.sht[UNION]-214,pixmap_jiki[3+shojun_flag],
		gc[3+shojun_flag],CSIZE,CSIZE);
      
      shojun_flag = 0;
      
      vx = vy = 0;

      inkey = CheckEvent();      
      if(t_flag) {
	    Auto(&inkey);
	    inkey |= 0x60;
      }

      vx = vx_tbl[inkey&15];
      vy = vy_tbl[inkey&15];
      add_char = add_char_tbl[inkey&15];
	    
      if(jx.dummy + vx > 0 && jx.dummy + vx < (XSIZE-CSIZE)*65536)
	jx.dummy += vx;

      if(jy.dummy + vy > 224*65536 && jy.dummy + vy < (YSIZE-CSIZE)*65536)
        jy.dummy += vy;

      if(inkey & (1<<Kz)) {
	    Shot(s_cntr);
            s_cntr = (++s_cntr) & rensha;
      } else {
            s_cntr = 0;
      }
      
      if(inkey & (1<<Kx)) {
	    ShotChi();
      }
      
      if(inkey & (1<<Ks)) {
	    Pause();

      }

      ShotF(&s_cntr);
      ShotChiF();
      if(inkey & (1<<Kq)) {
	    return 1;
      }

      SetSprite(jx.sht[UNION],jy.sht[UNION],
		pixmap_jiki[add_char],gc[add_char],
		CSIZE,CSIZE);

      return 0;
}


            


