///////////////////////////////////////////////////////////////////////////////
// $Id: TopLevel.cxx,v 1.2 1996/01/06 05:10:13 bwmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// TopLevel.cxx - Top level widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: TopLevel.cxx,v $
// Revision 1.2  1996/01/06 05:10:13  bwmott
// Changed all NULLs to 0
//
// Revision 1.1  1995/01/08 06:52:21  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "TopLevel.hxx"
#include "UIApplication.hxx"

#include <X11/Xatom.h>
#include <X11/Xutil.h>


///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
TopLevel::TopLevel(const char *const name, int x, int y, 
    int width, int height, Command* closeCommand)
    : ContainerWidget(0, name, x, y, width, height),
      myCloseCommand(closeCommand)
{
  // Tell the application that I exist
  application->addTopLevel(this);

  // Create window for widget
  myWindow = XCreateSimpleWindow(application->display(),
      application->rootWindow(),
      x, y, width, height,
      2, application->blackPixel(), application->blackPixel());

  // Setup the window manager hints
  XSizeHints hints;
  hints.flags = PSize | PMinSize | PMaxSize;
  hints.width = hints.min_width = hints.max_width = width;
  hints.height = hints.min_height = hints.max_height = height;
  XSetStandardProperties(application->display(), myWindow,
      name, name, None, 0, 0, &hints); 

  // Setup the window manager protocol
  Atom kill = XInternAtom(application->display(), "WM_DELETE_WINDOW", False);
  XSetWMProtocols(application->display(), myWindow, &kill, 1);
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
TopLevel::~TopLevel()
{
  // Tell the application that I nolonger exist
  application->removeTopLevel(this);

  // Destroy myCloseCommand
  delete myCloseCommand;
}

///////////////////////////////////////////////////////////////////////////////
// Called whenever an event arrives for me (I need to override the default)
///////////////////////////////////////////////////////////////////////////////
void TopLevel::handleEvent(XEvent* event)
{
  if(event->type == ClientMessage)
  {
    Atom protocol = XInternAtom(application->display(), "WM_PROTOCOLS", False);
    Atom kill = XInternAtom(application->display(), "WM_DELETE_WINDOW", False);

    // See if the user is trying to kill this toplevel window
    if(event->xclient.message_type == protocol &&
       event->xclient.data.l[0] == kill)
    {
      // If I have a close command execute it otherwise delete myself
      if(myCloseCommand != 0)
        myCloseCommand->execute(0);
      else
        delete this;
    }
  }
}

