///////////////////////////////////////////////////////////////////////////////
// $Id: PlainDeck.cxx,v 1.1 1995/01/08 06:45:15 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// PlainDeck.cxx - Deck that does no event processing
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: PlainDeck.cxx,v $
// Revision 1.1  1995/01/08  06:45:15  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "UIApplication.hxx"
#include "Sprite.hxx"
#include "SpriteCollection.hxx"
#include "Card.hxx"
#include "PlainDeck.hxx"


///////////////////////////////////////////////////////////////////////////////
// Construct a partial deck of plain cards
///////////////////////////////////////////////////////////////////////////////
PlainDeck::PlainDeck(ContainerWidget* parent, const char *const widgetName,
    int x, int y, int width, int maxHeight, SpriteCollection* sprites,
    LinkedList<Card>* cards)
    : Deck(parent, widgetName, x, y, width, maxHeight, sprites)
{
  // Move each of the cards from the LinkedList into my ListOfCards
  for(Card* card = cards->remove(); card != (Card*)0; card = cards->remove())
  {
    myListOfCards.prepend(card);
  }

  // Update my view
  updateView();
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
PlainDeck::~PlainDeck()
{ }

