/*
 * File: scroll.h
 * Author: Brent Hendricks
 * Project: NetSpades
 * Date: 3/30/98
 *
 * This file contains declarations for functions handling scrolling 
 * in SLang.  I took most of it out of the demos distributed with SLang.
 *
 * Copyright (C) 1998 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


/* Node in linked list of lines for scroll window */
typedef struct _Line_Type {
  struct _Line_Type *next;
  struct _Line_Type *prev;
  char *data;                        
} Line_Type;

void ScrollInit( void );

static Line_Type *create_line (char *buf);

void AddScrollLine( char* buf );

void update_display( void );

void free_lines( void );
