#include "../ballistics.h"
#include "../gfx.h"
#include "../log.h"


void wgxDrawBurningNapalmShot(struct Projectilepos_bal *prjpos, void* info)
{
    int tx=prjpos->x;
    int ty=prjpos->y;
    int otx=prjpos->ox;
    int oty=prjpos->oy;

    
    int sx=gfxTerrainToScreenXCoord(tx);
    int sy=gfxTerrainToScreenYCoord(ty);

    gfxDrawArea(otx-gfxScaleScreenToTerrainXDimen(2),
				oty-gfxScaleScreenToTerrainYDimen(2), 
				gfxScaleScreenToTerrainXDimen(5), 
				gfxScaleScreenToTerrainYDimen(5));
    
    if(tx==-1 && ty==-1) return;

    ggiPutPixel(gfx_vis, 
				sx,
				sy,
				gfx_red);
    ggiPutPixel(gfx_vis, 
				sx+1,
				sy,
				gfx_red);
    ggiPutPixel(gfx_vis, 
				sx-1,
				sy,
				gfx_red);
    ggiPutPixel(gfx_vis, 
				sx,
				sy+1,
				gfx_red);
    ggiPutPixel(gfx_vis, 
				sx,
				sy-1,
				gfx_red);
}

void wgxDrawBurningNapalmExplosion(void* info)
{
    int i, y;
    ggi_color c;
    ggi_pixel gfx_burning;
    int tx=((struct BurningNapalmExplosion_wep*)info)->x;
    int twidth=((struct BurningNapalmExplosion_wep*)info)->width;
    int sx=0;
    int sy=0;
    
    if(((struct BurningNapalmExplosion_wep*)info)->duration%2)
    {
	    c.g=0xDFFF;
    }
    else
    {
        c.g=0x1FFF;
    }
	c.r=0xFFFF;
	c.b=0x0;
	c.a=0xFF<<8;
	
    if(((struct BurningNapalmExplosion_wep*)info)->duration <= 0)
    {
	    c.r=0xEF;
	    c.g=0xEF;
	    c.b=0xEF;
	    c.a=0xFF<<8;
    }
    gfx_burning=ggiMapColor(gfx_vis, &c);
	ggiSetGCForeground(gfx_vis, gfx_burning);
    for( i=(tx-(twidth/2)); i<=(tx+(twidth/2)); i++)
    {
        y=terGetHeight(&ter_data[i]);
        sy=gfxTerrainToScreenYCoord(y);
        sx=gfxTerrainToScreenXCoord(i);
        ggiPutPixel(gfx_vis, sx, sy+1, gfx_burning); 
        ggiPutPixel(gfx_vis, sx, sy+2, gfx_burning); 
        ggiPutPixel(gfx_vis, sx, sy+3, gfx_burning); 
    }
}
