
%{

#include "trilby-parser-tp.h"

#ifndef NDEBUG
#define YYDEBUG 1
#define TPDEBUG 1
#endif

#include "parser-hooks.h"

struct LayoutOpts
{
 char align;
 int lmargin;
 int rmargin;
} lopts;

struct ParaOpts
{
 int fontsize;
 int red;
 int green;
 int blue;
} popts;

extern int tplex();
static void tperror(char* s);
static void POpts(int, int, int, int);
static void LOpts(char, int, int);

%}

%union
{
 char* string;
 int integer;
 char character;
};

%token <string> STRING
%token <integer> NUMBER
%token <character> ALIGN
%token S_PARAGRAPH

%start input

%%

input: 	/* nothing */
   	| header blocks
	;

header: '{' NUMBER '}'
	{
		setVersion($2);
	}

blocks:	/* nothing */
	| blocks block
	;

block:	S_PARAGRAPH layout_opts para_opts STRING
	{
		createLines(popts.fontsize, lopts.align, lopts.lmargin,
				lopts.rmargin, popts.red, popts.green, 
				popts.blue, $4);
	}
	;

layout_opts:	/* nothing */
	{
		LOpts('l', 0, 0);
	}		
	| '[' ALIGN ',' NUMBER ',' NUMBER ']'
	{
		LOpts($2, $4, $6);
	}
	;

para_opts:	/* nothing */
	{
		POpts(3, 5, 5, 5);
	}
	| '(' NUMBER  ',' NUMBER ',' NUMBER ',' NUMBER ')'
	{
		POpts($2, $4, $6, $8);
	}		
	;

%%


	
static void LOpts(char c, int l, int r)
{
 lopts.align = c;
 lopts.lmargin = l;
 lopts.rmargin = r;
}

static void POpts(int f, int r, int g, int b)
{
 popts.fontsize = f;
 popts.red = r;
 popts.green = g;
 popts.blue = b;
}

static void tperror(char* s)
{
 printf("%s\n", s);
}

extern void viewparserNewFile(FILE* fp);

int viewParse(const char* filename)
{
 FILE* fp;
 if((fp = fopen(filename, "r")) == NULL) return 1;

 printf("Parsing %s:\n", filename);
 viewparserNewFile(fp);
 if(tpparse()) return 1;
 fclose(fp);
 return 0;
}






