/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/
/*
 * Viewer - the implemantation of the Documentation Viewer
 */

#include <assert.h>

#include "../hatman/Background.h"
#include "../hatman/Data.h"
#include "../hatman/files.h"
#include "../util/debug.h"
#include "../util/error.h"
#include "../util/Ticker.h"
#include "Viewer.h"
#include "../gl/Console.h"
#include "../gl/Keyboard.h"
#include "../gl/keycodes.h"
#include "../gl/Rect.h"
#include "../gl/VgaContext.h"
#include "../gl/VgaBlur.h"

Viewer::Viewer(Collection<ViewObject>* _objects, char* _bk, int _x, int _y, int _w, int _h)
{
 assert(_objects != NULL); assert(_bk != NULL);

 objects = _objects;
 x = _x; y = _y; w = _w; h = _h;
 
 top = 0;
 
 background = _bk;
 
 first = 0;
 last = objects->length() - 1;
 
 VPRINTF("<doc> viewing file with %d objects\n", objects->length());

 totalHeight = 0;
 foreach(*objects, i) totalHeight += objects->at(i)->getHeight();

 for(int i = first; i < objects->length(); i++)
  {
   if((*objects)[i]->getVOffset() > h)
    {
     last = i-1;
     break;
    }
  }
}

bool Viewer::init()
{
 VPRINTF("<doc> initialising\n");
 
 // check background
 //if(strcmp(bk->getFilename(), libFileName(background)))
 //if(bk->load(libFileName(background)) == false)
 //{
 //setError("Viewer could not load background: %s", errStr);
 //return false;
 //}
 
 screen->clippingRect = Rect(x, y, x+w, y+h);
 draw();
 
 return true;
}

void Viewer::draw()
{
 assert(top >= 0);
 bk->copyTo(screen);
 for(int i = first; i <= last; i++)
  {
   ViewObject* v = (*objects)[i];
   assert(v != NULL);
   v->draw(Point(x, y - top), screen);
  }
 screen->update();  
}

bool Viewer::run()
{
#if 0
 Ticker ticker(10);
 bool quit = false;

 while(!quit)
  {
   // Keyboard stuff
   if(keyboard->update())
    {
     if(KP_Q) quit = true;
     if(KP_ESCAPE) quit = true;
     if(KP_DOWN) scrollDown(4);
     if(KP_UP) scrollUp(4);
    }

   ticker.tick();
   if(ticker.spare()) { draw(); ticker.yield(); }
  }
#endif

 return true; 
}

bool Viewer::scrollDown(int dist)
{
 assert(dist > 0);
 top += dist;
 if(top + h > totalHeight) top = (totalHeight > h)? totalHeight - h : 0;
 int items = objects->length();

 while(objects->at(first)->getVOffset() + objects->at(first)->getHeight() <= top && first + 1 < items) first++;
 while(objects->at(last)->getVOffset() < top + h && last + 1 < items) last++;

 assert(first >= 0 && first < items);
 assert(last >= 0 && last < items);
 assert(last >= first);

 return false;
}

bool Viewer::scrollUp(int dist)
{
 assert(dist > 0);
 top -= dist;
 if(top < 0) top = 0;
 int items = objects->length(); (void)items;

 while(objects->at(first)->getVOffset() > top) first--;
 while(objects->at(last)->getVOffset() >= top + h) last--;
 
 assert(first >= 0 && first < items);
 assert(last >= 0 && last < items);
 assert(last >= first);

 return false;  
}
