/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#pragma implementation

#include "ViewObject.h"
#include "../util/Collection.h"
#include "../util/debug.h"
#include "../util/util.h"
#include <assert.h>

template class Collection<ViewObject>;

int Line::draw(Point p, VgaBlur* vc)
{
 /*
 font->color(color);
 font->setHAlign(align);
 font->writef(vc, p + Point(hOffset, vOffset), "%s", text);
 */
 return height;
}

Line::Line(int _width, int _height, int _offset, Font* _font, /*Font::HAlign*/int _align, int _margin, int _color, char* _text)
 : ViewObject(_width, _height, _offset)
{
 assert(_font != NULL); assert(_text != NULL);
 VPRINTF("<doc> creating Line \"%s\" offset %d\n", _text, _offset);
 text = newString(_text);
 font = _font;
 align = _align;
 color = _color;  
 /*
 switch(align)
  {
  case Font::Left:
   hOffset = _margin;
   break;
  case Font::Right:
   hOffset = _margin + _width - 1;
   break;
  case Font::Centre:
   hOffset = _margin + _width/2 - 1;
   break;
  }
 */
}
