/*C* $Id: error.h,v 1.2 1997/08/11 19:21:31 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/
/*
 * This module adds the following printf()-style formats (taking no parameters):
 * %y : value of strerror(errno).
 * %z : last error value as set by setError(...).
 *
 */

#ifndef util_error_h
#define util_error_h

extern char* errStr;

extern void setError(const char* format, ...) __attribute__ ((format (printf, 1, 2)));
extern void initError();
extern const char* errnoStr();

#define EPRINTF(format, args...) fprintf(stderr, format, ## args)

#endif
