/*C* $Id: debug.h,v 1.2 1997/09/25 20:08:55 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef util_debug_h
#define util_debug_h

#include <stdio.h>

//-----------------------------------------------------------------------------
#ifndef NDEBUG
#define DPRINTF(format, args...) fprintf(stderr, format, ## args)
extern int vdebug;
#define VPRINTF(format, args...) if(vdebug) fprintf(stderr, format, ## args)
#else
#define DPRINTF(format, args...)
#define VPRINTF(format, args...)
#endif
/*
 * This is nasty and GNUy, but hey - why not?
 */

//-----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" void fatal(const char *format = "Fatal error\n", ...);
extern "C" void nonFatal(const char* format = "Non-fatal error\n", ...);
#else
extern void fatal(const char* format, ...);
extern void nonFatal(const char* format, ...);
#endif

#endif
