/*C* $Id: str.cc,v 1.3 1997/09/27 00:08:56 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Collection.h"
#include "String.h"
#include <string.h>

template class Collection<String>;

String& String::operator = (String& string)
{
 delete s;
 s = newString(string.s);
 return *this;
}

String& String::operator = (const char* object)
{
 delete s;
 s = newString(object);
 return *this;
}

String& String::operator += (const char* object)
{
 char* ns = new char[length() + strlen(object) + 1];
 strcpy(ns, s); strcat(ns, object);
 delete s; s = ns; return *this;
}

String& String::operator += (const char object)
{
 int n = length();
 char* ns = new char[n + 2];
 strcpy(ns, s); ns[n] = object; ns[n+1] = '\0';
 delete s; s = ns; return *this;
}

String String::operator + (const char* object)
{
 int n = length();
 char* ns = new char[n + strlen(object) + 1];
 strcpy(ns, s); strcpy(ns + n, object);
 String string(ns); delete ns; return string;
}

String String::operator + (const char object)
{
 int n = length();
 char* ns = new char[n + 2];
 strcpy(ns, s); ns[n] = object; ns[n+1] = '\0';
 String string(ns); delete ns; return string;
}

bool String::endsin(const char* end)
{
 if(strlen(s) < strlen(end)) return false;
 if(strcmp(s + strlen(s) - strlen(end), end) != 0) return false;
 return true;
}
