/*C* $Id: vga++blur.cc,v 1.4 1997/09/08 16:34:53 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Rect.h"
#include "VgaBlur.h"
#include "../util/Ticker.h"
#include "../util/util.h"

//--------------------------------------------------------------------------------------------------------------------------------

VgaBlur::VgaBlur()
{
 blurs1 = new Collection<Rect>(32, 32);
 blurs2 = new Collection<Rect>(32, 32);
 blurZone = new VgaContext();
}

VgaBlur::~VgaBlur()
{
 delete blurZone;
 delete blurs1;
 delete blurs2;
}

//--------------------------------------------------------------------------------------------------------------------------------

void VgaBlur::wipeUpdate(int h, int d)
{
 Ticker t(d);
 for(int i = 0; i < h; i++)
  {
   for(int y = i; y < screenSize.y; y += h)
    updateLineSegment(Point(0, y), screenSize.x);
   t.tickAndCatchUp();
  }
}

//--------------------------------------------------------------------------------------------------------------------------------

void VgaBlur::copyBlurs()
{
 // first we copy the blurs, new and old to the physical screen
 int maxBlurs = blurs1->length() >? blurs2->length();

 // this may seem a little odd, but trust me :)
 for(int i=0; i<maxBlurs; i++)
  {
   if(i < blurs1->length()) update(*blurs1->at(i));
   if(i < blurs2->length()) update(*blurs2->at(i));
  }

 // then we restore all the double blurs from the blurzone
 foreach(*blurs2, i) copyBoxFrom(blurZone, *blurs2->at(i));
 
 // then get rid of the old blurs
 blurs1->delAll();
 swap(blurs1, blurs2);
}

void VgaBlur::clearBlurs()
{
 blurs1->delAll();
 blurs2->delAll();
}

//--------------------------------------------------------------------------------------------------------------------------------
