/*C* -*-c++-*-
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "Control.h"
#include "../util/debug.h"
#include "../gl/Color.h"
#include "../gl/Console.h"
#include "../gl/VgaBlur.h"

//--------------------------------------------------------------------------------------------------------------------------------

template class Collection<Control>;

//--------------------------------------------------------------------------------------------------------------------------------

Control::Control(Rect _rect, Events* _events)
{
 assert(_rect.onScreen());
 assert(_events);

 pRect = _rect;
 events = _events;
}

Control::~Control()
{
}

/*

//--------------------------------------------------------------------------------------------------------------------------------

bool Control::overlap()
{
 int n = children->length();
 if(n < 2) return false; 
 for(int i=0; i+1<n; i++) for(int j=i+1; j<n; j++)
  {
   Rect r1 = children->at(i)->absRect();
   Rect r2 = children->at(j)->absRect();
   if(r1.contains(r2.topLeft()) || r1.contains(r2.topRight()) || r1.contains(r2.bottomLeft()) || r1.contains(r2.bottomRight()))
    return true;
  }
 return false;
}

//--------------------------------------------------------------------------------------------------------------------------------

Rect Control::draw()
{
 myDraw();
 foreach(*children, i)
  children->at(i)->draw();
 return absRect();
}

void Control::myDraw()
{
 screen->fillBox(absRect(), Color(0, 0, 0));
}

//--------------------------------------------------------------------------------------------------------------------------------

void Control::distributeMouse(Point p, int b)
{
 // first check if it falls in a childs window, and if so call that childs distributeMouse method
 foreach(*children, i)
  if(children->at(i)->rect().contains(p))
   {
    children->at(i)->distributeMouse(p - children->at(i)->rect().topLeft(), b);
    return;
   }
 // otherwise handle the mouse event ourselves
 myMouse(p, b);
}

void Control::myMouse(Point p, int b)
{
}

//--------------------------------------------------------------------------------------------------------------------------------

void Control::event(int eventId, Control* source)
{
 if(parent) parent->event(eventId, source);
 else nonFatal("<control> event unreceived %d\n", eventId);
}

//--------------------------------------------------------------------------------------------------------------------------------

*/
