/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <glib.h>
#include "pro.h"
#include "position.h"
#include "makros.h"
#include "ckis.h"

#define CHECK(king_place,direction,piece1,piece2)\
{  int 	i= king_place; \
   do { i += direction; } \
   while(!currPositionPtr->square[i]); \
   if (currPositionPtr->square[i] == piece1) return piece1; \
   if (currPositionPtr->square[i] == piece2) return piece2; \
}

static int long4(int ort,int r1,int r2,int r3,int r4,int f1,int f2)
{

  CHECK(ort,r1,f1,f2);
  CHECK(ort,r2,f1,f2);
  CHECK(ort,r3,f1,f2);
  CHECK(ort,r4,f1,f2);
  return FALSE;
}   

#define KURZ_TEST(r)   if (currPositionPtr->square[ort+r] == f1) return f1

static int short8(int ort,int r1,int r2,int r3,int r4,int r5,int r6,int r7,int r8,int f1)
{
  KURZ_TEST(r1);
  KURZ_TEST(r2);
  KURZ_TEST(r3);
  KURZ_TEST(r4);
  KURZ_TEST(r5);
  KURZ_TEST(r6);
  KURZ_TEST(r7);
  KURZ_TEST(r8);

  return FALSE;
}	
      


int king_is_attacked_white()
{
   int ret;
   int k= currPositionPtr->wki;

   ret = long4(k,9,11,-9,-11,BQ,BB);
   if (ret) return ret;
   
   ret = long4(k,1,10,-10,-1,BQ,BR);
   if (ret) return ret;
   
   if( short8(k,8,12,19,21,-8,-12,-19,-21,BN)) return BN;
   if( short8(k,9,11,-9,-11,1,10,-10,-1,BK)) return BK;
   
   if (currPositionPtr->square[k+OL] == BP)
   	return BP;
   if (currPositionPtr->square[k+OR] == BP)
   	return BP;


   return FALSE;
}

int king_is_attacked_black(void)
{
   int ret;
   int k = currPositionPtr->ski;
	
   ret = long4(k,9,11,-9,-11,WQ,WB);
   if (ret) return ret;
   
   ret = long4(k,1,10,-10,-1,WQ,WR);
   if (ret) return ret;
   
   if( short8(k,8,12,19,21,-8,-12,-19,-21,WN)) return WN;
   if( short8(k,9,11,-9,-11,1,10,-10,-1,WK)) return WK;
   
   if (currPositionPtr->square[k+UL] == WP)
   	return WP;
   if (currPositionPtr->square[k+UR] == WP)
   	return WP;

   return FALSE;
}
