#include <gtk/gtk.h>
#include <stdio.h>

#include "../version.h"

#include "guiinterface.h"

void gui_about_dialog_create(GtkWidget **dialog)
{
	GtkWidget *box, *button;
	char str[256];

	*dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(*dialog), "destroy", GTK_SIGNAL_FUNC(cb_dialog_destroy), dialog);
	gtk_window_set_title(GTK_WINDOW(*dialog), "About");
	gtk_container_border_width(GTK_CONTAINER(*dialog), 10);

	box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(*dialog), box);

	sprintf(str, "%s\ncreated by Eyal Lotem\nand Yair Chuchem", GAME_NAME);
	gtk_box_pack_start_defaults(GTK_BOX(box), gtk_label_new(str));
	sprintf(str, "Version: %s", VERSION);
	gtk_box_pack_start_defaults(GTK_BOX(box), gtk_label_new(str));
	gtk_box_pack_start(GTK_BOX(box), gtk_hseparator_new(), FALSE, FALSE, 10);

	button = gtk_button_new_with_label("Enough of that");
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(*dialog));
	gtk_box_pack_start_defaults(GTK_BOX(box), button);

	gtk_widget_show_all(*dialog);
}
