#include <stdio.h>
#include <string.h>

#include "coordinate.h"
#include "game.h"

Coordinate direction[8] = {
/* Right, RightDown, Down, LeftDown */
	{{ 1, 0}}, {{ 1,  1}}, {{0,  1}}, {{-1,  1}},
/* Left, LeftUp, Up, RightUp */
	{{-1, 0}}, {{-1, -1}}, {{0, -1}}, {{ 1, -1}}
};

Coordinate *coordinate_copy(Coordinate *dest, Coordinate *src)
{
	memcpy(dest, src, sizeof(Coordinate));

	return dest;
}

inline int coordinate_clip_x(Coordinate *coor)
{
	if(coor->xy[0] < 0) {
		coor->xy[0] = 0;
		return 1;
	} else if(coor->xy[0] > BOARD_XSIZE-1) {
		coor->xy[0] = BOARD_XSIZE-1;
		return 1;
	}
	return 0;
}

inline int coordinate_clip_y(Coordinate *coor)
{
	if(coor->xy[1] < 0) {
		coor->xy[1] = 0;
		return 1;
	} else if(coor->xy[1] > BOARD_YSIZE-1) {
		coor->xy[1] = BOARD_YSIZE-1;
		return 1;
	}
	return 0;
}

int coordinate_clip(Coordinate *coor)
{
	int tmp;

	tmp = coordinate_clip_x(coor) | coordinate_clip_y(coor);

	return tmp;
}

inline Coordinate *coordinate_add(Coordinate *coor, Coordinate *addition)
{
	int i;

	for(i=0; i<2; i++)
		coor->xy[i] += addition->xy[i];

	return coor;
}

int coordinate_add_with_clip(Coordinate *coor, Coordinate *addition)
{
	coordinate_add(coor, addition);
	return coordinate_clip(coor);
}

void coordinate_print(Coordinate *coor)
{
	printf("Coordinate: %d, %d\n", coor->xy[0], coor->xy[1]);
}

inline int coordinate_valid_x(Coordinate *coor, int xmax)
{
	return (coor->xy[0] >= 0 && coor->xy[0] <= xmax);
}

inline int coordinate_valid_y(Coordinate *coor, int ymax)
{
	return (coor->xy[1] >= 0 && coor->xy[1] <= ymax);
}

int coordinate_valid(Coordinate *coor, int xmax, int ymax)
{
	return coordinate_valid_x(coor, xmax) && coordinate_valid_y(coor, ymax);
}

int coordinate_foreach(Coordinate *coor, int left, int top, int right, int bottom, CoordinateFunc f, void *data)
{
	int tmp;

	for(coor->xy[0] = left; coor->xy[0] <= right; coor->xy[0]++)
		for(coor->xy[1] = top; coor->xy[1] <= bottom; coor->xy[1]++)
			if((tmp = f(coor, data)) != 0)
				return tmp;
	return 0;
}

/* Return value 0/non-zero means equal/non-equal
 */
int coordinate_compare(Coordinate *coor0, Coordinate *coor1)
{
	return memcmp(coor0, coor1, sizeof(Coordinate));
}
