#ifndef __AI_ACCEL_H_
#define __AI_ACCEL_H_

#include "../coordinate.h"
#include "../game.h"

#define THINK_MAP_MAX	100 // (1+2+3+4+5+4+3+2+1)*4

typedef struct {
	int count;
	Coordinate block[8];
} Threat;

typedef struct {
	Threat threat[BOARD_XSIZE][BOARD_YSIZE];
	int threat_count[3];
} Threats;

typedef struct {
	int amount[3];
} Five;

typedef struct {
	Five five[4][BOARD_XSIZE][BOARD_YSIZE];
} Fives;

typedef struct {
	int val[BOARD_XSIZE][BOARD_YSIZE];
} ThinkMap;

typedef struct {
	int state[2];
	Threats threats[2];
	ThinkMap think_map;
	Fives fives;
} ThinkAccelData;

void ai_think_accel_create(ThinkAccelData *data);
void ai_think_accel_update(ThinkAccelData *data, Coordinate *move, int e_turn, int inc, Square old, Square vmove);
int ai_think_accel_threats_win_find(ThinkAccelData *think_accel_data, int e_turn, int *best, Coordinate *best_move, int level);
int ai_think_accel_threats_lose_find(ThinkAccelData *think_accel_data, int *best, Coordinate *best_move, Coordinate *last_move, int e_turn, int turn, int energy, int level);
int ai_think_accel_immediate_test(ThinkAccelData *data, Coordinate *move, Coordinate *coor, int e_turn);
void ai_think_accel_show(ThinkAccelData *data);
int ai_think_accel_relevance(ThinkAccelData *think_accel_data, Coordinate *c);
int ai_think_accel_win_test(ThinkAccelData *data);
inline int ai_think_accel_board_value(ThinkAccelData *think_accel_data, int e_turn);
void ai_think_accel_init(void);

#endif
