#!/bin/sh
### install.sh - instalacni skript pro ceske a slovenske fortunes
### -- Zdenek Pytela, 98.06.08
###
### Instalace:
### V adresari FORTUNESDIR se vytvori podadresar cs a pripadne cs-KODOVANI
###  podle verze kodovani, zdrojove texty jsou kodovany v ISO 8859-2.
### Ceske fortunes se spousti "fortune cs",
###  eventualne "fortune cs-KODOVANI", napr. fortune cs-ascii.
### Pripominky, opravu chyb a nove prispevky vlastni i nalezene muzete
###  posilat na adresu <letty@mrakoplas.phil.muni.cz>.
VERZE="1.2.5"

### Prefix nastavte, pokud chcete vytvorit strom jinam
###  nez do sve adresarove struktury
PREFIX=${PREFIX-""}

### Ze zdroju vyradte ty, ktere se vam nelibi
ZDROJECZ1="zemeplocha mladik pocitace skala prislovi"
ZDROJECZ2="stopar parafraze jerome wodehouse lodge mikulas"
ZDROJECZ3="cimrman ignac parkinson murphy josef guth"
ZDROJECZ4="citat klasik-cz market citace stoa1"
ZDROJESK="klasik-sk"
ZDROJE=${ZDROJE-"$ZDROJECZ1 $ZDROJECZ2 $ZDROJECZ3 $ZDROJECZ4 $ZDROJESK"}

### Dokumentace
DOC="README LICENSE HISTORIE fortune-cs.lsm"
DOCDIR=$PREFIX/${DOCDIR-"/usr/doc/fortune-cs-$VERZE"}

### Pozadujete-li koexistenci vice kodovych verzi, nastavte promennou KODOVANI
#KODOVANI=${KODOVANI-"il2 ascii pc2 1250 kam il1"}
KODZDROJE="il2"

### Kde je adresar s texty fortunes
FORTUNESDIR=$PREFIX/${FORTUNESDIR:-"/usr/share/games/fortunes"}
#FORTUNESDIR=$PREFIX/${FORTUNESDIR:-"/var/lib/games/fortunes"}

### Konec sekce s nastavovanim promennych
###
### Instalace

### Dokumentace
if [ -d $DOCDIR ] || mkdir -p $DOCDIR
then cp -f $DOC $DOCDIR
else 
 echo "Nelze vytvorit adresar $DOCDIR."
 exit 2
fi

### Pokud nemame cstocs, instalovat se muze jenom jedno kodovani
if [ "`type -path cstocs`" = "" ]
then
 KODOVANI=""
fi

### Instalace do adresare games/fortunes/cs
if [ -d $FORTUNESDIR/cs ] || mkdir -p $FORTUNESDIR/cs
then
 for SOUBOR in $ZDROJE
 do
  cp -f $SOUBOR $FORTUNESDIR/cs
  /usr/sbin/strfile -s $FORTUNESDIR/cs/$SOUBOR
 done
 else
  echo "Chyba pri vytvareni adresare $FORTUNESDIR."
  exit 3
fi

### Eventualni instalace vsech zdroju ve vsech vybranych kodovanich
for KOD in $KODOVANI
do
 if [ -d $FORTUNESDIR/cs-$KOD ] || mkdir -p $FORTUNESDIR/cs-$KOD 
 then
  for SOUBOR in $ZDROJE
  do
   # if touch $FORTUNESDIR/cs-$KOD/$SOUBOR 
   if cstocs $KODZDROJE $KOD $SOUBOR > $FORTUNESDIR/cs-$KOD/$SOUBOR 
   then
    strfile -s $FORTUNESDIR/cs-$KOD/$SOUBOR
   else
    echo "Nelze zapsat soubor $FORTUNESDIR/cs-$KOD/$SOUBOR."
    exit 4
   fi
  done
 else
  echo "Nelze vytvorit adresar $FORTUNESDIR/cs-$KOD."
  exit 5
 fi
done

### Zkouska: funguje to?
/usr/games/fortune $FORTUNESDIR/cs > /dev/null
exit $?

