#include "_savant_entity_elab.hh"
#include <iostream.h>
#include "SignalNetinfo.hh"
#include "SourceData.hh"
#include "SourceInfo.hh"
#include "VectorBase.hh"
#include "ScalarType.hh"
#include "RecordType.hh"
#include "ArrayType.hh"
#include "PortAssociation.hh"
#include "TypeConvert.hh"
#include "SourceTypeConvert.hh"

int _savant_entity_elab::resolutionFnIdCounter = 0;
int _savant_entity_elab::typeConversionFnIdCounter = 0;

ResolutionFnPtr *savantResolutionFn;
TypeConversionFnPtr *savantTypeConversionFn;

_savant_entity_elab::_savant_entity_elab() {
  opFanoutinfo = NULL;
}

_savant_entity_elab::~_savant_entity_elab() {
  int NoofDrivers, index;
  if(opFanoutinfo != NULL) {
    delete [] opFanoutinfo;
  }
  for ( NoofDrivers = 0 ; NoofDrivers < DriverData.getNumberOfElements(); NoofDrivers++){
    delete (VHDLType *)DriverData.getElement(NoofDrivers);
  }
  for ( index = 0; index < TypeConvertData.getNumberOfElements(); index++){
    delete (TypeConvert *)TypeConvertData.getElement(index);
  }
  
  for ( index = 0; index < BlockForDrivers.getNumberOfElements(); index++){
    delete (Block *)BlockForDrivers.getElement(index);
  }
  if ( savantTypeConversionFn != NULL ){
    delete [] savantTypeConversionFn;
    savantTypeConversionFn = NULL;
  }
}

void
_savant_entity_elab::instantiate() {
  cerr << "Dynamic Instantiation called for an unbounded component/entity/configuration" << endl;

}

void 
_savant_entity_elab::createNetInfo() {
  cerr << "Dynamic Elaboration called for an unbounded component/entity/configuration" << endl;

}

void
_savant_entity_elab::connect(int , int , ...) {
//This following line is to get rid of compilation warnings
// int NoofSignals = inputsignals + outputsignals;

  cerr << "Dynamic Elaboration called for an unbounded component/entity/configuration" << endl;

}


void
_savant_entity_elab::Add(VHDLType& val, VHDLType& rhs) {
  //Assumes val and rhs are of same types
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)(*(ScalarType*)&val).object)->Add((SignalNetinfo*)(*(ScalarType*)&rhs).object);
    break;
  case ARRAY_TYPE:
      Add((*(ArrayType*)&val).get_array(), (*(ArrayType*)&rhs).get_array());
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields; i++) {
      Add((*(RecordType*)&val).get_field(i), (*(RecordType*)&rhs).get_field(i));
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      Add((*(VectorBase*)&val).get_element(i), (*(VectorBase*)&rhs).get_element(i));
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

void
_savant_entity_elab::Add(VHDLType& val, SignalNetinfo& sig) {
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)(*(ScalarType*)&val).object)->Add(sig);
    break;
  case ARRAY_TYPE:
      Add((*(ArrayType*)&val).get_array(), sig);
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields ; i++) {
      Add((*(RecordType*)&val).get_field(i), sig);
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      Add((*(VectorBase*)&val).get_element(i), sig);
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

void
_savant_entity_elab::Add(VHDLType& val, int objid) {
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)(*(ScalarType*)&val).object)->Add(objid);
    break;
  case ARRAY_TYPE:
      Add((*(ArrayType*)&val).get_array(), objid);
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields ; i++) {
      Add((*(RecordType*)&val).get_field(i), objid);
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      Add((*(VectorBase*)&val).get_element(i), objid);
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}


void
_savant_entity_elab::Add(VHDLType& val, int objid, int sigid) {
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)(*(ScalarType*)&val).object)->Add(objid, sigid);
    break;
  case ARRAY_TYPE:
      Add((*(ArrayType*)&val).get_array(), objid, sigid);
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields ; i++) {
      Add((*(RecordType*)&val).get_field(i), objid, sigid);
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      Add((*(VectorBase*)&val).get_element(i), objid, sigid);
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}


void
_savant_entity_elab::Add(VHDLType& val, SignalNetinfo* ptr) {
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)(*(ScalarType*)&val).object)->Add(ptr);
    break;
  case ARRAY_TYPE:
      Add((*(ArrayType*)&val).get_array(), ptr);
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields ; i++) {
      Add((*(RecordType*)&val).get_field(i), ptr);
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      Add((*(VectorBase*)&val).get_element(i), ptr);
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

//When a ResolutionFunctionPtr is added to the global
// resolution function pointer table, the id at which this pointer is
//stored is returned
int
_savant_entity_elab::addResolutionFn(ResolutionFnPtr resolve) {
  ResolutionFnPtr* tempPtr = new ResolutionFnPtr[resolutionFnIdCounter + 1];
  register int i;
  register int resolutionFnId =0;
  register int found = 0;
  for(i = 0; i < resolutionFnIdCounter; i++) {
    if(savantResolutionFn[i] == resolve) {
      resolutionFnId = i;
      found = 1;
    }
    tempPtr[i] = savantResolutionFn[i];
  }
  if(found == 0) {
    tempPtr[resolutionFnIdCounter] = resolve;
    if(savantResolutionFn != NULL) {
      delete [] savantResolutionFn;
    }
    savantResolutionFn = tempPtr;
    resolutionFnIdCounter++;
  } else {
    delete [] tempPtr;
  }
  return resolutionFnId;
}

int
_savant_entity_elab::addTypeConversionFn(TypeConversionFnPtr upConvert) {
  TypeConversionFnPtr* tempPtr = new TypeConversionFnPtr[typeConversionFnIdCounter + 1];
  register int i;
  register int typeConversionFnId =0;
  register int found = 0;
  for(i = 0; i < typeConversionFnIdCounter; i++) {
    if(savantTypeConversionFn[i] == upConvert) {
      typeConversionFnId = i;
      found = 1;
    }
    tempPtr[i] = savantTypeConversionFn[i];
  }
  if(found == 0) {
    tempPtr[typeConversionFnIdCounter] = upConvert;
    typeConversionFnId = typeConversionFnIdCounter;
    if(savantTypeConversionFn != NULL) {
      delete [] savantTypeConversionFn;
    }
    savantTypeConversionFn = tempPtr;
    typeConversionFnIdCounter++;
  } else {
    delete [] tempPtr;
  }
  return typeConversionFnId;
}

// methods required for implementing resolution functions and type
// conversion functions in tyvis/savant

// This method sets the resolution function id of the source of this
// signal. 

void
_savant_entity_elab::setResolutionFunctionId(VHDLType& sigInfo,
					     ResolutionFnPtr resolve) {
  int resolutionFnId = addResolutionFn(resolve);

  //Set the resolution Function Id foa all the elements of the VHDLType
  //If the VHDLType is a composite type the, previously set functionId,
  //will be overwritten, if there is any. This is valid as per
  //Resoultion Functions section of the LRM
  sigInfo.setResolutionFunctionId(resolutionFnId);
}

// void 
// _savant_entity_elab::setResolutionFunctionId(ScalarType& sigInfo,
// 					     ResolutionFnPtr resolve) {
//   ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
//   int temp = resolutionFnIdCounter;
//   SourceBase *source = ((SignalNetinfo *) sigInfo.object)->source;
//   if(source == NULL) {
//     source = new SourceInfo;
//     ((SignalNetinfo *) sigInfo.object)->source = source;
//   } else if(source->get_kind() == SourceBase::SOURCE_DATA) {
//     SourceBase *temp_src = new SourceInfo;
//     temp_src->addChild(source);
//     source = temp_src;
//     ((SignalNetinfo *) sigInfo.object)->source = temp_src;
//   }
//   addResolutionFn(resolve);
//   if(resolutionFnIdCounter == temp+1) {	// Check if new fn is added.
//     source->setResolutionFnId(resolutionFnIdCounter-1);
//   }
// }

void
_savant_entity_elab::setUpConversionFunctionId(VHDLType& sigInfo,
					       TypeConversionFnPtr upConvert){
  int typeConversionFnId = addTypeConversionFn(upConvert);
  
  //Set the type conversion Function Id to all the elements of the VHDLType
  sigInfo.setTypeConversionFunctionId(typeConversionFnId);
}

// This method sets the up type conversion function id of the source of
// this signal.
// void 
// _savant_entity_elab::setUpConversionFunctionId(ScalarType& sigInfo,
// 					       TypeConversionFnPtr upConvert){
//   ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
//   SourceBase *source = ((SignalNetinfo *) sigInfo.object)->source;
//   if(source == NULL) {
//     source = new SourceInfo;
//     ((SignalNetinfo *) sigInfo.object)->source = source;
//   } else if(source->get_kind() == SourceBase::SOURCE_DATA) {
//     SourceBase *temp_src = new SourceInfo;
//     temp_src->addChild(source);
//     source = temp_src;
//     ((SignalNetinfo *) sigInfo.object)->source = temp_src;
//   }
//   savantTypeConversionFn[typeConversionFnIdCounter] = upConvert;
//   source->setUpTypeConversionFnId(typeConversionFnIdCounter++);
// }
  
// This method sets the down type conversion function id of the source of
// this signal.
void 
_savant_entity_elab::setDownConversionFunctionId(ScalarType& sigInfo, 
						 TypeConversionFnPtr downConvert){
  ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
  SourceBase *source = ((SignalNetinfo *) sigInfo.object)->source;
  if(source == NULL) {
    source = new SourceInfo;
  }
  savantTypeConversionFn[typeConversionFnIdCounter] = downConvert;
  source->setDownTypeConversionFnId(typeConversionFnIdCounter++);
}
  

// If the source of the corresponding SignalNetinfo is not initialized, we
// new a SourceData for it and assign the data to it.  If it is
// initialized and it has 0 children, then the source is a SourceData
// node.  Then, we "new" a SourceInfo node there, copy the contents of the
// old SourceData node as the new node's child, add the new child, and
// delete the old SourceData node.
// This is done so as to remove the burden from the elaboration code that
// is generated.

void 
_savant_entity_elab::addChild(SignalNetinfo* sigInfo, VHDLType *data, 
			      SourceId_t myId) {
  ASSERT(sigInfo->getKind() == ObjectBase::SIGNAL_NETINFO);

  if(sigInfo->source == NULL) {
    sigInfo->source = new SourceData;
    sigInfo->source->addChild(data, myId);
  } 
  else {
    switch(sigInfo->source->getNumChildren()) {
    case 0:
      SourceBase *temp;
      temp = sigInfo->source;
      switch(temp->get_kind()) {
      case SourceBase::SOURCE_DATA:
	if (myId == ANONYMOUS_PROCESS_ID) {
	  cerr << "Warning !! _savant_entity_elab::addChild() called with"
	       << "ANONYMOUS_PROCESS_ID but this is not the first guy to be"
	       << " added" << endl;
	  return;
	  // Anonymous drivers need to be recorded only if it is the first guy.
	  // If an real driver already exists then ignore all these guys.
	}
	else {
	  if (temp->_is_anonymous_driver() == true) {
	    data = sigInfo->source->getData();
	    sigInfo->source = new SourceData;
	    sigInfo->source->addChild(data, myId);
	  }
	  else {
	    sigInfo->source = new SourceInfo;
	    sigInfo->source->addChild(temp->getData(), temp->getSourceId());
	    sigInfo->source->addChild(data, myId);
	  }
	}
	delete temp;
	break;
	
      case SourceBase::SOURCE_INFO:
	sigInfo->source->addChild(data, myId);
	break;
      case SourceBase::SOURCE_BASE:
	cerr << "An object of SourceBase instantiated! I dunno how!!" << endl;
	abort();
	break;
      case SourceBase::SOURCE_TYPE_CONVERT:
	sigInfo->source->addChild(temp);
	sigInfo->source->addChild(data, myId);
      }	// switch(temp->get_kind())
      break;
    default:
      if (myId != ANONYMOUS_PROCESS_ID) {
	// Check if there is an anonymous driver already present in the tree
	// is so then delete that guy and add the new guy.
	if (sigInfo->source->getNumChildren() == 1) {
	  // Check if the first guy is an anonymous driver. If so pitch him
	  // after copying the default initial value.
	  ASSERT ( sigInfo->source->get_kind() == SourceBase::SOURCE_INFO );
	  SourceInfo* tempSourceInfo = (SourceInfo *) sigInfo->source;
	  if (tempSourceInfo->getChild(0)->_is_anonymous_driver() == true) {
	    ASSERT (tempSourceInfo->getChild(0)->get_kind() == 
		    SourceBase::SOURCE_DATA);
	    VHDLType* tempData = tempSourceInfo->getChild(0)->getData();
	    // tempSourceInfo->child = NULL;
	    delete tempSourceInfo;
	    sigInfo->source = new SourceInfo;
	    sigInfo->source->addChild(tempData, myId);
	  }
	  else {
	    (sigInfo)->source->addChild(data, myId);
	  }
	}
	else {
	  (sigInfo)->source->addChild(data, myId);	  
	}
      }
      break;
    } // switch
  } // else
}  

void 
_savant_entity_elab::addChild(VHDLType& sigInfo, VHDLType& data, 
			      SourceId_t myId) {
  int i;
  static int AddorNot = 0;

  // add the driver data in the block called DriverData and delete it in
  // destructor. So the VHDLType * data is not deleted in the SourceData
  // node.

  if ( AddorNot == 0 ){
    DriverData.addElement((void *)&data);
  }
  AddorNot++;
  
  switch(sigInfo.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if ((sigInfo.is_driver_already_set() == false) || (sigInfo.is_resolved_signal() == true))  {
      addChild((SignalNetinfo*)sigInfo.getObject(), &data, myId);
      if ( myId != ANONYMOUS_PROCESS_ID){
	((SignalNetinfo*) (sigInfo.getObject()))->set_driver_added_flag();
      }
    }
    break;
  case ARRAY_TYPE:
    if ((sigInfo.is_driver_already_set() == false) || (sigInfo.is_resolved_signal() == true)) {
      addChild((*(ArrayType*)&sigInfo).get_array(), (*(ArrayType*)&data).get_array(), myId);
    }
    break;
  case RECORD_TYPE:
    if ((sigInfo.is_driver_already_set() == false) || (sigInfo.is_resolved_signal() == true))  {
      for(i=1; i <= (*(RecordType*)&sigInfo).numberOfFields; i++) {
	addChild((*(RecordType*)&sigInfo).get_field(i), (*(RecordType*)&data).get_field(i), myId);      
      }
    }
    break;
  case VECTOR_BASE:
    if ((sigInfo.is_driver_already_set() == false) || (sigInfo.is_resolved_signal() == true)) {
      for(i=0; i<(*(VectorBase*)&sigInfo).numElems; i++) {
	addChild((*(VectorBase*)&sigInfo).get_element(i), (*(VectorBase*)&data).get_element(i), myId);            
      }
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }

  //subtract 1 from AddorNot so when it is zero alone, we add it to the
  // data structure DriversData which will be deleted in the destructor.
  AddorNot--;
}

void 
_savant_entity_elab::addChild(VHDLType& sigInfo, VHDLType& data) {
  int i;
  switch(sigInfo.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    addChild((SignalNetinfo*)sigInfo.getObject(), (SignalNetinfo*)data.getObject());
    ((SignalNetinfo*)data.getObject())->set_sourcebase_delete_flag(false);
    break;
  case ARRAY_TYPE:
    addChild((*(ArrayType*)&sigInfo).get_array(), (*(ArrayType*)&data).get_array());
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&sigInfo).numberOfFields; i++) {
      addChild((*(RecordType*)&sigInfo).get_field(i), (*(RecordType*)&data).get_field(i));      
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&sigInfo).numElems; i++) {
      addChild((*(VectorBase*)&sigInfo).get_element(i), (*(VectorBase*)&data).get_element(i));            
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

void 
_savant_entity_elab::addChild(SignalNetinfo* sigInfo, SignalNetinfo* driverInfo) {
  ASSERT(sigInfo->getKind() == ObjectBase::SIGNAL_NETINFO);
  ASSERT(driverInfo->getKind() == ObjectBase::SIGNAL_NETINFO);
  // If the driverInfo does not have any driver for this signal, we have
  // nothing to do here.
  if(driverInfo->source == NULL) {
    return;			// SK
  }
  if(sigInfo->source == NULL) {
    // this coud be just sigInfo->source = driverInfo->source, but why this way
    sigInfo->source = new SourceInfo;
    sigInfo->source->addChild(driverInfo->source);
  } else if((sigInfo->source->get_kind() == SourceBase::SOURCE_DATA) || (sigInfo->source->get_kind() == SourceBase::SOURCE_TYPE_CONVERT) ) {// SK Beg`
    if ( sigInfo->source->get_kind() == SourceBase::SOURCE_TYPE_CONVERT){
      SourceBase *temp_src = sigInfo->source;
      sigInfo->source = new SourceInfo;
      sigInfo->source->addChild(temp_src);
      sigInfo->source->addChild(driverInfo->source);
    } else {
      if ( sigInfo->source->_is_anonymous_driver() == false ){
	SourceBase *temp_src = sigInfo->source;
	sigInfo->source = new SourceInfo;
	sigInfo->source->addChild(temp_src);
	sigInfo->source->addChild(driverInfo->source);
      } else {
	sigInfo->source = new SourceInfo;
	sigInfo->source->addChild(driverInfo->source);
      }
    }
  } else {
    sigInfo->source->addChild(driverInfo->source);
  }    
}  

// Move the source pointer to point to the root of the source tree.  This
// required since the resolution has to start from the root of the source
// tree.
void 
_savant_entity_elab::setSourceToRoot(ScalarType& sigInfo) {
  ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
  SourceBase *sigsrc = ((SignalNetinfo *) sigInfo.object)->source;
  while(sigsrc->getParent() != NULL) {
    sigsrc = sigsrc->getParent();
  }
  ((SignalNetinfo *) sigInfo.object)->source = sigsrc;
}


void
_savant_entity_elab::setSourceInfo(VHDLType& val, VHDLType& rhs) {
  //Assumes val and rhs are of same types
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if ( (((SignalNetinfo *) val.getObject())->source != NULL) &&
	 (((SignalNetinfo *) val.getObject())->get_sourcebase_delete_flag()
	  == true)) {
      // delete ((SignalNetinfo *) val.getObject())->source;
    }
    ((SignalNetinfo*)val.getObject())->source = ((SignalNetinfo*)rhs.getObject())->source;
    ((SignalNetinfo*)val.getObject())->set_sourcebase_delete_flag(false);
    ((SignalNetinfo*)val.getObject())->addAdditionalDriver(((SignalNetinfo*)rhs.getObject())->getAdditionalDriverList());
    break;
  case ARRAY_TYPE:
      setSourceInfo((*(ArrayType*)&val).get_array(), (*(ArrayType*)&rhs).get_array());
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields; i++) {
      setSourceInfo((*(RecordType*)&val).get_field(i), (*(RecordType*)&rhs).get_field(i));
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      setSourceInfo((*(VectorBase*)&val).get_element(i), (*(VectorBase*)&rhs).get_element(i));
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

Block*
_savant_entity_elab::getDownTypeConversionFnList(VHDLType &signal)
{
  switch (signal.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT( signal.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
    return &(((SignalNetinfo *) signal.getObject())->downTypeConversionFnList);
    break;

  case ARRAY_TYPE:
    return getDownTypeConversionFnList(signal.get_element(0));
    break;
    
  case RECORD_TYPE:
    return getDownTypeConversionFnList(((RecordType &) signal).get_field(1));
    break;

  default:
    cerr << "Error : _savant_entity_elb::getDownTypeConversionFnList() - "
	 << "unknown type passed." << endl;
  }

  return NULL; // Keep compiler from wailing
}

void
_savant_entity_elab::addDownTypeConversionFn(VHDLType& lhs, VHDLType& rhs, TypeConversionFnPtr typeConversionFn) {
  
  Block *rhsDownTypeConversionFnList;
  int   *newFnId;
  int i;
  ASSERT( lhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
  ASSERT( rhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );

 
  rhsDownTypeConversionFnList = getDownTypeConversionFnList(rhs);

  switch (lhs.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    for(i = 0; (i < rhsDownTypeConversionFnList->getNumberOfElements()); i++) {
      ASSERT( lhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
      
      ((SignalNetinfo *) lhs.getObject())->downTypeConversionFnList.addElement(rhsDownTypeConversionFnList->getElement(i));
    }
    
    newFnId = new int;
    *newFnId = addTypeConversionFn(typeConversionFn);
    
    ((SignalNetinfo *) lhs.getObject())->downTypeConversionFnList.addElement(newFnId);
    
    break;
  
  case ARRAY_TYPE:
    for(i = 0; (i < lhs.get_number_of_elements()); i++) {
      addDownTypeConversionFn(lhs.get_element(i), rhs, typeConversionFn);
    }
    break;

  case RECORD_TYPE:
    for(i = 1; (i <= lhs.get_number_of_elements()); i++) {
      addDownTypeConversionFn(((RecordType &) lhs).get_field(i), rhs, typeConversionFn);
    }
    break;

  default:
    cerr << "Error : _savant_entity_elab::addDownTypeConversionFn() - "
	 << "unknown vhdl type." << endl;
  }
}

void 
_savant_entity_elab::getBoundEntityInfo() {
  int i=0;
  int numberOfPortElements = this->portMapAspect.portAssociationList.getNumberOfElements();
  Block* portList = &(this->portMapAspect.portAssociationList);
  for(i=0; i < numberOfPortElements; i++) {
    PortAssociation* portElement = (PortAssociation*)portList->getElement(i);
    switch(portElement->mode) {
    case IN:
      Add(*portElement->formalPort, *portElement->actualPort);
      break;
    case OUT:
      Add(*portElement->formalPort, *portElement->actualPort);
      addChild(*portElement->formalPort, *portElement->actualPort);
      break;
    case INOUT:
      Add(*portElement->formalPort, *portElement->actualPort);
      addChild(*portElement->formalPort, *portElement->actualPort);
      break;
    case BUFFER:
    case LINKAGE:
      cerr << "Port declarations of mode IBUFFFER and LINKAGE" << endl
	   << "Not Yet Supported" << endl;
      break;
    }
  }
}

void
_savant_entity_elab::collectFanout(SignalNetinfo* sigNetInfo,VHDLType& val){
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    sigNetInfo->Add((SignalNetinfo*)(*(ScalarType*)&val).object);
    break;
  case ARRAY_TYPE:
    collectFanout(sigNetInfo,(*(ArrayType*)&val).get_array()); 
    break;
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).numberOfFields ; i++) {
      collectFanout(sigNetInfo,(*(RecordType*)&val).get_field(i));
    }
    break;
  case VECTOR_BASE:
    for(i=0; i<(*(VectorBase*)&val).numElems; i++) {
      collectFanout(sigNetInfo, (*(VectorBase*)&val).get_element(i));
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

void
_savant_entity_elab::Addall(VHDLType& dest, VHDLType& src) {
  SignalNetinfo tmp;
  collectFanout(&tmp, src);
  Add(dest, &tmp);
}

void
_savant_entity_elab::addUpConvertDriver(VHDLType &sigInfo, VHDLType &data, TypeConvert *typeConvertPtr){
  
  int index;
  static int AddorNot = 0;

  if ( AddorNot == 0 ){
    TypeConvertData.addElement(typeConvertPtr);
  }
  AddorNot++;
  
  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    addUpConvertDriver((SignalNetinfo *)sigInfo.getObject(), &data, typeConvertPtr);
    break;
  case ARRAY_TYPE:
    addUpConvertDriver(((ArrayType *)&sigInfo)->get_array(), ((ArrayType *)&data)->get_array(), typeConvertPtr);
    break;
  case RECORD_TYPE:
    for(index=1; index <= ((RecordType *)&sigInfo)->numberOfFields; index++){
      addUpConvertDriver(((RecordType*)&sigInfo)->get_field(index), ((RecordType *)&data)->get_field(index), typeConvertPtr);
    }
    break;
  case VECTOR_BASE:
    for(index=0; index < ((VectorBase *)&sigInfo)->get_number_of_elements(); index++){
      addUpConvertDriver(((VectorBase *)&sigInfo)->get_element(index), ((VectorBase *)&data)->get_element(index), typeConvertPtr);
    }
    break;
  default:
    cerr << "Wrong Type Passed" << endl;
    break;
  }
  AddorNot--;
}

// This method does the setup for the TypeConversion to be done during the
// runtime. It just holds the poniters to various temporary and permanent
// information needed during the TypeConversion.
void
_savant_entity_elab::addUpConvertDriver(SignalNetinfo *sigInfo, VHDLType *data, TypeConvert *typeConvertPtr){
  SourceTypeConvert *tmp_stc = NULL;
  
  ASSERT(sigInfo->getKind() == ObjectBase::SIGNAL_NETINFO);
  //  ASSERT(sigInfo->source == NULL);
  // since this is a temporary signal netinfo created in the elaboration class
  // the source pointer is always should be NULL. If this assert is wrong,
  // please feel free to take it away.

  tmp_stc = new SourceTypeConvert ;
  tmp_stc->setData(data);
  tmp_stc->setTypeConvert(typeConvertPtr);
  if ( sigInfo->source == NULL ){
    sigInfo->source = tmp_stc;
  } else {
    sigInfo->source->addChild(tmp_stc);
  }
}

// adds the driverInfo to the block existing in the SignalNetinfo class.
// first checks whether atleast one does not have additionalDriverList. If so
// it new's a Block and adds this driverInfo passes it to the subelements other
// wise, it just passes the driverInfo so that it can be added to the already
// existing block in the SignalNetinfo object.
void
_savant_entity_elab::addDriver(VHDLType &sigInfo, VHDLType &driverInfo){

  Block *newDriverList = NULL;
  static int call_block_present = 0;
  int i;

  if ( call_block_present == 0){
    if ( _is_block_present(sigInfo) == false ) {
      newDriverList = new Block;
      BlockForDrivers.addElement((void *)newDriverList);
      newDriverList->addElement(&driverInfo);
    }
  }

  call_block_present++;

  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    if ( newDriverList != NULL ){
      ((SignalNetinfo *)sigInfo.getObject())->setAdditionalDriverList(newDriverList);
    } else {
      ((SignalNetinfo *)sigInfo.getObject())->addAdditionalDriver(&driverInfo);
    }
    break;
  case ARRAY_TYPE:
    if ( newDriverList == NULL ){
      addDriver(((ArrayType *)&sigInfo)->get_array(), driverInfo);
    } else {
      addDriver(((ArrayType *)&sigInfo)->get_array(), newDriverList);
    }
    break;
  case RECORD_TYPE:
    if ( newDriverList == NULL ){
      for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((RecordType *)&sigInfo)->get_field(i), driverInfo);
      }
    } else {
      for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((RecordType *)&sigInfo)->get_field(i), newDriverList);
      }
    }
    break;
  case VECTOR_BASE:
    if ( newDriverList == NULL ){
      for ( i = 0 ; i < ((VectorBase *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((VectorBase *)&sigInfo)->get_element(i), driverInfo);
      }
    } else {
      for ( i = 0 ; i < ((VectorBase *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((VectorBase *)&sigInfo)->get_element(i), newDriverList);
      }
    }
    break;
  default:
    cerr << "_savant_entity_elab::addDriver  Wrong Type Passed" << endl;
    break;
  }

  call_block_present--;
}

void
_savant_entity_elab::addDriver(VHDLType &sigInfo, Block *newDriverList){
  int i;
  
  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    ((SignalNetinfo *)sigInfo.getObject())->setAdditionalDriverList(newDriverList);
    break;
  case ARRAY_TYPE:
    addDriver(((ArrayType *)&sigInfo)->get_array(), newDriverList);
    break;
  case RECORD_TYPE:
    for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
      addDriver(((RecordType *)&sigInfo)->get_field(i), newDriverList);
    }
    break;
  case VECTOR_BASE:
    for ( i = 0 ; i < ((VectorBase *)&sigInfo)->get_number_of_elements(); i++){
      addDriver(((VectorBase *)&sigInfo)->get_element(i), newDriverList);
    }
    break;
  default:
    cerr << "_savant_entity_elab::addDriver wrong type passed "<< endl;
    break;
  }
}


// We are having a data structure of type Block to hold the pointers of the
// temporary signals which occur in the Type Conversion. This routine
// will return TRUE if the element already has the Block allocated for that
// element if it is a ScalarType. If it is a Composite Type, then it will
// return TRUE only if all the sub elements of the Composite Type have the
// Block already allocated. Even if one of the elements of the Composite Type
// does not have a Block allocated, it will return FALSE

bool
_savant_entity_elab::_is_block_present(VHDLType &sigInfo){
  int i ;

  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    if ( ((SignalNetinfo *)sigInfo.getObject())->getAdditionalDriverList() == NULL ){
      return false;
    } else {
      return true;
    }
    break;
  case ARRAY_TYPE:
    return _is_block_present(((ArrayType *)&sigInfo)->get_array());
    break;
  case RECORD_TYPE:
    for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
      if ( _is_block_present(((RecordType *)&sigInfo)->get_field(i)) == false ){
	return false ;
      }
    }
    return true;
    break;
  case VECTOR_BASE:
    for ( i = 0 ; i < ((VectorBase *)&sigInfo)->get_number_of_elements(); i++){
      if ( _is_block_present(((VectorBase *)&sigInfo)->get_element(i)) == false ){
	return false;
      }
    }
    return true;
    break;
  default:
    cerr << "_savant_entity_elab::_is_block_present  Wrong Type Passed" << endl;
    // Just to keep compiler from giving warnings.
    return true;
    break;
  }
}


// Whenever a component is declared we create a class _savant_component and
// we have the signals in the port. When it is actually bounded to the real
// entity architecture, the signals inside the _savant_component are having
// different Signal ID's which are initialized in the SignalNetinfo node.
// This was a hurdle to the TypeConversion. It was found that there is no
// harm in signals inside the _savant_component having the same Signal ID's as
// the Signal ID's of the entity architecture to which it is bound to during
// instantiation or component configuration. This method in fact gets the
// signal ID's from the entity architecture and assigns to the corresponding
// signals in the _savant_component.

void
_savant_entity_elab::copyId(VHDLType &dest, VHDLType &src){
  int i;

  if ((dest.get_kind() == ARRAY_TYPE) &&
      (((ArrayType &) dest).object == NULL)){
    ((ArrayType &) dest).object = (VectorBase *) src.getObject()->clone();
  }
  
  ASSERT(dest.getKind() == ObjectBase::SIGNAL_NETINFO);
  ASSERT(src.getKind() == ObjectBase::SIGNAL_NETINFO);

  switch (dest.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(dest.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    ASSERT(src.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    ((SignalNetinfo *)dest.getObject())->id = ((SignalNetinfo *)src.getObject())->id;
    break;
  case ARRAY_TYPE:
    copyId(((ArrayType &)dest).get_array(), ((ArrayType &)src).get_array());
    break;
  case RECORD_TYPE:
    for ( i = 1 ; i <= ((RecordType *)&dest)->get_number_of_elements(); i++){
      copyId(((RecordType &)dest).get_field(i), ((RecordType &)src).get_field(i));
    }
    break;
  case VECTOR_BASE:
    for ( i = 0 ; i < ((VectorBase *)&dest)->get_number_of_elements(); i++){
      copyId(((VectorBase &)dest).get_element(i), ((VectorBase &)src).get_element(i));
    }
    break;
  default:
    cerr << "_savant_entity_elab::copyId  Wrong Type Passed" << endl;
    // Just to keep compiler from giving warnings.
    break;
  }
}

void
_savant_entity_elab::addDriverData(VHDLType *data){
  DriverData.addElement((void*)data);
}

// The following two function check to ensure that the types of the signals
// being passed to the actual setSourceInfo() method are of the same type.
// Different types of signals can arise if sub-elements in composite signals
// are assigned thro' the port maps. Here is a quick example
//
// component comp port (i : bit_vector(0 to 2)); end component;
// comp_inst : comp port map (i(0) => bit0; i(1) => bit1; i(2) => bit2);
//
// In this case 3 signals will be passed in connect. Now, these signals need
// to be combined into a bit_vector and then passed to the actual methods

int
_savant_entity_elab::checkSetSourceInfo(VHDLType &dest, int srcStart, VHDLType **src) {
  // Check if source and destination have the same number of elements in them
  // If they do well and good. If they don't then create a new sig_netinfo
  // and use as many parameters as necessary and return the number of the
  // next parameter to use back to the calling process.

  ASSERT ( dest.get_number_of_elements() > 0 );
  ASSERT ( src[srcStart]->get_number_of_elements() > 0 );
  
  if (dest.get_number_of_elements() == src[srcStart]->get_number_of_elements()) {
    setSourceInfo(dest, (VHDLType &) (*src[srcStart]));
    
    return (srcStart + 1);
  }

  if (dest.get_number_of_elements() > src[srcStart]->get_number_of_elements()) {
    VHDLType *newType   = dest.clone();
    int elements_copied_so_far = 0;

    while (elements_copied_so_far < dest.get_number_of_elements()) {
      newType->get_element(elements_copied_so_far) = *(src[srcStart]);
      elements_copied_so_far += src[srcStart]->get_number_of_elements();
      srcStart++;
    }

    setSourceInfo(dest, *newType);
    delete newType;
  }
  else {
    cerr << "Error : Unhandled case in checkSetSourceInfo()\n";
  }
  
  return srcStart;
}

int
_savant_entity_elab::checkAdd(VHDLType &dest, int srcStart, VHDLType **src) {
  // Check if source and destination have the same number of elements in them
  // If they do well and good. If they don't then create a new sig_netinfo
  // and use as many parameters as necessary and return the number of the
  // next parameter to use back to the calling process.

  ASSERT ( dest.get_number_of_elements() > 0 );
  ASSERT ( src[srcStart]->get_number_of_elements() > 0 );
  
  if (dest.get_number_of_elements() == src[srcStart]->get_number_of_elements()) {
    Add(dest, (VHDLType &) (*src[srcStart]));

    return (srcStart + 1);
  }
  
  if (dest.get_number_of_elements() > src[srcStart]->get_number_of_elements()) {
    VHDLType *newType   = dest.clone();
    int elements_copied_so_far = 0;
    
    while (elements_copied_so_far < dest.get_number_of_elements()) {
      newType->get_element(elements_copied_so_far) = *(src[srcStart]);
      elements_copied_so_far += src[srcStart]->get_number_of_elements();
      srcStart++;
    }
    
    Add(dest, (VHDLType &) *newType);
    delete newType;
  }
  else {
    cerr << "Error : Unhandled case in checkSetSourceInfo()\n";
  }

  return srcStart;
}

