#ifndef VHDLTYPE_HH
#define VHDLTYPE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "TypeKind.hh"
#include "TypeInfo.hh"
#include "STDTypes.hh"
#include "ObjectBase.hh"
#include "Types.hh"

class VTime;
template <class Type> class Variable;
template<class Type> class AccessVariable;
class VectorBase;
class ScalarType;
class EnumerationType;
class SavantlineType;
class VHDLKernelBase;
class SignalBase;

class VHDLType {
public:
  
  VHDLType(bool alias = false): is_alias(alias){};

  virtual ~VHDLType() {};

  virtual void print(ostream& = cout) const = 0;
  virtual VHDLType& operator=(const VHDLType&);
  virtual VHDLType& assignVal(const VHDLType&);

  virtual bool operator==(const VHDLType&) const = 0;

  virtual VHDLType& operator[](const int) const;
  // virtual VHDLType& operator[](const ScalarType&) const;

  virtual void setRange(ObjectBase::ObjectType, ArrayInfo*, int, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  void setRange(ObjectBase::ObjectType, VectorBase*);

// Note: The method "get_kind()" MUST NOT be overloaded by a derived type.
// This is to ensure that the type is recognized correctly.  It must be
// overloaded ONLY by the kernel types viz. "ScalarType", "ArrayType",
// "RecordType" and "VectorBase".
  virtual Type get_kind() const;
  virtual bool is_scalar_type() const { return false; }


  virtual int get_number_of_elements() const;
  virtual VHDLType& get_element(const int ) const;
  virtual ObjectBase* getObject() const = 0;
  virtual ArrayInfo* get_bounds() const;
  virtual ObjectBase::ObjectType getKind() const = 0;

  virtual VHDLType* clone() const = 0;
  virtual const VHDLData& leftValue();
  //Remember to delete the return char* in the place where it is used.
  virtual char* getString() const;
  virtual int left() const;
  virtual int right() const;
  virtual ArrayDirn_t dirn() const;
  virtual int length() const;

  virtual int savantwrite(AccessVariable<char*> &) const;
  virtual int savantwrite(SavantlineType &) const;
  virtual int savantread(AccessVariable <char*> &);
  virtual int savantread(SavantlineType &);

  //The TYPE's resolve is called only for composite resolved signals
  //This resolve goes down to first sub-element of the VHDLType and
  //calls the sub-elements resolve, but which actually does the resolution
  //for the whole composite type
  virtual VHDLType* resolve(VHDLKernelBase*);

  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);
  virtual void updateEffVal(const VHDLType*);
  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  virtual void setElaborationInfo(const VHDLType &);
  virtual void setNumAttributes(int);
  virtual void setAttrib(AttribType, VHDLType&);
  virtual void initializeImplicitSignal(AttribType);
  virtual bool is_driver_already_set() const;
  virtual bool is_resolved_signal() const;
  virtual bool _is_composite_resolved_type() const;
  
  virtual bool _is_signal() const { return false; }
  virtual SignalBase* locateSig(int sigId);
  virtual SignalBase* findSigInBlock(int sigId,int srcId);
  virtual void set_sourcebase_delete_flag(bool)const;
  virtual VHDLType *getParentCompositeType();

  virtual void resolveAndUpdate(VHDLKernelBase *);
  virtual void setBusKind();
  virtual void dump_connectivity_info(ofstream&);
  virtual TypeInfo& getTypeInfo() const;
  
public:
  bool is_alias;
};

extern "C" bool eatwhite(AccessVariable<char*>& line);
extern void assignVariable(VHDLType& dest, const VHDLType& src, 
			   const ArrayInfo& dinfo, const ArrayInfo& sinfo);

EnumerationType savantEqual(const VHDLType&, const VHDLType&);
EnumerationType savantNotEqual(const VHDLType&, const VHDLType&);
EnumerationType savantLessThan(const VHDLType&, const VHDLType&);
EnumerationType savantGreaterThan(const VHDLType&, const VHDLType&);
EnumerationType savantLessThanOrEqual(const VHDLType &, const VHDLType&);

#endif
