#include "TypeConvert.hh"
#include "_savant_entity_elab.hh"
#include "SourceBase.hh"
#include "SourceInfo.hh"

TypeConvert::TypeConvert() {
  upperSignalnetInfo = NULL;
  upperDriver = NULL;
  lowerSignal = NULL;
  conversionFunctionId = -1;
  sourceBaseDeleteFlag = false;
}

TypeConvert::~TypeConvert() {

  if ( sourceBaseDeleteFlag == false ){
    upperSignalnetInfo->set_sourcebase_delete_flag(false);
  }
  
  delete upperSignalnetInfo;
  delete upperDriver;
  delete lowerSignal;
}

VHDLType*
TypeConvert::resolve(VHDLKernelBase* processPtr) {
  VHDLType* retval = lowerSignal->resolve(processPtr);
  VHDLType* typeconvertvalue = NULL;

  // We need to manually update the signal with the resolved value if the
  // type is a composite resolved type. If the composite type is not a
  // composite resolved type, then we update its value in the scalar type
  // itself
  
  if ( lowerSignal->_is_composite_resolved_type() ){
    assignVariable(*lowerSignal, *retval, nullInfo, nullInfo);
  }

  typeconvertvalue = (savantTypeConversionFn[conversionFunctionId](processPtr, lowerSignal));
  assignVariable(*upperDriver, *typeconvertvalue, nullInfo, nullInfo);

  delete typeconvertvalue;
  return upperDriver;
}
