#include "SignalNetinfo.hh"
#include "SourceInfo.hh"
#include "SourceData.hh"
#include "bool.hh"
#include <iostream.h>
#include <new.h>

SignalNetinfo::SignalNetinfo() {
  id = globalSignalId++;
  fanout = 0;
  obj_ids = NULL;
  source = NULL;
  driver_added_flag = false;
  downTypeConversionFnList.reset();
  sourcebase_delete_flag = true ;
  additionalDriverList = NULL;
  additionalDriverListDeleteFlag = true;
}

SignalNetinfo::~SignalNetinfo() {
  if ((get_sourcebase_delete_flag() == true) && (source != NULL)) {
    delete source ;
    source = NULL;
  }
  if ( additionalDriverListDeleteFlag == true ){
    delete additionalDriverList;
  }

  if (obj_ids != NULL) {
    delete [] obj_ids;
    obj_ids = NULL;
  }
}

SignalNetinfo::SignalNetinfo(SignalNetinfo* ptr) {
  id = ptr->id;
  fanout = 0;
  this->Add(*ptr);
  source = ptr->source;
  driver_added_flag = false;
  sourcebase_delete_flag = true;
  // copy the additionalDriverList also
  cerr << "SignalNetinfo::SignalNetinfo(SignalNetinfo *) -> Warning constructor taking SignalNetinfo * is copying also the additionalDriverList;" << endl;
  if ( ptr->getAdditionalDriverList() != NULL ){
    additionalDriverList = new Block();
    *additionalDriverList = *(ptr->getAdditionalDriverList());
  }
}

SignalNetinfo&
SignalNetinfo::Add(SignalNetinfo* ptr) {
  return this->Add(*ptr);
}

SignalNetinfo&
SignalNetinfo::Add(SignalNetinfo& sig) {
  if(fanout == 0) {
    if ( sig.fanout != 0 ){
      fanout = sig.fanout;
      obj_ids = new FanDest_t[fanout];
      for(int i=0; i<fanout; i++) {
	obj_ids[i] = sig.obj_ids[i];
      }
    } else {
      fanout = 0; obj_ids = NULL;
    }
  }
  else {
    //Temporarily inefficient implementation
    for(int i = 0; i <sig.fanout; i++) {
      this->Add(sig.obj_ids[i].objid, sig.obj_ids[i].sigid);
    }

    //    int oldfanout = fanout;
    //    fanout += sig.fanout;
    //    FanDest_t* ptr = new FanDest_t[fanout];
    //    for(int i=0; i< oldfanout; i++) {
    //      ptr[i] = obj_ids[i];
    //    }
    //    for(int i=oldfanout, j=0; i<fanout; i++) {
    //      ptr[i] = sig.obj_ids[j++];
    //    }
    //    FanDest_t *tmp = obj_ids;
    //    obj_ids = ptr;
    //    delete []tmp;
  }
  return *this;
}

SignalNetinfo&
SignalNetinfo::Add(int objid) {
  if(fanout == 0) {
    fanout = 1;
    obj_ids = new FanDest_t[1];
    obj_ids[0] = FanDest_t(objid, id);
  }
  else {
    //Check here for the destination already in the list
    int present = 0;
    for(int j =0; j< fanout; j++) {
      if(obj_ids[j].objid == objid) {
	present = 1;
	break;
      }
    }
    if(present == 0) {
      int oldfanout = fanout;
      fanout++;
      FanDest_t* ptr = new FanDest_t[fanout];
      for(int i=0; i< oldfanout; i++) {
	ptr[i] = obj_ids[i];
      }
      new(&ptr[oldfanout]) FanDest_t(objid, id);
      FanDest_t* tmp = obj_ids;
      obj_ids = ptr;
      delete [] tmp;
    }
  }
  return *this;
}

SignalNetinfo&
SignalNetinfo::Add(int objid, int  sigid) {
  if(fanout == 0) {
    fanout = 1;
    obj_ids = new FanDest_t[1];
    obj_ids[0] = FanDest_t(objid, sigid);
  }
  else {
    //Check here for the destination process id and the signal id already in the list
    int present = 0;
    for(int j =0; j< fanout; j++) {
      if(obj_ids[j].objid == objid && obj_ids[j].sigid == sigid ) {
	present = 1;
	break;
      }
    }
    if(present == 0) {
      int oldfanout = fanout;
      fanout++;
      FanDest_t* ptr = new FanDest_t[fanout];
      for(int i=0; i< oldfanout; i++) {
	ptr[i] = obj_ids[i];
      }
      ptr[oldfanout] = FanDest_t(objid, sigid);
      FanDest_t *tmp = obj_ids;
      obj_ids = ptr;
      delete [] tmp;
    }
  }
  return *this;
}

void 
SignalNetinfo::setResolutionFunctionId(int resolutionFnId) {
  if(this->source == NULL) {
    source = new SourceInfo;
  }
  else if(this->source->get_kind() == SourceBase::SOURCE_DATA) {
    SourceBase *temp_src = new SourceInfo;
    temp_src->addChild(this->source);
    this->source = temp_src;
  }
  this->source->setResolutionFnId(resolutionFnId);
}

void 
SignalNetinfo::setTypeConversionFunctionId(int typeConversionFnId) {
  if(this->source == NULL) {
    source = new SourceInfo;
  }
  else if(this->source->get_kind() == SourceBase::SOURCE_DATA) {
    SourceBase *temp_src = new SourceInfo;
    temp_src->addChild(this->source);
    this->source = temp_src;
  }
  this->source->setUpTypeConversionFnId(typeConversionFnId);
}

void 
SignalNetinfo::print(ostream& os) const {
  os << "info id  " << id << "\n";
  os << "fanout is " << fanout << endl;
  for(int i=0; i<fanout; i++) {
    os << "objid is " << obj_ids[i].objid << endl;
    os << "sigid is " <<obj_ids[i].sigid << endl;
  }
  os << endl;
}

bool 
SignalNetinfo::_is_signal() const {
  cerr << "ERROR: _is_signal() called from SignalNetinfo." << endl;
  abort();
  return false;		// Just to keep CC from shouting.
}

const VHDLData& 
SignalNetinfo::readVal() const {
  cerr << "ERROR: SignalNetinfo::readVal called." << endl;
  abort();
  return *(new UniversalBoolean(false)); // Just to keep CC from shouting.
}

void
SignalNetinfo::updateVal(const VHDLData&) {
  cerr << "ERROR: SignalNetinfo::updateVal called." << endl;
  abort();
}

ObjectBase& 
SignalNetinfo::operator=(const ObjectBase& s) {
  return operator=((const SignalNetinfo &) s);
}

ObjectBase&
SignalNetinfo::operator=(const SignalNetinfo &s) {
  id      = s.id;
  fanout  = s.fanout;
  if (obj_ids != NULL) {
    delete []obj_ids ;
  }
  obj_ids = new FanDest_t[fanout];
  for(int i = 0; (i < fanout); i++) {
    obj_ids[i] = s.obj_ids[i];
  }
  
  source  = s.source;
  sourcebase_delete_flag = false;
  
  if (((SignalNetinfo &)s).getAdditionalDriverList() != NULL) {
    if ((additionalDriverList != NULL) && (additionalDriverListDeleteFlag == true)) {
      delete additionalDriverList;
    }
    additionalDriverList = new Block;
    *additionalDriverList = *((SignalNetinfo &)s).getAdditionalDriverList();
  }
  else {
    additionalDriverList = NULL;
  }
  
  return (*this);
}

ObjectBase* 
SignalNetinfo::clone() const {
  SignalNetinfo *retval = new SignalNetinfo;
  *retval = *this;
  retval->set_sourcebase_delete_flag(false);
  cout << "retval = " << retval << endl;
  return retval;
}

int SignalNetinfo::globalSignalId = 0;

void
SignalNetinfo::set_driver_added_flag()
{
  driver_added_flag = true;
}

void
SignalNetinfo::set_driver_added_flag(const bool newValue)
{
  driver_added_flag = newValue;
}

bool
SignalNetinfo::get_driver_added_flag() const
{
  return driver_added_flag;
}

bool
SignalNetinfo::get_sourcebase_delete_flag() const {
  return sourcebase_delete_flag ;
}

void
SignalNetinfo::set_sourcebase_delete_flag(const bool NewValue){
  sourcebase_delete_flag = NewValue;
}

void
SignalNetinfo::setAdditionalDriverList(Block *newDriverList){
  if ( additionalDriverList == NULL ){
    additionalDriverList = newDriverList;
    additionalDriverListDeleteFlag = false;
  } else {
    int index ;
    for ( index = 0 ; index < newDriverList->getNumberOfElements() ; index++){
      additionalDriverList->addElement(newDriverList->getElement(index));
    }
  }
}

Block *
SignalNetinfo::getAdditionalDriverList(){
  return additionalDriverList;
}

void
SignalNetinfo::addAdditionalDriver(VHDLType *driver){
  ASSERT(additionalDriverList != NULL);
  additionalDriverList->addElement(driver);
}

void
SignalNetinfo::addAdditionalDriver(Block *newDriverList){
  int index;

  if ( newDriverList == NULL ){
    //nothing to be done here in this case
  } else {
    // if the block additionalDriverList is not already existing, new a block
    if ( additionalDriverList == NULL ){
      additionalDriverList = new Block;
    }
    for ( index = 0 ; index < newDriverList->getNumberOfElements(); index++){
      additionalDriverList->addElement(newDriverList->getElement(index));
    }
  }
}

void
SignalNetinfo::dump_connectivity_info(ofstream& out) {
  out << "Signal id: " << id << endl;
  out << "Signal fanout: " << fanout << endl;
  out << "Fanout dest:   " << endl;
  for (int i = 0; i < fanout; i++) {
    out << obj_ids[i];
    out << endl;
  }
}

void
SignalNetinfo::dump_driver_data(ofstream& out) {
  if (source != NULL) {
    out << "Driver Information:";
    out << ((SourceData*)source->getDriveratIndex(0))->getSourceId();
    out << endl;
  }
}
