#include "Block.hh"
#include <iostream.h>

Block::Block(int blkFactor) {
  blockFactor = blkFactor;
  int memoryArea = blockFactor*sizeof(void*);
  expandableArray = (void**) new char [memoryArea];
  memset(expandableArray, 0, memoryArea);
  size = blockFactor;
  numberOfElements = 0;
}

Block::~Block() {
  delete [] expandableArray;
  size = 0;
  numberOfElements = 0;
}

void*
Block::getElement(const int index)  {
  if(index < numberOfElements) {
    return expandableArray[index];
  }
  else {
    return NULL;
  }
}

void
Block::removeElement(const int index)  {
  if(index < numberOfElements) {
    for(int ii=index; ii < numberOfElements-1; ii++) {
      expandableArray[ii] = expandableArray[ii+1];
    }
    numberOfElements--;
  }
  return;
}

void*
Block::operator [](const int index) {
  if(index < numberOfElements) {
    return expandableArray[index];
  }
  else {
    return NULL;
  }
}

void 
Block::addElement(void* newElement) {
  void** newArray = NULL;
  register int i=0;
  bool found = false;
  found = find(newElement);
  if(found == false) {
    if(numberOfElements < size) {
      expandableArray[numberOfElements] = newElement;
      numberOfElements++;
    }
    else {
      size = size + blockFactor;
      newArray = (void**) new void*[size];
      memset(newArray, 0, size*(sizeof(void*)));
      for(i=0; i < numberOfElements; i++) {
	newArray[i] = expandableArray[i];
      }
      newArray[i] = newElement;
      delete [] expandableArray;
      expandableArray = newArray;
      numberOfElements++;
    }
  }
  //else {
  //Do nothing here
  //}
}

bool
Block::find(void* element) {
  register int i =0;
  for(; i < numberOfElements; i++) {
    if(element == expandableArray[i]) {
      return true;
    }
  }
  return false;
}

int
Block::getNumberOfElements() const {
  return numberOfElements;
}

void
Block::reset() {
  register int i=0;
  for(i=0; i < numberOfElements; i++) {
    expandableArray[i] = NULL;
  }
  numberOfElements = 0;
}

Block&
Block::operator=(const Block& rhsBlock)
{
  if (expandableArray != NULL) {
    delete [] expandableArray;
  }

  size             = rhsBlock.size;
  numberOfElements = rhsBlock.numberOfElements;
  
  expandableArray = (void **) new void*[size];
  memset(expandableArray, 0, (size * sizeof(void *)));
  memcpy(expandableArray, rhsBlock.expandableArray, (size * sizeof(void *)));

  return *this;
}
