#ifndef SavantlineType_HH
#define SavantlineType_HH

#include "AccessType.hh"
#include "SavantstringType.hh"
#include "ObjectBase.hh"
#include "ScalarType.hh"
#include "ArrayType.hh"
#include "RecordType.hh"
#include "Vector.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "SignalNetinfo.hh"
#include "standard.hh"

class SavantlineType : public AccessType {
public:
 SavantstringType* val;
  
  VHDLType& all() {
    return *val;
  }
  
  virtual void setPointer(VHDLType* src) {
    if(src != NULL){
      if(src->get_kind() == ACCESS_TYPE) {
	val = ((SavantlineType*)src)->val;
      }
      else {
	val = (SavantstringType *)src;
      }
    }
    else {
      val = NULL;
    }
  }
  
  virtual void print(ostream& os = cout) const {
    os << val<< " " << endl;
    val->print(os);
  }
  
  virtual VHDLType* getPointer() const {
    return val;
  }
  
  virtual void resetPointer() {
    val = NULL;
  }
  
  SavantlineType() : AccessType() {
    val = NULL;
  }
  
  SavantlineType(VHDLType& value) :AccessType() {
    val = NULL;
    this->setPointer((VHDLType*)&value);
  }
  
  SavantlineType(bool alias, SavantlineType& actual): AccessType(alias, actual) {}
  
  SavantlineType(VHDLType *value) : AccessType() {
    setPointer(value);
  }
  
  virtual ~SavantlineType() {
    addValueToListForDeletion();
  }
  
  SavantlineType& operator = (SavantlineType& value) {
    val = value.val;
    return *this;
  }
  
  
  VHDLType& operator = (const VHDLType& value) {
    val = ((SavantlineType&) value).val;
    return *this;
  }
  
  SavantlineType& operator = (char* value) {
    val = new SavantstringType(ObjectBase::VARIABLE, 1, to, (int) strlen(value), value);
    return *this;
  }
  
  VHDLType* clone() const {
    VHDLType *retval = new SavantlineType(*this);
    return retval;
  }
  
  EnumerationType& operator[](const ScalarType& indexSubscript) const {
    return ((*val)[indexSubscript]);
  }
  
  VHDLType& operator[](const int indexSubscript) const {
    return (*val)[indexSubscript];
  }
};

extern EnumerationType
savantEqual(const SavantlineType& lhs, const SavantlineType& rhs);
extern EnumerationType
savantNotEqual(const SavantlineType& lhs, const SavantlineType& rhs);

extern ostream& operator << (ostream&, const SavantlineType&);

#endif
