//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef __ENTITY_ELAB_HH__
#define __ENTITY_ELAB_HH__

#include "VTime.hh"
#include "SourceBase.hh"
#include "Block.hh"
#include "PortMap.hh"

class SignalNetinfo;
class VHDLType;
class ScalarType;
class RecordType;
class ArrayType;
class TypeConvert;

extern ResolutionFnPtr *savantResolutionFn;
extern TypeConversionFnPtr *savantTypeConversionFn;

#ifdef SEQUENTIAL
#include "BaseSequential.hh"
#define OBJTYPE BaseSequential
#else
#include "BasicTimeWarp.hh"
#define OBJTYPE BasicTimeWarp
#endif

class _savant_entity_elab {
  // This Data structure contains the drivers. They are added to the Block
  // and deleted in the destructor and they are not deleted in SourceData node
  Block DriverData;
  Block TypeConvertData;
  Block BlockForDrivers;
public:
  _savant_entity_elab();
  virtual ~_savant_entity_elab();

  static int typeConversionFnIdCounter;
  static int resolutionFnIdCounter;

  virtual void instantiate();
  virtual void createNetInfo();
  virtual void connect(int inputsignals, int outputsignals, ...);

  virtual void Add(VHDLType&, VHDLType&);
  virtual void Add(VHDLType&, SignalNetinfo& sig);
  virtual void Add(VHDLType&, int objid);
  virtual void Add(VHDLType&, int objid, int sigid);
  virtual void Add(VHDLType&, SignalNetinfo* ptr);
  virtual void Addall(VHDLType&, VHDLType&);
  virtual void collectFanout(SignalNetinfo*, VHDLType&);

  VHDLType** opFanoutinfo;

  void setResolutionFunctionId(VHDLType&, ResolutionFnPtr);  
  //  void setResolutionFunctionId(ScalarType&, ResolutionFnPtr);  
  static int addResolutionFn(ResolutionFnPtr resolve);
  static int addTypeConversionFn(TypeConversionFnPtr upConvert);

  //  void setUpConversionFunctionId(ScalarType&, TypeConversionFnPtr);
  void setUpConversionFunctionId(VHDLType&, TypeConversionFnPtr);

  void setDownConversionFunctionId(ScalarType&, TypeConversionFnPtr);

  void addChild(SignalNetinfo* sigInfo, VHDLType *data, SourceId_t myId);
  void addChild(VHDLType& sigInfo, VHDLType& data, SourceId_t myId);
  void addChild(VHDLType& sigInfo, VHDLType& data);
  void addChild(SignalNetinfo* sigInfo, SignalNetinfo* driverInfo);
  void addUpConvertDriver(VHDLType& sigInfo, VHDLType &data, TypeConvert *typeConvertPtr);
  void addUpConvertDriver(SignalNetinfo *sigInfo, VHDLType *data, TypeConvert *typeConvertPtr);
  void addDriver(VHDLType &sigInfo, VHDLType &driverInfo);
  void addDriver(VHDLType &sigInfo, Block *newDriverList);
  void addDriverData(VHDLType *data);

  bool _is_block_present(VHDLType &sigInfo);

  void setSourceToRoot(ScalarType&);

  void setSourceInfo(VHDLType&, VHDLType&);
  void copyId(VHDLType &, VHDLType &);

  void addDownTypeConversionFn(VHDLType &, VHDLType &, TypeConversionFnPtr);
  Block* getDownTypeConversionFnList(VHDLType &);
  PortMap portMapAspect;

  //The component that is instantiated in an architecture declaration
  //is bound to some real entity(architecture)
  //The following function is used to get the information from the
  //real entity(architecture) pair to logical component
  virtual void getBoundEntityInfo();

  inline virtual void copyGenericsToGlobals() {};

  int checkSetSourceInfo(VHDLType &, int, VHDLType **);
  int checkAdd(VHDLType &, int, VHDLType **);
};

#endif
