#ifndef WAIT_HH
#define WAIT_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Wait.hh,v 1.15 1999/03/09 22:52:26 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "vhdl.hh"
#include "standard.hh"
#include "VectorBase.hh"
#include "RecordType.hh"
#include "ArrayType.hh"

class BasicState;
class VHDLKernelBase;

extern bool defaultWaitCond(VHDLKernelBase*);
extern PhysicalType defaultWaitTimeout(VHDLKernelBase*);

typedef bool (*waitConditionPtr)(VHDLKernelBase*);
typedef PhysicalType (*waitTimeoutPtr)(VHDLKernelBase*);

struct Wait {
  int sensSize;
  VHDLType** sensList;
  waitConditionPtr cond;
  waitTimeoutPtr timeout;

  Wait() {
    sensSize = -1;
    sensList = NULL;
    cond = defaultWaitCond;
    timeout = defaultWaitTimeout;
  }
  
  Wait& operator=(const Wait &);
  
  bool sensitiveTo(int sigid);
  void print(ostream& = cout) const;
private:
  bool isSensitive(int sigid, ScalarType* signal);
  bool isSensitive(int sigid, VHDLType* signal);
  bool isSensitive(int sigid, RecordType* signal);
  bool isSensitive(int sigid, VectorBase* signal);
};
#endif
