//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef TYPEINFO_HH
#define TYPEINFO_HH

#include "ArrayInfo.hh"
#include "Types.hh"

class IntegerType;
class RealType;

enum TypeInfoKind {RANGE_INFO, ENUM_INFO, REAL_INFO, PHY_INFO,
		   ARRAY_TYPE_INFO, UNKNOWN};

// The mother of all type info's

class TypeInfo {
public:
  TypeInfo() {}
  virtual ~TypeInfo() {}
  
  virtual TypeInfoKind getKind() const {
    cerr << "Error: TypeInfo::getKind() called.\n";
    return UNKNOWN;
  }

  virtual TypeInfo& operator=(const TypeInfo &) {
    cerr << "Error - TypeInfo::operator=() called.\n";
    return *this;
  }
  
  static TypeInfo NULL_TYPE_INFO;
  
protected:
  
private:
};

class rangeInfo : public TypeInfo {
public:
  rangeInfo();
  rangeInfo(int, ArrayDirn_t, int);
  rangeInfo(const rangeInfo &ri);
  rangeInfo(IntegerType&, ArrayDirn_t, IntegerType&);
  ~rangeInfo() {}
  int get_left() const;
  ArrayDirn_t get_direction() const;
  int get_right() const;
  rangeInfo& operator=(const rangeInfo& ri);
  TypeInfo& operator=(const TypeInfo& ti) {
    return operator=((const rangeInfo &) ti);
  }

  TypeInfoKind getKind() const {
    return RANGE_INFO;
  }
  
protected:
  int left;
  ArrayDirn_t dirn;
  int right;
  
private:
};

class enumInfo : public TypeInfo {
public:
  enumInfo();
  enumInfo(int n, char **, int left, ArrayDirn_t);
  ~enumInfo();
  enumInfo(const enumInfo& ei);
  char **get_imageMap() const;
  int get_no_of_elements() const;
  int get_left() const;
  int get_right() const;
  ArrayDirn_t get_direction() const;
  enumInfo& operator=(const enumInfo &ei);
  TypeInfo& operator=(const TypeInfo &ti) {
    return operator=((const enumInfo &) ti);
  }

  TypeInfoKind getKind() const {
    return ENUM_INFO;
  }
  
protected:
  char **imageMap;
  int no_of_elements;
  int left;
  ArrayDirn_t dirn;
  
private:
};

class realInfo : public TypeInfo {
public:
  realInfo();
  realInfo(const realInfo &ri);
  realInfo(double, ArrayDirn_t, double);
  realInfo(RealType&, ArrayDirn_t, RealType&);
  ~realInfo() {}
  
  double get_left() const;
  ArrayDirn_t get_direction() const;
  double get_right() const;
  
  realInfo& operator=(const realInfo &ri);
  TypeInfo& operator=(const TypeInfo& ti) {
    return operator=((const realInfo &) ti);
  }
  
protected:
  double left;
  ArrayDirn_t dirn;
  double right;

private:
};

class phyInfo : public TypeInfo {
public:
  phyInfo();
  phyInfo(const phyInfo &pi);
  phyInfo(int , LONG, ArrayDirn_t, LONG, LONG *, char**);
  ~phyInfo(){}
  
  phyInfo& operator=(const phyInfo &);
  TypeInfo& operator=(const TypeInfo &ti) {
    return operator=((const phyInfo &) ti);
  }
  int get_no_of_elements() const;
  LONG get_left() const;
  LONG get_right() const;
  ArrayDirn_t get_direction() const;
  LONG* get_scale_info() const;
  char ** get_unit_info() const;
  char* get_unit(int) const;
  LONG get_scale(int) const;

  TypeInfoKind getKind() const {
    return PHY_INFO;
  }
  
protected:
  char **unitInfo;
  LONG* scaleInfo;
  int no_of_elements;
  LONG left;
  ArrayDirn_t dirn;
  LONG right;

private:
};

//This holds info about the array type
class arrayTypeInfo : public TypeInfo {
public:
  arrayTypeInfo();
  arrayTypeInfo(int, rangeInfo*);
  arrayTypeInfo(const arrayTypeInfo&);
  ~arrayTypeInfo()  {}
  rangeInfo* get_rangeInfo() const;
  int get_dimensions() const;
  arrayTypeInfo& operator=(const arrayTypeInfo&);

  TypeInfoKind getKind() const {
    return ARRAY_TYPE_INFO;
  }

protected:
  rangeInfo *ranges;
  int noofDimensions;
  
private:
};

  
 
#endif
