/*$Id: e_compon.h,v 15.20 1999/11/04 06:52:47 al Exp $ -*- C++ -*-
 * branch structure type definitions
 * device types (enumeration type?)
 */
#ifndef E_COMPON_H
#define E_COMPON_H
#include "m_cpoly.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class COMPONENT_COMMON;
class COMPONENT;
/*--------------------------------------------------------------------------*/
#define conchk(o,n,a)	(fabs((n)-(o))<=(OPT::reltol*fabs(n)+(a)))
enum {CC_STATIC=27342383}; // mid-sized arbitrary positive int
// pass this as an argument to a common constructor to mark it as static,
// so it won't be deleted
/*--------------------------------------------------------------------------*/
class COMPONENT_COMMON {
private:
  COMPONENT_COMMON& operator=(const COMPONENT_COMMON&)
					{unreachable(); return *this;}
protected:
  explicit COMPONENT_COMMON(const COMPONENT_COMMON& p, int c=0)
    :_tnom(p._tnom),_modelname(p._modelname),_model(p._model),_attachcount(c)
    {}
  explicit COMPONENT_COMMON(int c=0)
    :_tnom(NOT_INPUT),_modelname(), _model(0), _attachcount(c) {}
public:
  virtual ~COMPONENT_COMMON()
			{assert(_attachcount==0||_attachcount==CC_STATIC);}

  const MODEL_CARD* attach_model()const;
  COMPONENT_COMMON& attach(const MODEL_CARD* m) {_model = m; return *this;}
  COMPONENT_COMMON& set_modelname(const std::string& n)
					{_modelname = n; return *this;}
  COMPONENT_COMMON& parse_modelname(CS&);

  virtual void	parse(CS&)		{unreachable();}
  virtual void	print(OMSTREAM)const	{unreachable();}

  virtual void	tr_eval(COMPONENT*x)const
			{untested(); assert(_model); _model->tr_eval(x);}
  virtual void	ac_eval(COMPONENT*x)const
			{untested(); assert(_model); _model->ac_eval(x);}
  virtual bool	has_tr_eval()const	{untested(); return false;}
  virtual bool	has_ac_eval()const	{untested(); return false;}

  virtual const char* name()const	= 0;
  const std::string&  modelname()const	{return _modelname;}
  const MODEL_CARD*   model()const	{assert(_model); return _model;}
	  bool	      has_model()const	{return _model;}

  const COMPONENT_COMMON* attach()const	{++_attachcount; return this;}
  int detach()const		{assert(_attachcount>0);return --_attachcount;}
protected:
  double	_tnom;
private:
  std::string	_modelname;
  mutable const MODEL_CARD* _model;
  mutable int	_attachcount;
};
/*--------------------------------------------------------------------------*/
/* note on _attachcount ...
 * The int argument is the initial _attachcount (default = 0)
 * Set it to CC_STATIC for static default versions that will never be deleted.
 * Set it to 0 (default) for auto versions, so they can be deleted.
 * A common will not be deleted on a detach if its _attachcount != 0
 * A failed assertion from the common destructor probably means
 * the common is being deleted before a device it is attached to is,
 * without being first detached.
 * This is why ~COMPONENT destroys the subckt explicitly.
 */
/*--------------------------------------------------------------------------*/
class COMPONENT : public CARD {
protected:
  explicit   COMPONENT();
  explicit   COMPONENT(const COMPONENT& p);
	     ~COMPONENT()		{subckt().destroy(); detach_common();}

  int	parse_nodes(CS&,int,int,int=0);
  void	printnodes(OMSTREAM,int,int=0)const;
  void	tr_eval();
  void	ac_eval();
  bool	has_tr_eval()const
		{return (has_probes() || (_common && _common->has_tr_eval()));}
  bool	has_ac_eval()const
		{return (has_probes() || (_common && _common->has_ac_eval()));}

  bool	is_device()const		{return true;}

  const MODEL_CARD* attach_model()const	
		{return (has_common() ? _common->attach_model() : 0);}
  void	attach_common(const COMPONENT_COMMON*);
  void	detach_common();

  bool	conv_check()const	{return conchk(y1.f1, y0.f1, OPT::abstol)
				   && conchk(y1.f0, y0.f0, OPT::abstol)
				   && conchk(y1.x,  y0.x,  OPT::abstol);}
  bool	conv_trace()const;
  bool	converged()const		{return _converged;}
  void	set_converged(bool s=true)	{_converged = s;}
  void	set_not_converged()		{_converged = false;}

  void	expandsubckt(const std::string& modelname);
  //--------------------------------------------------------------------
  // list and queue management
  bool	is_q_for_eval() {return (_queued_for_eval>=STATUS::iter[iTOTAL]);}
  bool	qfe() {if (is_q_for_eval()){return true;}else{
    _queued_for_eval=STATUS::iter[iTOTAL];return false;}}
  void	q_eval()	{if (!qfe()){SIM::evalq_uc->push_back(this);}}
  void	q_eval_last()	{if (!qfe()){SIM::evalq_uc->push_back(this);}}
  void	q_load()	{SIM::loadq.push_back(this);}
  void	q_accept()	{SIM::acceptq.push_back(this);}
  //--------------------------------------------------------------------
  // modifiers
public:
  COMPONENT& set(const std::string& Label, CARD* Parent,
		 const COMPONENT_COMMON* Common, double Value,
		 const node_t& N0, const node_t& N1);
  COMPONENT& set(const std::string& Label, CARD* Parent,
		 const COMPONENT_COMMON* Common, double Value,
		 const node_t& N0, const node_t& N1,
		 const node_t& N2, const node_t& N3);
  void set_slave()	{_queued_for_eval=INT_MAX;subckt().set_slave();}
  void set_value(double v)			     {CARD::set_value(v);}
  void set_value(double v, const COMPONENT_COMMON* c){_common=c;set_value(v);}
  //--------------------------------------------------------------------
  // querys
  bool	     has_common()const		{return _common;}
  //--------------------------------------------------------------------
  // data access
  const COMPONENT_COMMON* common()const	{return _common;}
private:
  const COMPONENT_COMMON* _common;
public: // commons
  FPOLY1   y0;		// iteration parameters, new
  FPOLY1   y1;		// iteration parameters, 1 iter ago
  FPOLY1   y2;		// iteration parameters, 2 iter ago
  COMPLEX  ev;		// ac effective value (usually real)
private:
  bool _converged;	// convergence status
  int _queued_for_eval;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
