/*$Id: d_mos3.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * MOS model - Spice level 3
 */
#ifndef D_MOS3_H
#define D_MOS3_H
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
class MODEL_MOS3 : public MODEL_MOS123 {
private:
  explicit	MODEL_MOS3(const MODEL_MOS3& p):MODEL_MOS123(p){unreachable();}
  void		parse_params(CS&);
  void		post_parse();
public:
  explicit	MODEL_MOS3();
private: // override virtual
  void		print(OMSTREAM,int)const;
  void		tr_eval(COMPONENT*)const;  
private:		/* strictly internal */
  enum {LEVEL=3};
private:		/* input parameters */
  double   nfs;		/* -23--- fast surface state density */
  double   vmax;	/* -23--- max drift velocity of carriers */
  double   theta;	/* --3--- mobility modulation (mos3, s.s. vbp) */
  double   eta;		/* -----b static feedback (mos3, spice shares uexp) */
  double   kappa;	/* --3--- saturation field vector (mos3, s.s. utra) */
private:		/* calculated parameters */
  double   alpha;	/* --3-c- ((2. * E_SI / Q) / nsub) */
  double   xd;		/* -23-c- sqrt(alpha) */
  double   cfsox;	/* -23--- Q * nfs / cox */
  double   delta3;	/* --3--- level 3 version of delta */
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
