/*$Id: bm_complex.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * behavioral modeling complex value
 * used with tc, etc, and conditionals
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(int c);
//		EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(const EVAL_BM_COMPLEX&);
//	void	EVAL_BM_COMPLEX::parse(CS& cmd);
// 	void	EVAL_BM_COMPLEX::print(int)const;
//	void	EVAL_BM_COMPLEX::tr_eval(COMPONENT* brh)const;
//	void	EVAL_BM_COMPLEX::ac_eval(COMPONENT* brh)const;
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(int c)
  :EVAL_BM_ACTION_BASE(c),
   _value(NOT_INPUT)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(const EVAL_BM_COMPLEX& p)
  :EVAL_BM_ACTION_BASE(p),
   _value(p._value)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    double real = NOT_VALID;
    double imag = 0.;
    cmd >> real >> imag;
    {if (cmd.gotit()){
      _value = COMPLEX(real,imag);
    }else{
      untested();
    }}
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::print(OMSTREAM where)const
{
  where << "  " << name() << '(' 
	<< _value.real() << ',' << _value.imag() << ')';
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::tr_eval(COMPONENT* d)const
{
  untested();
  tr_finish_tdv(d, _value.real());
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::ac_eval(COMPONENT* d)const
{
  d->ev = _value;
  ac_final_adjust_with_temp(&(d->ev));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
