/*$Id: d_vs.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * functions for fixed voltage sources
 * temporary kluge: it has resistance
 */
#include "d_vs.h"
/*--------------------------------------------------------------------------*/
void DEV_VS::precalc()
{
  loss  = 1./OPT::shortckt;
  y0.x  = 0.;
  y0.f0 = 0.;
  y0.f1 = value();
  y1 = y0;
  m0.x  = 0.;
  m0.c0 = -loss * y0.f1;
  m0.c1 = 0.;
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_VS::dc_begin()
{
  loss = 1./OPT::shortckt;
  if (!has_tr_eval()){
    assert(y0.x == 0.);
    assert(y0.f0 == 0.);
    assert(y0.f1 == value());
    assert(m0.x == 0.);
    m0.c0 = -loss * y0.f1;
    assert(m0.c1 == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_VS::do_tr()
{
  assert(m0.x == 0.);
  {if (has_tr_eval()){
    y0.x = SIM::time0;
    tr_eval();
    store_values();
    q_load();
    m0.c0 = -loss * y0.f1;
    assert(m0.c1 == 0.);
  }else{
    assert(conchk(loss, 1./OPT::shortckt, OPT::abstol));
    assert(y0.x == 0.);
    assert(y0.f0 == 0.);
    assert(y0.f1 == value());
    assert(m0.x == 0.);
    assert(conchk(m0.c0, -loss * y0.f1, OPT::abstol));
    assert(m0.c1 == 0.);
    assert(y1 == y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_VS::do_ac()
{
  ac_load_loss();
  {if (has_ac_eval()){
    ac_eval();
    acg = -loss * ev;
    ac_load_source();
  }else{
    assert(acg == 0.);
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
