/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdkb/vdkeditor.h>
#include <vdk/colors.h>
#include <vdkb/syntaxtable.h> 
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb.h>

//
VDKEditor::VDKEditor(VDKForm*owner,bool editable):
  VDKSCText(owner, editable, true)
{ 
  widget = gtk_hbox_new(FALSE,1);
  gtk_container_border_width(GTK_CONTAINER(widget),1);
  text = sigwid = gtk_editor_new(NULL,NULL);
  gtk_sctext_set_editable(GTK_SCTEXT(text),editable);
  gtk_box_pack_start(GTK_BOX(widget),text,TRUE,TRUE,0);
  scrollbar = gtk_vscrollbar_new(GTK_SCTEXT(text)->vadj);
  gtk_box_pack_start(GTK_BOX(widget),scrollbar,FALSE,TRUE,0);
  gtk_widget_show(text);
  gtk_widget_show(scrollbar);
  /* setup event handler */   
  gtk_signal_connect (GTK_OBJECT (text), "key_press_event", 
  	      GTK_SIGNAL_FUNC (VDKSCText::KeyEvent), this);
  ConnectDefaultSignals();
  
  st_entries = pt_entries = (GList*) NULL;
  cpp_fun_props = NULL;
#ifdef HAVE_HINTS
  hint = (GtkHint*) NULL;
#endif
}
/*
 */
VDKEditor::~VDKEditor()
{
  
if(st_entries)
   gtk_editor_free_stentries (st_entries);
if(pt_entries)
  gtk_editor_free_pentries (pt_entries);
if(cpp_fun_props)
  g_free(cpp_fun_props);
  
}
void 
VDKEditor::ClearSyntaxAndPatternsTables()
{
if(st_entries)
   gtk_editor_free_stentries (st_entries);
if(pt_entries)
  gtk_editor_free_pentries (pt_entries);
if(cpp_fun_props)
  g_free(cpp_fun_props);
st_entries = NULL;
pt_entries = NULL;
cpp_fun_props = NULL;
}
/*
 */
void  VDKEditor::SetFont(VDKFont* font)
{
if(font)
  {
    GtkStyle* style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(text))) ;
    gtk_style_ref(style);
    style->font = *font;
    gtk_widget_set_style(GTK_WIDGET(text),style);
  }
} 
/*
SYNTAX STUFF:
1. Comments
2. string and char const
 */
const int MAX_STENTRY = 4;
static VDKSTableEntry st[MAX_STENTRY] =
{
  {"C-comment"  , "/\\*"  , "\\*/"    , FALSE },
  {"C++-comment", "//"    , "\n"      , FALSE },
  {"string"     , "\""    , "\""      , FALSE },
  {"chars"      , "'"     , "'"       , FALSE }
};


static VDKColor *s_colors[MAX_STENTRY];
static VDKFont  *s_fonts[MAX_STENTRY];

void
VDKEditor::InstallSyntaxTable (VDKColor* comment_color,
			       VDKFont*  comment_font,
			       VDKColor* string_const_color,
			       VDKFont*  string_const_font,
			       VDKColor* chars_const_color,
			       VDKFont*  chars_const_font)
{
  GList* p = NULL;
  s_colors[0] = s_colors[1] = comment_color;
  s_colors[2] = string_const_color;
  s_colors[3] = chars_const_color;
  s_fonts[0]  = s_fonts[1] = comment_font; 
  s_fonts[2]  = string_const_font;
  s_fonts[3]  = chars_const_font;
  int t = 0;
  st_entries = p = gtk_editor_stentry_new(st[t].name,
					  st[t].start,
					  st[t].end, 
					  st[t].nest,
					  s_fonts[t] ? *s_fonts[t] : 
					  (GdkFont*) NULL, 
					  *s_colors[t], 
					  NULL,NULL);
  for(t=1; p && t < MAX_STENTRY;t++)
    {
      p->next = gtk_editor_stentry_new(st[t].name,
				       st[t].start,
				       st[t].end, 
				       st[t].nest,
				       s_fonts[t] ? *s_fonts[t] : 
				       (GdkFont*) NULL, 
				       *s_colors[t], 
				       NULL,NULL);
      p = p->next;
    }
  gtk_editor_install_stable (GTK_EDITOR(text), st_entries);
}



#define MAX_PTENTRY  11
static VDKPTableEntry pt[MAX_PTENTRY] =
{
  {"vdk1"  , "\\b\\(do\\|while\\|for\\|if\\|else\\|bool\\|template\\|continue\\)\\b" },
  {"vdk2"  , "\\b\\(case\\|switch\\|break\\|new\\|delete\\|default\\|return\\)\\b"},
  {"vdk3"  , "\\b\\(char\\|short\\|int\\|long\\|float\\|double\\|unsigned\\|true\\|false\\)\\b"},
  {"vdk4"  , "\\b\\(this\\|void\\|struct\\|union\\|enum\\|const\\|static\\)\\b"},
  {"vdk5"  , "\\b\\(class\\|public\\|protected\\|private\\|friend\\|dynamic_cast\\)\\b"},
  {"vdk6"  , "^#[ \t]*\\(include\\|if\\|ifdef\\|ifndef\\|else\\|define\\|endif\\)\\b"},
  {"vdk7"  , "\\b\\(DEFINE_SIGNAL_MAP\\|ON_SIGNAL\\|END_SIGNAL_MAP\\|DECLARE_SIGNAL_MAP\\)\\b" },
  {"vdk8"  , "\\b\\(DECLARE_SIGNAL_LIST\\|DEFINE_SIGNAL_LIST\\)\\b" },
  {"vdk9"  , "\\b\\(DECLARE_EVENT_LIST\\|DEFINE_EVENTL_LIST\\)\\b" },
  {"vdk10"  , "\\b\\(\\<VDK[A-Z][A-Za-z]*\\)\\b" },
  {"vdk11"  , "\\b\\(SignalConnect\\|EventConnect\\)\\b" },
}; 

/*
 */
void 
VDKEditor::InstallPatternTable(VDKColor *key_color,
			       VDKFont  *key_font,
			       VDKColor *preprocess_color)
{
  GList *p = NULL;
  // pay attention to correctly initialize this one.
  VDKColor *p_colors[MAX_PTENTRY] =
  { key_color, key_color, key_color, 
    key_color, key_color, preprocess_color, 
    key_color,key_color,key_color,
    key_color,key_color
  };
  int t = 0;
  pt_entries = p = gtk_editor_pentry_new (pt[t].name,
					  pt[t].pattern,
					  (GdkFont*) *key_font,
					  *p_colors[t], 
					  NULL,NULL);
  for(t=1; p && t < MAX_PTENTRY;t++)
    {
      p->next = gtk_editor_pentry_new (pt[t].name,
				       pt[t].pattern,
				       (GdkFont*) *key_font,
				       *p_colors[t], 
				       NULL,NULL);
      p = p->next;
    }
  
  // with registers
  VDKColor *blue = new VDKColor(Owner(),clNavyBlue);
  // C++ members
  if(!cpp_fun_props )
    cpp_fun_props = g_new (GtkSCTextProperties, 4);
  cpp_fun_props[0].fore = NULL;
  cpp_fun_props[0].back = NULL;
  cpp_fun_props[0].font = NULL;
  //
  cpp_fun_props[1].fore = NULL;
  cpp_fun_props[1].back = NULL;
  cpp_fun_props[1].font = NULL;
  /* the class name */
  cpp_fun_props[2].fore = *key_color;
  cpp_fun_props[2].back = NULL;
  cpp_fun_props[2].font = (GdkFont*) *key_font;
  /* and the function name */
  cpp_fun_props[3].fore = *blue;
  cpp_fun_props[3].back = NULL;
  cpp_fun_props[3].font = (GdkFont*) *key_font;
  /* last entry */
  p->next =   gtk_editor_pentry_new_with_regs ("C++-funcs",
  "^\\(\\([a-zA-Z_][a-zA-Z0-9_]*\\)::\\([~a-zA-Z_][a-zA-Z0-9_]*\\)\\)[ \t]*(",
					       4, cpp_fun_props,NULL);
  gtk_editor_install_patterns (GTK_EDITOR(text), pt_entries);
}
 
#ifdef  HAVE_HINTS
void 
VDKEditor::InstallHints(GtkHintCallback cb, gpointer data)
{
  /*
    deactivated for now.. 
  hint = gtk_hint_new ();
  VDKColor *yellow = new VDKColor(Owner(),clYellow);
  VDKColor *black = new VDKColor(Owner(),clBlack);
  gtk_hint_set_colors (hint,*yellow,*black);
  gtk_hint_set_hint (hint, text,
  "\\<\\(\\w[a-zA-Z0-9_]*\\)[\\t\\n ]*[( ][^()]*$",
  cb, data);
  */
}

#endif

 
