/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * January 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_prjopt.h>
//static char buff[512];
extern char*
ExtractWord(char* src,char* tgt,char* key1,char* key2);
extern char *
ExtractSection (char *buffer, char *section_begin, char* section_end);
static char *avoid = "\"\r\n\t";
/*
 */
VDKBProjectOptions::VDKBProjectOptions(int type):
  type(type),
  c_compiler("gcc"),
  cc_compiler("g++"),
  link("g++"),
  defines("-DNONE"),
  includes("-I./"),
  debugger(""),
  runargs(""),
  version("0.0.1")

{
  switch(type)
    {
    case vdk_project:
      c_flags = "-g -Wall `vdk-config --cflags`";
      libs = "`vdk-config --libs`";
      break;
    case vdk_gnome_project:
      c_flags = "-g -Wall `vdk-config --cflags`";
      libs = "`vdk-config --libs`";
      defines = "-DHAVE_GNOME";
      break;      
    default:
      c_flags = "-g -Wall";
      break;
    }
}
/*
 */
VDKBProjectOptions::~VDKBProjectOptions()
{
}
/*
 */
bool
VDKBProjectOptions::Save()
{
  FILE* fp = fopen(filename,"w+");
  if(!fp)
    return false;
  // compilers section
  fprintf(fp,"/*\n!!! PLEASE DO NOT EDIT THIS FILE !! (or edit at your own risk)\n");
  fprintf(fp,"Let VDKBuilder do the job for you\n*/\n");
  fprintf(fp,"%s%s%s%s%s%s%s%s\n",
	  COMPILERS_SECTION, C_COMPILER, (char*) c_compiler,
	  END_KEY,  CC_COMPILER, (char*) cc_compiler, END_KEY, END_SECTION);
  // link section
  fprintf(fp,"%s%s%s%s%s\n",
	  LINK_SECTION, LINK, (char*) link, END_KEY, END_SECTION);
  // c flags section
  fprintf(fp,"%s%s%s%s%s\n",
	  C_FLAGS_SECTION, C_FLAGS, (char*) c_flags, END_KEY, END_SECTION);
  // define section
  fprintf(fp,"%s%s%s%s%s\n",
	  DEFINES_SECTION, DEFINES, (char*) defines, END_KEY, END_SECTION);
// include section
  fprintf(fp,"%s%s%s%s%s\n",
	  INCLUDES_SECTION, INCLUDES, (char*) includes, END_KEY, END_SECTION);
// libs section
  fprintf(fp,"%s%s%s%s%s\n",
	  LIBS_SECTION, LIBS, (char*) libs, END_KEY, END_SECTION);
// debugger section
  fprintf(fp,"%s%s%s%s%s\n",
	  DEBUGGER_SECTION, DEBUGGER, (char*) debugger, END_KEY, END_SECTION);
// program section
  fprintf(fp,"%s%s%s%s%s\n",
	  PROGRAM_SECTION, RUNARGS, (char*) runargs, END_KEY, END_SECTION);
// package section
  fprintf(fp,"%s%s%s%s%s\n",
	  PACKAGE_SECTION, PKG_VERSION, (char*) version, END_KEY, END_SECTION);
  fclose(fp);
  return true;
}
/*
 */
bool
VDKBProjectOptions::Load()
{
char* buff,*p,*section;
char *key = new char[512];
struct stat info;
char* file = (char*) filename;
stat(file,&info);
FILE* fp = fopen(file,"r");
if(fp)
  {
    int c;
    buff = p = new char[info.st_size+1];
    while( (c = fgetc(fp)) != EOF)
      {
      if (!strchr (avoid, c))
	*p++ = (char) c;
      }
    *p = '\0';
    fclose(fp);
  }
else
  return false;

if((section = ExtractSection(buff,COMPILERS_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,C_COMPILER,END_KEY)))
      c_compiler = key;
    if((key = ExtractWord(section,key,CC_COMPILER,END_KEY)))
      cc_compiler = key;
    delete[] section;
  }

if((section = ExtractSection(buff,LINK_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,LINK,END_KEY)))
      link = key;
    delete[] section;
  }

if((section = ExtractSection(buff,C_FLAGS_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,C_FLAGS,END_KEY)))
      c_flags = key;
    delete[] section;
  }

if((section = ExtractSection(buff,DEFINES_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,DEFINES,END_KEY)))
      defines = key;
    delete[] section;
  }

if((section = ExtractSection(buff,INCLUDES_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,INCLUDES,END_KEY)))
      includes = key;
    delete[] section;
  }

if((section = ExtractSection(buff,LIBS_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,LIBS,END_KEY)))
      libs = key;
    delete[] section;
  }

if((section = ExtractSection(buff,DEBUGGER_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,DEBUGGER,END_KEY)))
      debugger = key;
    delete[] section;
  }
if((section = ExtractSection(buff,PROGRAM_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,RUNARGS,END_KEY)))
      runargs = key;
    delete[] section;
  }
if((section = ExtractSection(buff,PACKAGE_SECTION,END_SECTION)))
  {
    if((key = ExtractWord(section,key,PKG_VERSION,END_KEY)))
      version = key;
    delete[] section;
  }
// finished
delete[] buff;
delete[] key;
return true;
}


