/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_types.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_textlabel.h>
#include <vdkb/vdkb_frame.h>
#include <vdkb/vdkb_pixmap.h>
#include <vdkb/vdkb_scrolled.h>
#include <vdkb/vdkb_menubar.h>
#include <vdkb/vdkb_menuitem.h>
#include <vdkb/vdkb_textwidget.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_entry.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_pixbutton.h>
#include <vdkb/vdkb_toolbar.h>
#include <vdkb/vdkb_customlist.h>
#include <vdkb/vdkb_customtree.h>
#include <vdkb/vdkb_separator.h>
#include <vdkb/vdkb_table.h>
#include <vdkb/vdkb_rbgroup.h>
#include <vdkb/vdkb_handlebox.h>
#include <vdkb/vdkb_guicanvas.h>
#include <vdkb/vdkb_combo.h>
#include <vdkb/vdkb_checkbutton.h>
#include <vdkb/vdkb_radiobutton.h>
#include <vdkb/vdkb_spinbutton.h>
#include <vdkb/vdkb_pbar.h>
#include <vdkb/vdkb_custombutton.h>
#include <vdkb/vdkb_sbar.h>
#include <vdkb/vdkb_grid.h>
#include <vdkb/vdkb_packer.h>
#include <vdkb/vdkb_slider.h>
#include <vdkb/vdkb_pholder.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_gnomeappbar.h>
#include <vdkb/vdkb_dedit.h>
#include <vdkb/vdkb_gnomeentry.h>

#include <ctype.h>
static char buff[256];
extern VDKBuilder* TheApp;
/*
Generic runtime new widget creation.
Scans vdkclasstypes table and call
static constructors mapped with class name.
Newly constructed widget will be added directly
to his parent (target). Target must be a container
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
3 - no active widget
 */
// class id's - static constructors table
struct
{
  int action_target;
  int (*make_widget)(VDKBGuiForm* owner, GdkEvent* ev);
  char* widgetName;
} vdkclasstypes[] =
// button id conventions:
// XXXX_TOOL_YYYY_ZZZZ
// where XXXX is palette name
//       YYYY_ZZZZ widget class name
// id's defined in vdkb_types.h
{
  // containers
  { CONTAINERS_TOOL_VBOX, VDKBEventBox::MakeWidgetV, "VDKBox"},
  { CONTAINERS_TOOL_HBOX, VDKBEventBox::MakeWidgetH, "VDKBox"},
  { CONTAINERS_TOOL_FRAME, VDKBFrame::MakeWidget, "VDKFrame"},
  { CONTAINERS_TOOL_SCROLLED, VDKBScrolled::MakeWidget, "VDKScrolled"},
  { CONTAINERS_TOOL_MENUBAR, VDKBMenubar::MakeWidget, "VDKMenubar"},
  { CONTAINERS_TOOL_VPANED, VDKBPaned::MakeWidgetV, "VDKPaned"},
  { CONTAINERS_TOOL_HPANED, VDKBPaned::MakeWidgetH, "VDKPaned"},
  { CONTAINERS_TOOL_NBOOK, VDKBGuiNotebook::MakeWidget, "VDKNotebook"},
  { CONTAINERS_TOOL_TOOLBAR,VDKBToolbar::MakeWidget, "VDKToolbar"},
  { CONTAINERS_TOOL_TABLE, VDKBTable::MakeWidget, "VDKTable" },
  { CONTAINERS_TOOL_VRADIOBG, VDKBRadioButtonGroup::MakeWidgetV,
    "VDKRadioButtonGroup" },
  { CONTAINERS_TOOL_HANDLE, VDKBHandleBox::MakeWidget, "VDKHandleBox" },
  { CONTAINERS_TOOL_PACKER, VDKBPacker::MakeWidget, "VDKPacker" },
  { CONTAINERS_TOOL_FIXED, VDKBFixed::MakeWidget, "VDKFixed" },
  // buttons
  { BUTTON_TOOL_LABEL_BUTTON, VDKBLabelButton::MakeWidget, "VDKLabelButton"},
  { BUTTON_TOOL_PIXMAP_BUTTON,VDKBPixmapButton::MakeWidget, "VDKPixmapButton"},
  { BUTTON_TOOL_CHECK_BUTTON, VDKBCheckButton::MakeWidget, "VDKCheckButton"},
  { BUTTON_TOOL_RADIO_BUTTON,VDKBRadioButton::MakeWidget, "VDKRadioButton"},
  { BUTTON_TOOL_SPIN_BUTTON,VDKBSpinButton::MakeWidget, "VDKSpinButton"},
  { BUTTON_TOOL_CUSTOM_BUTTON,VDKBCustomButton::MakeWidget, "VDKCustomButton"},
  // texts
  { TEXT_TOOL_LABEL, VDKBTextLabel::MakeWidget, "VDKLabel"},
  { TEXT_TOOL_TEXT, VDKBTextWidget::MakeWidget, "VDKText"},
  { TEXT_TOOL_ENTRY, VDKBEntry::MakeWidget, "VDKEntry"},
  // misc
  { MISC_TOOL_CANVAS,VDKBGuiCanvas::MakeWidget, "VDKCanvas"},
  { MISC_TOOL_PIXMAP, VDKBPixmap::MakeWidget, "VDKPixmap"},
  { MISC_TOOL_MENU_ITEM, VDKBMenuItem::MakeWidget, "VDKMenuItem"},
  { MISC_TOOL_CUSTOMLIST,VDKBCustomList::MakeWidget, "VDKCustomList"},
  { MISC_TOOL_COMBOBOX,VDKBCombo::MakeWidget, "VDKCombo"},
  { MISC_TOOL_CUSTOMTREE,VDKBGuiCustomTree::MakeWidget, "VDKCustomTree"},
  { MISC_TOOL_HSEPARATOR,VDKBSeparator::MakeWidgetH, "VDKSeparator"},
  { MISC_TOOL_VSEPARATOR,VDKBSeparator::MakeWidgetV, "VDKSeparator"},
  { MISC_TOOL_PROGRESS,VDKBProgressBar::MakeWidget, "VDKProgressBar"},
  { MISC_TOOL_STATUSBAR,VDKBStatusbar::MakeWidget, "VDKStatusbar"},
  { MISC_TOOL_GRID,VDKBGrid::MakeWidget, "VDKGrid"},
  { MISC_TOOL_SLIDER,VDKBSlider::MakeWidget, "VDKSlider"},
  { MISC_TOOL_PLACEHOLDER,VDKBPlaceHolder::MakeWidget, "VDKPlaceHolder"},
  // gnome widgets
#if HAVE_GNOME
  { GNOME_TOOL_STATUSBAR,VDKBGnomeAppBar::MakeWidget, "VDKGnomeAppBar"},
  { GNOME_TOOL_DATEEDIT,VDKBGnomeDateEdit::MakeWidget, "VDKGnomeDateEdit"},
  { GNOME_TOOL_ENTRY,VDKBGnomeEntry::MakeWidget, "VDKGnomeEntry"},
#endif
  // table end
  {-1,NULL,NULL}
};
/*
 */
int
MakeWidget(VDKBGuiForm* owner, int action_target, GdkEvent* ev)
{
int t;
int result = 1; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(vdkclasstypes[t].action_target == action_target)
    {
      result =  vdkclasstypes[t].make_widget(owner,ev);
      break;
    }
// statically unsopported widget
// try to seek it into plugins list
if(result == 1)
  {
    VDKBAbstractComponentInterface* interface =
      TheApp->PluginList().Interface(action_target);
    if(interface)
      result =  interface->MakeWidget(owner,ev);
  }
return result;
}
/*
given an widget class name
returns widget id
*/
int
WidgetClassId(char* class_name)
{
int t;
int result = -1; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(!strcmp(vdkclasstypes[t].widgetName,class_name))
    {
      result =  vdkclasstypes[t].action_target;
      break;
    }
return result;
}
/*
given an widget id
returns widget class name
*/
char*
WidgetClassName(int action_target)
{
int t;
char* result = NULL; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(vdkclasstypes[t].action_target == action_target)
    {
      result =  vdkclasstypes[t].widgetName;
      break;
    }
return result;
}
//////////////////////////////////////////////////////
/*
obsolete, not more used.
 */
void
VDKBProjectManager::ChildResized(VDKBGuiForm* child,
				 VDKPoint& newsize)
{
  // safe and safer
if(!ActiveChild.child || ActiveChild.child != child)
  return;

 char match[32],replace[32],textname[256];

 sprintf(match,"%s.Usize:",(char*) ActiveChild.name);
 sprintf(replace,"%s.Usize:%4d,%4d;",
	 (char*) ActiveChild.name,
	 newsize.X(),newsize.Y());
 sprintf(textname,"%s.%s",(char*) ActiveChild.name,FORM_EXT);
 // replaces <match> with<replace> in <textname>
 ReplaceAllMatches(match,
		   replace,
		   textname,
		   /*
		     forward offset, replace more chars than match,
		     useful for changing args.
		     If match = replace set offset to 0
		   */
		   strlen(replace)-strlen(match),
		   false); // not all
child->Changed = true;
}

/*
 */
void
VDKBProjectManager::ReplaceAllMatches(char* match,
				      char* replace,
				      char* textname,
				      int offset,
				      bool all)
{
  VDKBMainForm* mainform = (VDKBMainForm*) Owner();
  VDKBEditor* editor = mainform->MakeEditor();
  if(! editor)
    return;
  else if(! editor->Visible)
    editor->Visible = true;
  else if(editor->Iconized )
    editor->Iconized = false;
  VDKBText* text = NULL;
  int t = -1;
  mainform->MakeEditor();
  // look for editor page
  TextListIterator li(editor->textlist);
  for(;li;li++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }
   if(! text)
     {
       ActivateEditor(textname,false,false);
       // find text page
       t  = editor->nbook->ActivePage;
       if(t<0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text)
     return;
   // replace all occurrences
   int pos = 0;
   while(pos >= 0 && pos < (int) text->Length)
     {
       pos = text->Search(match, pos, true, false); // no bell
       if(pos >= 0)
	 {
	   text->Pointer = pos;
	   text->ForwardDelete(strlen(match)+offset);
	   text->Pointer = pos;
	   text->TextInsert(replace);
	   pos += strlen(replace);
	 }
       if(! all)
	 break;
     }
   text->SaveToFile(textname);
   text->Changed = false;
}
/*
defines or jump to response method
 */
void
VDKBProjectManager::DefineResponseMethod( char* textname, char* method)
{
   VDKBMainForm* mainform = (VDKBMainForm*) Owner();
   VDKBEditor* editor = mainform->MakeEditor();
   if(! editor)
     return;
   else if(! editor->Visible)
     editor->Visible = true;
   else if(editor->Iconized )
     editor->Iconized = false;

   VDKBText* text = NULL;
   int t = 0;
   // look for editor page
   TextListIterator li(editor->textlist);
   for(;li;li++,t++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }

   if(text)
     editor->nbook->ActivePage = t;
   else
     {
       // open a new notebook page and set it as active page
       ActivateEditor(textname,true,true);
       // find text page address
       t  = editor->nbook->ActivePage;
       if( t < 0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text) return;
   int pos = text->Search(method, 0, true, false); // no bell
   if(pos >= 0)
     text->Pointer = pos;
   else
     {
       char formname[64];
       strcpy(formname,ActiveChild.name);
       formname[0] = toupper(formname[0]);
       text->Pointer = text->Length;
       sprintf(buff,
"\n// signal response method \nbool\n%sForm::%s(VDKObject* sender)\n{\nreturn true;\n}\n",
	       formname,method);
       text->TextInsert(buff);
       pos = text->Search(method, 0, true, false);
       if(pos >= 0)
	 text->Pointer = pos;
     }
}


/*
defines or jump to response method
 */
/*
 */

FormEventHandlers evTableItems [] =
{
  {{ "OnFormActivate","no" }, "OnFormActivate(VDKForm* sender, bool in_out)"},
  {{ "OnChildClosing","no" }, "OnChildClosing(VDKForm* child)" },
  {{ "OnConfigure","no"    }, "OnConfigure(VDKForm* sender)"},
  {{ "OnExpose","no"       }, "OnExpose(VDKForm* sender, GdkRectangle area)"},
  {{ "OnIconize","no"      }, "OnIconize(VDKForm* sender)"},
  {{ "OnMove","no"         }, "OnMove(VDKForm* sender)"},
  {{ "OnRealize","no"      }, "OnRealize(VDKForm* sender)"},
  {{ "OnResize","no"       }, "OnResize(VDKForm* sender, VDKPoint& new_size)"},
  {{ "OnRestore","no"      }, "OnRestore(VDKForm* sender)"},
  {{ "OnShow","no"         }, "OnShow(VDKForm* sender)"},
  {{ NULL, NULL }}
};
void
VDKBProjectManager::DefineFormEventHandler( char* textname, char* handler)
{
  char* method = NULL;
  VDKBMainForm* mainform = (VDKBMainForm*) Owner();
  VDKBEditor* editor = mainform->MakeEditor();
   if(! editor)
     return;
   else if(! editor->Visible)
     editor->Visible = true;
   else if(editor->Iconized )
     editor->Iconized = false;
   VDKBText* text = NULL;
   int t = 0;
   // look for editor page
   TextListIterator li(editor->textlist);
   for(;li;li++,t++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }

   if(text)
     editor->nbook->ActivePage = t;
   else
     {
       // open a new notebook page and set it as active page
       ActivateEditor(textname,true,true);
       // find text page address
       t  = editor->nbook->ActivePage;
       if( t < 0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text) return;
   // match handler/method
   int z = 0;
   for(z=0; evTableItems [z].items[0];z++)
     if(!strcmp(handler,evTableItems [z].items[0]))
       method = evTableItems [z].method;
   if(method)
     {
       int pos = text->Search(method, 0, true, false); // no bell
       if(pos >= 0)
	 text->Pointer = pos;
       else
	 {
	   char formname[64];
	   strcpy(formname,ActiveChild.name);
	   formname[0] = toupper(formname[0]);
	   text->Pointer = text->Length;
	   sprintf(buff,
 "\n// form event response method \nvoid\n%sForm::%s\n{\nreturn ;\n}\n",
		   formname,method);
	   text->TextInsert(buff);
	   pos = text->Search(method, 0, true, false);
	   if(pos >= 0)
	     text->Pointer = pos;
	 }
     }
}
/*
 */
void
VDKBProjectManager::ActivateChild(VDKBGuiForm* sender,
				bool active)
{
if(active)
  {
    VDKTreeNode node = tree->SelectedNode;
    if(node)
      tree->UnselectedNode = node;

    ActiveChild.child = sender;
    ActiveChild.name = sender->Name();


    VDKTreeNodeList* list = tree->Find((char*) sender->FileName());
    if(list->size() > 0)
      tree->SelectedNode = (*list)[0];
    delete list;

    // no node selected so get away
    node = tree->SelectedNode;
    if(node)
      {
	gpointer p =
	  gtk_ctree_node_get_row_data(GTK_CTREE(tree->CustomWidget()),node);
	(*toolbar)[OPEN_FILE_BUTTON]->Enabled = p == (gpointer) form_unit ?
	  true : false;
      }
    if(objInspector)
      {
	objInspector->SetActive(NULL);
	objInspector->LoadTree(sender);
      }
    // enables form/text toggle button on main toolbar
    VDKBMainForm* mainform = (VDKBMainForm*) Owner();
    if(project)
      {
	sprintf(buff,"%s/%s.cc",(char*) project->Path,
		(char*) ActiveChild.name);
	mainform->EnableToggleFormUnit(active,buff);
      }
  }
}

/*
 */
void
VDKBProjectManager::OnChildClosing(VDKForm* child)
{
GuiFormListIterator li(formlist);
for(;li;li++)
  if(li.current() == child)
    break;
// found and the only one on list
if(li && (formlist.size() == 1))
  {
    VDKBMainForm* mainform = (VDKBMainForm*) Owner();
    mainform->Automa(automa_edit_form_off);
  }
}
/*
 */
bool
VDKBProjectManager::IsFormChanged(char* name)
{
VDKString fname = name;
fname += ".";
fname += FORM_EXT;
GuiFormListIterator li(formlist);
for(;li;li++)
  {
    if(fname == li.current()->FileName())
      {
	if(li.current()->Changed)
	      return true;
      }
  }
return false;
}
/*
writes gui files if they do not exist or
<form name>.frm is changed
 */
void
VDKBProjectManager::WriteGuiFiles()
{
  VDKTreeNodeList* list = tree->Select(".frm");
  if(list->size())
    {
      VDKTreeNodeListIterator li(*list);
      for(;li;li++)
	{
	  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
	  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
	  char *tmp, *local,*copy;
	  tmp = new char[256];
	  local = new char[512];
	  copy = new char[256];
	  strcpy(tmp,tree->Key(li.current()));
	  char* p = get_extension(tmp);
	  if(p)
	    *p = '\0';
	  sprintf(local,"%s_gui.%s",tmp,cc_ext);
	  strcpy(copy,local);
	  if(access(local,F_OK) || IsFormChanged(tmp))
	    {
	      // update <form name>.frm
	      if(IsFormChanged(tmp))
		{
		  GuiFormListIterator lf(formlist);
		  for(;lf;lf++)
		    {
		      VDKString fname = tmp;
		      fname += ".";
		      fname += FORM_EXT;
		      if(fname == lf.current()->FileName() &&
			 AskSaveForm(fname) )
			{
			  lf.current()->WriteFormFile();
			  lf.current()->Changed = false;
			  break;
			}
		    }
		}
	      // writes or update <form name>_gui .cc
	      if(strcmp(local,copy))
		 {
		   char *msg = new char[512];
		   sprintf(msg,"*** WARNING ***,\n\
attempt to overwrite <%s>\nwith <%s>\noperation aborted",local,copy);
		   Application()->MessageBox(APPNAME,
				msg,
				MB_ICONINFORMATION|MB_OK,
				user_messages[user_ok]);
		   delete[] msg;
		 }
	      else
		{
		  FILE* fp = fopen(local,"w+");
		  if(!fp) break; // FIX ME : warn user
Project()->WriteGUISetupParsingFrm(fp, tree->Key(li.current()));
		  // writes or update <form name>_gui .h	
		  sprintf(local,"%s_gui.%s",tmp,h_ext);
		  fp = fopen(local,"w+");
		  if(!fp) break; // FIX ME : warn user
		  Project()->WriteGuiHeaderParsingFrm(fp, tree->Key(li.current()));
		}
	    }
	  delete[] tmp;
	  delete[] local;
	  delete[] copy;
	}
    }
  delete list;
}

extern int  AskUserToSaveFile(char* name);
/*
 */
bool
VDKBProjectManager::AskSaveForm(char* name)
{
  return AskUserToSaveFile(name) == IDYES;
  /*
  char local[256];
  sprintf(local,"%s\n%s",name,
	  user_messages[user_request_save]);
  return Application()->MessageBox(APPNAME,
			       local,
			       MB_ICONINFORMATION|MB_YESNO,
			       user_messages[user_ok],
			       user_messages[user_no]) == IDYES;
  */
}
