/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _vdk_editor_h
#define _vdk_editor_h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdkb/sctext.h>
#include <vdk/colors.h>
#include <vdkb/gtkeditor.h>

#ifdef  HAVE_HINTS
#include <vdkb/gtkhint.h>
#endif
//
typedef struct  
{
  char* name, *start, *end;
  gboolean nest;
} VDKSTableEntry;
//
typedef struct
{
  char *name,*pattern;
} VDKPTableEntry;

//

/*
===============================
 */

class VDKEditor: public VDKSCText
{
  GList *st_entries,*pt_entries;
  GtkSCTextProperties *cpp_fun_props;

 public:
  VDKEditor(VDKForm*owner, bool editable = true);
  virtual ~VDKEditor();

  void InstallSyntaxTable (VDKColor* comment_color,
			   VDKFont*  comment_font,
			   VDKColor* string_const_color,
			   VDKFont*  string_const_font,
			   VDKColor* chars_const_color,
			   VDKFont*  chars_const_font);
  void InstallPatternTable(VDKColor *key_color,
			   VDKFont  *key_font,
			   VDKColor *preprocess_color);
  void ClearSyntaxAndPatternsTables();
  virtual void  SetFont(VDKFont* f);
  void HiliteScreen() 
    { gtk_editor_hilite_screen (GTK_EDITOR(text)); }

#ifdef HAVE_HINTS
  GtkHint *Hint() { return hint; }
  void InstallHints(GtkHintCallback cb, gpointer data);
 protected:
  GtkHint *hint ;
#endif
};
#endif

