/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_pbar_h
#define _vdkb_pbar_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_evpbar.h>
class VDKBGuiForm;
class VDKBParser;
class VDKBProgressBar: public VDKBEvProgressBar, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKSpinButton * blockcount;
  VDKCombo* barstyle,*barorient;
  VDKCheckButton *activitymode;
  VDKEntry *min,*max;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBProgressBar(char* name,VDKForm* owner,
		 float min = 0.0,
		 float max = 1.0);
  virtual ~VDKBProgressBar() {}
  virtual int Type() { return vdkbclass_progressbar; }
  virtual char* VDKName() { return "VDKProgressBar"; }
  virtual int isA() { return vdkbclass_progressbar; }

  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnSetMin(VDKObject*);
  bool OnSetMax(VDKObject*);
  bool OnSetBlockCount(VDKObject*);
  bool OnSetBarStyle(VDKObject*);
  bool OnSetBarOrient(VDKObject*);
  bool OnSetActivityMode(VDKObject*);

  DECLARE_SIGNAL_LIST(VDKBProgressBar);
  DECLARE_EVENT_LIST(VDKBProgressBar);
};
#endif
