-- This file is  free  software, which  comes  along  with  SmallEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT 
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of 
-- another product.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr 
--                       http://www.loria.fr/SmallEiffel
--
class DIRECTORY
   --
   -- Tools for file-system directory handling.
   -- 
   -- Clean hight-level facade for class BASIC_DIRECTORY.
   --
creation connect_to

feature {NONE}

   basic_directory: BASIC_DIRECTORY;

feature

   is_connected: BOOLEAN;

feature -- Creation / Modification :

   connect_to(new_path: STRING) is
      require
         not new_path.empty
      do
         if basic_directory = Void then
            !!basic_directory.make;
         end;
         if basic_directory.set_path(new_path) then
            is_connected := true;
         else
            is_connected := false;
         end;
      end;

feature -- Access :

   lower: INTEGER is 1;
         -- Index of the first item.

   upper: INTEGER is
         -- Index of the last item.
      do
         if is_connected then
            Result := basic_directory.upper + 1;
         end;
      end;

   count: INTEGER is
         -- Number of items (files or directories) in Current.
      do
         if is_connected then
            Result := basic_directory.count;
         end;
      ensure
         Result >= 0
      end;

   valid_index(index: INTEGER): BOOLEAN is
      do
         if index >= 1 then
            if is_connected then
               Result := basic_directory.valid_index(index - 1);
            end;
         end;
      ensure
         Result = index.in_range(1,count)
      end;

   path: STRING is
      require
         is_connected
      do
         Result := basic_directory.path;
      end;

   name(index: INTEGER): STRING is
         -- Return the name of entry (file or subdirectory) at `index'.
      require
         is_connected;
         valid_index(index)
      do
         Result := basic_directory.name(index - 1);
      ensure
         has(Result)
      end;

   has(entry_name: STRING): BOOLEAN is
         -- Does Current contain the `entry_name' (file or subdirectory) ?
      require
         is_connected;
         not entry_name.empty
      do
         Result := basic_directory.has(entry_name);
      end;


end -- DIRECTORY

